/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.discussion;

import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.discussion.AbstractDiscussionWebScript;
import org.alfresco.service.cmr.discussion.PostInfo;
import org.alfresco.service.cmr.discussion.TopicInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ForumTopicPost
extends AbstractDiscussionWebScript {
    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nodeRef, TopicInfo topic, PostInfo post, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        if (topic != null || post != null) {
            String error = "Can't create a new Topic inside an existing Topic or Post";
            throw new WebScriptException(400, error);
        }
        String title = "";
        String contents = "";
        if (json.containsKey((Object)"title")) {
            title = (String)json.get((Object)"title");
        }
        if (json.containsKey((Object)"content")) {
            contents = (String)json.get((Object)"content");
        }
        List<String> tags = this.getTags(json);
        topic = site != null ? this.discussionService.createTopic(site.getShortName(), title) : this.discussionService.createTopic(nodeRef, title);
        if (tags != null && tags.size() > 0) {
            topic.getTags().clear();
            topic.getTags().addAll(tags);
            this.discussionService.updateTopic(topic);
        }
        post = this.discussionService.createPost(topic, contents);
        this.addActivityEntry("post", "created", topic, post, site, req, json);
        Map<String, Object> model = this.buildCommonModel(site, topic, post, req);
        model.put("postData", this.renderTopic(topic, site));
        return model;
    }
}

