/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.LockMethod;
import org.alfresco.repo.webdav.PropFindMethod;
import org.alfresco.repo.webdav.WebDAV;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.TestWithUserUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class LockMethodTest {
    private LockMethod lockMethod;
    private PropFindMethod propFindMethod;
    private ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/remote-api-context.xml"});
    private WebDAVHelper davHelper;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private NodeService nodeService;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;
    private ContentService contentService;
    private FileFolderService fileFolderService;
    private static final String CONTENT_1 = "This is some content";
    private static final String TEST_FILE_NAME = "file" + GUID.generate();
    private static final String TEST_NEW_FILE_NAME = "new_file" + GUID.generate();
    private static final String TEST_FOLDER_NAME = "folder" + GUID.generate();
    private static final String TEST_NEW_FOLDER_NAME = "new_folder" + GUID.generate();
    private NodeRef folderNodeRef;
    private NodeRef fileNodeRef;
    private String userName;
    private static final String PWD = "password";

    @Before
    public void setUp() throws Exception {
        this.lockMethod = new LockMethod();
        this.propFindMethod = new PropFindMethod();
        this.transactionService = (TransactionService)this.applicationContext.getBean("TransactionService");
        this.davHelper = (WebDAVHelper)this.applicationContext.getBean("webDAVHelper");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestFileCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef rootNodeRef = LockMethodTest.this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
                LockMethodTest.this.userName = "webdavLockTest" + GUID.generate();
                TestWithUserUtils.createUser((String)LockMethodTest.this.userName, (String)LockMethodTest.PWD, (NodeRef)rootNodeRef, (NodeService)LockMethodTest.this.nodeService, (MutableAuthenticationService)LockMethodTest.this.authenticationService);
                LockMethodTest.this.permissionService.setPermission(rootNodeRef, LockMethodTest.this.userName, "All", true);
                TestWithUserUtils.authenticateUser((String)LockMethodTest.this.userName, (String)LockMethodTest.PWD, (NodeRef)rootNodeRef, (AuthenticationService)LockMethodTest.this.authenticationService);
                LockMethodTest.this.folderNodeRef = LockMethodTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test"), ContentModel.TYPE_FOLDER, Collections.singletonMap(ContentModel.PROP_NAME, TEST_FOLDER_NAME)).getChildRef();
                LockMethodTest.this.fileNodeRef = LockMethodTest.this.nodeService.createNode(LockMethodTest.this.folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test"), ContentModel.TYPE_CONTENT, Collections.singletonMap(ContentModel.PROP_NAME, TEST_FILE_NAME)).getChildRef();
                ContentWriter contentWriter = LockMethodTest.this.contentService.getWriter(LockMethodTest.this.fileNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter.setMimetype("text/plain");
                contentWriter.setEncoding("UTF-8");
                contentWriter.putContent(LockMethodTest.CONTENT_1);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createTestFileCallback);
    }

    @After
    public void tearDown() {
        this.lockMethod = null;
        this.propFindMethod = null;
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteTestFolderCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (LockMethodTest.this.nodeService.exists(LockMethodTest.this.folderNodeRef)) {
                    LockMethodTest.this.nodeService.deleteNode(LockMethodTest.this.folderNodeRef);
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteTestFolderCallback);
    }

    @Test
    public void testRefreshLock() throws Exception {
        MockHttpServletRequest lockRequest = new MockHttpServletRequest();
        lockRequest.addHeader("Timeout", (Object)"Second-5");
        lockRequest.setRequestURI("/" + TEST_FILE_NAME);
        Object content = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:lockinfo xmlns:D=\"DAV:\"><D:lockscope xmlns:D=\"DAV:\"><D:exclusive xmlns:D=\"DAV:\"/></D:lockscope><D:locktype xmlns:D=\"DAV:\"><D:write xmlns:D=\"DAV:\"/></D:locktype><D:owner xmlns:D=\"DAV:\">" + this.userName + "</D:owner></D:lockinfo>";
        lockRequest.setContent(((String)content).getBytes("UTF-8"));
        this.lockMethod.setDetails((HttpServletRequest)lockRequest, (HttpServletResponse)new MockHttpServletResponse(), this.davHelper, this.folderNodeRef);
        this.lockMethod.parseRequestHeaders();
        this.lockMethod.parseRequestBody();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> lockExecuteImplCallBack = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                LockMethodTest.this.lockMethod.executeImpl();
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockExecuteImplCallBack);
        RetryingTransactionHelper.RetryingTransactionCallback<LockInfo> getNodeLockInfoCallBack = new RetryingTransactionHelper.RetryingTransactionCallback<LockInfo>(){

            public LockInfo execute() throws Throwable {
                return LockMethodTest.this.lockMethod.getNodeLockInfo(LockMethodTest.this.fileFolderService.getFileInfo(LockMethodTest.this.fileNodeRef));
            }
        };
        LockInfo lockInfo = (LockInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getNodeLockInfoCallBack);
        Assert.assertNotNull((Object)lockInfo);
        Thread.sleep(1000L);
        String lockToken = this.fileNodeRef.getId() + ":" + this.userName;
        String lockHeaderValue = "(<opaquelocktoken:" + lockToken + ">)";
        lockRequest.addHeader("If", (Object)lockHeaderValue);
        this.lockMethod.parseRequestHeaders();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockExecuteImplCallBack);
        LockInfo updatedLockInfo = (LockInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getNodeLockInfoCallBack);
        Assert.assertNotNull((Object)updatedLockInfo);
        Assert.assertEquals((String)"Lock owner should not change after lock refresh.", (Object)lockInfo.getOwner(), (Object)updatedLockInfo.getOwner());
        Assert.assertEquals((String)"Lock token should not change after lock refresh.", (Object)lockInfo.getExclusiveLockToken(), (Object)updatedLockInfo.getExclusiveLockToken());
        Assert.assertFalse((String)"Expires was not updated.", (boolean)lockInfo.getExpires().equals(updatedLockInfo.getExpires()));
        Assert.assertTrue((String)"Expires was updated incorrectly.", (boolean)lockInfo.getExpires().before(updatedLockInfo.getExpires()));
        MockHttpServletRequest propFindRequest = new MockHttpServletRequest();
        propFindRequest.setRequestURI("/" + TEST_FILE_NAME);
        propFindRequest.addHeader("Depth", (Object)"1");
        content = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getlastmodified/><D:getcontentlength/><D:resourcetype/><D:supportedlock/><D:lockdiscovery/></D:prop></D:propfind>";
        propFindRequest.setContent(((String)content).getBytes("UTF-8"));
        MockHttpServletResponse propfindResponse = new MockHttpServletResponse();
        this.propFindMethod.setDetails((HttpServletRequest)propFindRequest, (HttpServletResponse)propfindResponse, this.davHelper, this.folderNodeRef);
        this.propFindMethod.parseRequestHeaders();
        this.propFindMethod.parseRequestBody();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> propfindExecuteImplCallBack = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                LockMethodTest.this.propFindMethod.executeImpl();
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)propfindExecuteImplCallBack);
        String response = propfindResponse.getContentAsString();
        Assert.assertFalse((String)"Propfind response should contain lock informarion.", (response.indexOf("lockdiscovery") == -1 ? 1 : 0) != 0);
        Thread.sleep(6000L);
        propfindResponse = new MockHttpServletResponse();
        this.propFindMethod.setDetails((HttpServletRequest)propFindRequest, (HttpServletResponse)propfindResponse, this.davHelper, this.folderNodeRef);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)propfindExecuteImplCallBack);
        response = propfindResponse.getContentAsString();
        Assert.assertTrue((String)"Propfind response should not conatain information about expired lock", (response.indexOf("lockdiscovery") == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testMNT_10873() throws Exception {
        String fileName = TEST_FILE_NAME + GUID.generate();
        final MockHttpServletRequest lockRequest = new MockHttpServletRequest();
        MockHttpServletResponse lockResponse = new MockHttpServletResponse();
        lockRequest.addHeader("Timeout", (Object)"Second-5");
        lockRequest.setRequestURI("/" + fileName);
        String content = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:lockinfo xmlns:D=\"DAV:\"><D:lockscope xmlns:D=\"DAV:\"><D:exclusive xmlns:D=\"DAV:\"/></D:lockscope><D:locktype xmlns:D=\"DAV:\"><D:write xmlns:D=\"DAV:\"/></D:locktype><D:owner xmlns:D=\"DAV:\">" + this.userName + "</D:owner></D:lockinfo>";
        lockRequest.setContent(content.getBytes("UTF-8"));
        this.lockMethod.setDetails((HttpServletRequest)lockRequest, (HttpServletResponse)lockResponse, this.davHelper, this.folderNodeRef);
        this.lockMethod.parseRequestHeaders();
        this.lockMethod.parseRequestBody();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> lockExecuteImplCallBack = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                LockMethodTest.this.lockMethod.executeImpl();
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockExecuteImplCallBack);
        Assert.assertEquals((String)"Unexpected response status code.", (long)201L, (long)lockResponse.getStatus());
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> getNodeRefCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                return LockMethodTest.this.lockMethod.getNodeForPath(LockMethodTest.this.folderNodeRef, lockRequest.getRequestURI()).getNodeRef();
            }
        };
        NodeRef nodeRef = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)getNodeRefCallback);
        Assert.assertTrue((String)"NodeRef should exists.", (boolean)this.nodeService.exists(nodeRef));
        Assert.assertTrue((String)"sys:webdavNoContent aspect should be applied on node.", (boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WEBDAV_NO_CONTENT));
        Thread.sleep(6000L);
        Assert.assertFalse((String)"File should note exist in repo any more.", (boolean)this.nodeService.exists(nodeRef));
        Assert.assertFalse((String)"File should note exist in trashcan.", (boolean)this.nodeService.exists(new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, nodeRef.getId())));
    }

    @Test
    public void testMNT_11990() throws Exception {
        MockHttpServletRequest lockRequest = new MockHttpServletRequest();
        lockRequest.addHeader("Timeout", (Object)"Second-3600");
        lockRequest.addHeader("If", (Object)("(<" + WebDAV.makeLockToken((NodeRef)this.fileNodeRef, (String)this.userName) + ">)"));
        lockRequest.setRequestURI("/" + TEST_FILE_NAME);
        this.lockMethod.setDetails((HttpServletRequest)lockRequest, (HttpServletResponse)new MockHttpServletResponse(), this.davHelper, this.folderNodeRef);
        this.lockMethod.parseRequestHeaders();
        this.lockMethod.parseRequestBody();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> lockExecuteImplCallBack = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    LockMethodTest.this.lockMethod.executeImpl();
                    Assert.fail((String)"Lock should not be refreshed for non-locked file.");
                }
                catch (WebDAVServerException e) {
                    Assert.assertEquals((long)e.getHttpStatusCode(), (long)400L);
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockExecuteImplCallBack);
    }

    @Test
    public void testMNT_12425() throws Exception {
        MockHttpServletRequest lockRequest = new MockHttpServletRequest();
        MockHttpServletResponse lockResponse = new MockHttpServletResponse();
        lockRequest.addHeader("Timeout", (Object)"Second-3600");
        lockRequest.addHeader("If", (Object)("(<" + WebDAV.makeLockToken((NodeRef)this.fileNodeRef, (String)this.userName) + ">)"));
        lockRequest.setRequestURI("/" + TEST_NEW_FOLDER_NAME + "/" + TEST_NEW_FILE_NAME);
        this.lockMethod.setDetails((HttpServletRequest)lockRequest, (HttpServletResponse)lockResponse, this.davHelper, this.folderNodeRef);
        this.lockMethod.parseRequestHeaders();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> lockExecuteImplCallBack = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    LockMethodTest.this.lockMethod.executeImpl();
                    Assert.fail((String)"Refresh lock for non-exisitent resource should fail.");
                }
                catch (WebDAVServerException e) {
                    Assert.assertEquals((long)403L, (long)e.getHttpStatusCode());
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)lockExecuteImplCallBack);
    }
}

