/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.webdav.GetMethod;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class GetMethodTest {
    private GetMethod getMethod;
    private MockHttpServletRequest req;
    @Mock
    private HttpServletResponse resp;
    @Mock
    private WebDAVHelper davHelper;
    private NodeRef rootNode;
    @Mock
    private ContentReader reader;
    @Mock
    private FileInfo fileInfo;
    @Mock
    private Log logger;
    @Mock
    private ServiceRegistry serviceRegistry;
    @Mock
    private ContentService contentService;

    @Before
    public void setUp() throws Exception {
        this.getMethod = new GetMethod();
        this.req = new MockHttpServletRequest();
        this.rootNode = new NodeRef("workspace://SpacesStore/node-id");
        this.getMethod.setDetails((HttpServletRequest)this.req, this.resp, this.davHelper, this.rootNode);
        GetMethod.logger = this.logger;
        Mockito.when((Object)this.reader.getMimetype()).thenReturn((Object)"text/plain");
        Mockito.when((Object)this.logger.isErrorEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.logger.isDebugEnabled()).thenReturn((Object)true);
    }

    @Test
    public void readByteRangeContentDoesNotLogSocketExceptions() throws IOException, WebDAVServerException {
        Mockito.when((Object)this.davHelper.getServiceRegistry()).thenReturn((Object)this.serviceRegistry);
        Mockito.when((Object)this.serviceRegistry.getContentService()).thenReturn((Object)this.contentService);
        this.req.addHeader("Range", (Object)"bytes=500-1500");
        this.getMethod.parseRequestHeaders();
        SocketException sockEx = new SocketException("Client aborted connection");
        IOException ioEx = new IOException("Wrapping the socket exception.", sockEx);
        Mockito.when((Object)this.resp.getOutputStream()).thenThrow(new Throwable[]{ioEx});
        try {
            this.getMethod.readContent(this.fileInfo, this.reader);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (WebDAVServerException e) {
            ((Log)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.never())).error((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)ioEx));
            ((Log)Mockito.verify((Object)this.logger)).debug((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)ioEx));
            Assert.assertEquals((long)500L, (long)e.getHttpStatusCode());
            Assert.assertNull((Object)e.getCause());
        }
    }

    @Test
    public void readByteRangeContentLogsLegitimateExceptions() throws IOException, WebDAVServerException {
        Mockito.when((Object)this.davHelper.getServiceRegistry()).thenReturn((Object)this.serviceRegistry);
        Mockito.when((Object)this.serviceRegistry.getContentService()).thenReturn((Object)this.contentService);
        this.req.addHeader("Range", (Object)"bytes=500-1500");
        this.getMethod.parseRequestHeaders();
        RuntimeException rEx = new RuntimeException("Some sort of proper error");
        IOException ioEx = new IOException("Wrapping the exception.", rEx);
        Mockito.when((Object)this.resp.getOutputStream()).thenThrow(new Throwable[]{ioEx});
        try {
            this.getMethod.readContent(this.fileInfo, this.reader);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (WebDAVServerException e) {
            ((Log)Mockito.verify((Object)this.logger)).error((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)ioEx));
            ((Log)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.never())).debug((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)ioEx));
            Assert.assertEquals((long)500L, (long)e.getHttpStatusCode());
            Assert.assertNull((Object)e.getCause());
        }
    }

    @Test
    public void readContentDoesNotLogSocketExceptions() throws IOException, WebDAVServerException {
        SocketException sockEx = new SocketException("Client aborted connection");
        ContentIOException contentEx = new ContentIOException("Wrapping the socket exception.", (Throwable)sockEx);
        ((ContentReader)Mockito.doThrow((Throwable[])new Throwable[]{contentEx}).when((Object)this.reader)).getContent((OutputStream)ArgumentMatchers.nullable(OutputStream.class));
        try {
            this.getMethod.readContent(this.fileInfo, this.reader);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (WebDAVServerException e) {
            ((Log)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.never())).error((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)contentEx));
            ((Log)Mockito.verify((Object)this.logger)).debug((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)contentEx));
            Assert.assertEquals((long)500L, (long)e.getHttpStatusCode());
            Assert.assertNull((Object)e.getCause());
        }
    }

    @Test
    public void readContentLogsLegitimateExceptions() throws IOException, WebDAVServerException {
        RuntimeException rEx = new RuntimeException("Some sort of proper error");
        ContentIOException contentEx = new ContentIOException("Wrapping the exception.", (Throwable)rEx);
        ((ContentReader)Mockito.doThrow((Throwable[])new Throwable[]{contentEx}).when((Object)this.reader)).getContent((OutputStream)ArgumentMatchers.nullable(OutputStream.class));
        try {
            this.getMethod.readContent(this.fileInfo, this.reader);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (WebDAVServerException e) {
            ((Log)Mockito.verify((Object)this.logger)).error((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)contentEx));
            ((Log)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.never())).debug((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)contentEx));
            Assert.assertEquals((long)500L, (long)e.getHttpStatusCode());
            Assert.assertNull((Object)e.getCause());
        }
    }

    @Test
    public void readByteRangeContentDoesNotLogClientAbortException() throws IOException, WebDAVServerException {
        Mockito.when((Object)this.davHelper.getServiceRegistry()).thenReturn((Object)this.serviceRegistry);
        Mockito.when((Object)this.serviceRegistry.getContentService()).thenReturn((Object)this.contentService);
        this.req.addHeader("Range", (Object)"bytes=500-1500");
        this.getMethod.parseRequestHeaders();
        ClientAbortException caEx = new ClientAbortException();
        IOException ioEx = new IOException("Wrapping the socket exception.", caEx);
        Mockito.when((Object)this.resp.getOutputStream()).thenThrow(new Throwable[]{ioEx});
        try {
            this.getMethod.readContent(this.fileInfo, this.reader);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (WebDAVServerException e) {
            ((Log)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.never())).error((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)ioEx));
            ((Log)Mockito.verify((Object)this.logger)).debug((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)ioEx));
            Assert.assertEquals((long)500L, (long)e.getHttpStatusCode());
            Assert.assertNull((Object)e.getCause());
        }
    }

    @Test
    public void readContentDoesNotLogClientAbortException() throws IOException, WebDAVServerException {
        ClientAbortException caEx = new ClientAbortException();
        ContentIOException contentEx = new ContentIOException("Wrapping the socket exception.", (Throwable)caEx);
        ((ContentReader)Mockito.doThrow((Throwable[])new Throwable[]{contentEx}).when((Object)this.reader)).getContent((OutputStream)ArgumentMatchers.nullable(OutputStream.class));
        try {
            this.getMethod.readContent(this.fileInfo, this.reader);
            Assert.fail((String)"Exception should have been thrown.");
        }
        catch (WebDAVServerException e) {
            ((Log)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.never())).error((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)contentEx));
            ((Log)Mockito.verify((Object)this.logger)).debug((Object)Mockito.anyString(), (Throwable)Mockito.same((Object)contentEx));
            Assert.assertEquals((long)500L, (long)e.getHttpStatusCode());
            Assert.assertNull((Object)e.getCause());
        }
    }

    private static class ClientAbortException
    extends IOException {
        private ClientAbortException() {
        }
    }
}

