/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.web.scripts.servlet.X509ServletFilterBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AlfrescoX509ServletFilter
extends X509ServletFilterBase {
    private HttpClientFactory.SecureCommsType secureComms = HttpClientFactory.SecureCommsType.HTTPS;
    private String sharedSecret;
    private String sharedSecretHeader = "X-Alfresco-Search-Secret";
    private static final String BEAN_GLOBAL_PROPERTIES = "global-properties";
    private static final String PROP_SECURE_COMMS = "solr.secureComms";
    private static final String PROP_SHARED_SECRET = "solr.sharedSecret";
    private static final String PROP_SHARED_SECRET_HEADER = "solr.sharedSecret.header";
    private static Log logger = LogFactory.getLog(AlfrescoX509ServletFilter.class);

    public void init(FilterConfig config) throws ServletException {
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)config.getServletContext());
        Properties globalProperties = (Properties)wc.getBean(BEAN_GLOBAL_PROPERTIES);
        String secureCommsProp = globalProperties.getProperty(PROP_SECURE_COMMS);
        if (secureCommsProp != null && !secureCommsProp.isEmpty()) {
            this.secureComms = HttpClientFactory.SecureCommsType.getType((String)secureCommsProp);
        }
        this.sharedSecret = globalProperties.getProperty(PROP_SHARED_SECRET);
        this.sharedSecretHeader = globalProperties.getProperty(PROP_SHARED_SECRET_HEADER);
        if (this.secureComms == HttpClientFactory.SecureCommsType.SECRET) {
            if (this.sharedSecret == null || this.sharedSecret.length() == 0) {
                logger.fatal((Object)"Missing value for solr.sharedSecret configuration property. If solr.secureComms is set to \"secret\", a value for solr.sharedSecret is required. See https://docs.alfresco.com/search-services/latest/install/options/");
                throw new AlfrescoRuntimeException("Missing value for solr.sharedSecret configuration property");
            }
            if (this.sharedSecretHeader == null || this.sharedSecretHeader.length() == 0) {
                throw new AlfrescoRuntimeException("Missing value for sharedSecretHeader");
            }
        }
        if (this.secureComms == HttpClientFactory.SecureCommsType.NONE && !"true".equalsIgnoreCase(config.getInitParameter("allow-unauthenticated-solr-endpoint"))) {
            throw new AlfrescoRuntimeException("solr.secureComms=none is no longer supported. Please use https or secret");
        }
        super.init(config);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        switch (this.secureComms) {
            case HTTPS: {
                super.doFilter(request, response, chain);
                return;
            }
            case SECRET: {
                if (this.sharedSecret.equals(httpRequest.getHeader(this.sharedSecretHeader))) {
                    chain.doFilter(request, response);
                } else {
                    httpResponse.sendError(403, "Authentication failure");
                }
                return;
            }
            case NONE: {
                chain.doFilter(request, response);
                return;
            }
        }
        httpResponse.sendError(403, "Authentication failure");
    }

    protected boolean checkEnforce(ServletContext servletContext) throws IOException {
        return this.secureComms == HttpClientFactory.SecureCommsType.HTTPS;
    }
}

