/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.rest.antlr.WhereClauseParser;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;

public class MapBasedQueryWalker
extends QueryHelper.WalkerCallbackAdapter {
    private Set<String> supportedEqualsParameters;
    private Set<String> supportedMatchesParameters;
    private Set<String> supportedGreaterThanParameters;
    private Set<String> supportedGreaterThanOrEqualParameters;
    private Set<String> supportedLessThanParameters;
    private Set<String> supportedLessThanOrEqualParameters;
    private Map<String, String> equalsProperties;
    private Map<String, String> matchesProperties;
    private Map<String, String> greaterThanProperties;
    private Map<String, String> greaterThanOrEqualProperties;
    private Map<String, String> lessThanProperties;
    private Map<String, String> lessThanOrEqualProperties;
    private List<QueryVariableHolder> variableProperties;
    private boolean variablesEnabled;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;

    public MapBasedQueryWalker(Set<String> supportedEqualsParameters, Set<String> supportedMatchesParameters) {
        this.supportedEqualsParameters = supportedEqualsParameters;
        this.supportedMatchesParameters = supportedMatchesParameters;
        this.equalsProperties = new HashMap<String, String>();
        this.matchesProperties = new HashMap<String, String>();
    }

    public void setSupportedGreaterThanParameters(Set<String> supportedGreaterThanParameters) {
        this.supportedGreaterThanParameters = supportedGreaterThanParameters;
        if (this.greaterThanProperties == null) {
            this.greaterThanProperties = new HashMap<String, String>();
        }
    }

    public void setSupportedGreaterThanOrEqualParameters(Set<String> supportedGreaterThanOrEqualParameters) {
        this.supportedGreaterThanOrEqualParameters = supportedGreaterThanOrEqualParameters;
        if (this.greaterThanOrEqualProperties == null) {
            this.greaterThanOrEqualProperties = new HashMap<String, String>();
        }
    }

    public void setSupportedLessThanParameters(Set<String> supportedLessThanParameters) {
        this.supportedLessThanParameters = supportedLessThanParameters;
        if (this.lessThanProperties == null) {
            this.lessThanProperties = new HashMap<String, String>();
        }
    }

    public void setSupportedLessThanOrEqualParameters(Set<String> supportedLessThanOrEqualParameters) {
        this.supportedLessThanOrEqualParameters = supportedLessThanOrEqualParameters;
        if (this.lessThanOrEqualProperties == null) {
            this.lessThanOrEqualProperties = new HashMap<String, String>();
        }
    }

    public void enableVariablesSupport(NamespaceService namespaceService, DictionaryService dictionaryService) {
        this.variablesEnabled = true;
        if (namespaceService == null) {
            throw new IllegalArgumentException("namespace service can't be null");
        }
        if (dictionaryService == null) {
            throw new IllegalArgumentException("dictionary service can't be null");
        }
        this.namespaceService = namespaceService;
        this.dictionaryService = dictionaryService;
        this.variableProperties = new ArrayList<QueryVariableHolder>();
    }

    public List<QueryVariableHolder> getVariableProperties() {
        return this.variableProperties;
    }

    @Override
    public void matches(String property, String value, boolean negated) {
        if (negated) {
            throw new InvalidArgumentException("Cannot use negated matching for property: " + property);
        }
        if (this.variablesEnabled && property.startsWith("variables/")) {
            this.processVariable(property, value, 20);
        } else if (this.supportedMatchesParameters != null && this.supportedMatchesParameters.contains(property)) {
            this.matchesProperties.put(property, value);
        } else {
            throw new InvalidArgumentException("Cannot use matching for property: " + property);
        }
    }

    @Override
    public void comparison(int type, String propertyName, String propertyValue, boolean negated) {
        if (this.variablesEnabled && propertyName.startsWith("variables/")) {
            this.processVariable(propertyName, propertyValue, type);
            return;
        }
        boolean throwError = false;
        if (type == 8) {
            if (this.supportedEqualsParameters != null && this.supportedEqualsParameters.contains(propertyName)) {
                this.equalsProperties.put(propertyName, propertyValue);
            } else {
                throwError = !this.handleUnmatchedComparison(type, propertyName, propertyValue);
            }
        } else if (type == 20) {
            if (this.supportedMatchesParameters != null && this.supportedMatchesParameters.contains(propertyName)) {
                this.matchesProperties.put(propertyName, propertyValue);
            } else {
                throwError = !this.handleUnmatchedComparison(type, propertyName, propertyValue);
            }
        } else if (type == 10) {
            if (this.supportedGreaterThanParameters != null && this.supportedGreaterThanParameters.contains(propertyName)) {
                this.greaterThanProperties.put(propertyName, propertyValue);
            } else {
                throwError = !this.handleUnmatchedComparison(type, propertyName, propertyValue);
            }
        } else if (type == 11) {
            if (this.supportedGreaterThanOrEqualParameters != null && this.supportedGreaterThanOrEqualParameters.contains(propertyName)) {
                this.greaterThanOrEqualProperties.put(propertyName, propertyValue);
            } else {
                throwError = !this.handleUnmatchedComparison(type, propertyName, propertyValue);
            }
        } else if (type == 18) {
            if (this.supportedLessThanParameters != null && this.supportedLessThanParameters.contains(propertyName)) {
                this.lessThanProperties.put(propertyName, propertyValue);
            } else {
                throwError = !this.handleUnmatchedComparison(type, propertyName, propertyValue);
            }
        } else if (type == 19) {
            if (this.supportedLessThanOrEqualParameters != null && this.supportedLessThanOrEqualParameters.contains(propertyName)) {
                this.lessThanOrEqualProperties.put(propertyName, propertyValue);
            } else {
                throwError = !this.handleUnmatchedComparison(type, propertyName, propertyValue);
            }
        } else {
            boolean bl = throwError = !this.handleUnmatchedComparison(type, propertyName, propertyValue);
        }
        if (throwError) {
            throw new InvalidArgumentException("framework.exception.InvalidProperty", new Object[]{propertyName, propertyValue, WhereClauseParser.tokenNames[type]});
        }
        if (negated) {
            throw new InvalidArgumentException("Cannot use NOT for " + WhereClauseParser.tokenNames[type] + " comparison.");
        }
    }

    public String getProperty(String propertyName, int type) {
        if (type == 8) {
            return this.equalsProperties.get(propertyName);
        }
        if (type == 20) {
            return this.matchesProperties.get(propertyName);
        }
        if (type == 10 && this.greaterThanProperties != null) {
            return this.greaterThanProperties.get(propertyName);
        }
        if (type == 11 && this.greaterThanOrEqualProperties != null) {
            return this.greaterThanOrEqualProperties.get(propertyName);
        }
        if (type == 18 && this.lessThanProperties != null) {
            return this.lessThanProperties.get(propertyName);
        }
        if (type == 19 && this.lessThanOrEqualProperties != null) {
            return this.lessThanOrEqualProperties.get(propertyName);
        }
        throw new IllegalArgumentException("type " + type + " is not supported");
    }

    public <T> T getProperty(String propertyName, int type, Class<T> returnType) {
        if (returnType == null) {
            throw new IllegalArgumentException("ReturnType cannot be null");
        }
        try {
            Object result = null;
            String stringValue = this.getProperty(propertyName, type);
            if (stringValue != null && (result = ConvertUtils.convert((String)stringValue, returnType)) instanceof String && !returnType.equals(String.class)) {
                throw new IllegalArgumentException("Unable to convert parameter to type: " + returnType.getName());
            }
            return (T)result;
        }
        catch (ConversionException ce) {
            throw new InvalidArgumentException("Query property value for '" + propertyName + "' should be a valid " + returnType.getSimpleName());
        }
    }

    @Override
    public void and() {
    }

    protected void processVariable(String propertyName, String propertyValue, int type) {
        String localPropertyName = propertyName.replaceFirst("variables/", "");
        Object actualValue = null;
        DataTypeDefinition dataTypeDefinition = null;
        String scopeDef = "global";
        if (localPropertyName.contains("local/")) {
            scopeDef = "local";
            localPropertyName = localPropertyName.replaceFirst("local/", "");
        }
        if (localPropertyName.contains("global/")) {
            localPropertyName = localPropertyName.replaceFirst("global/", "");
        }
        if ((propertyValue.contains("_") || propertyValue.contains(":")) && propertyValue.contains(" ")) {
            int indexOfSpace = propertyValue.indexOf(32);
            if (propertyValue.contains("_") && indexOfSpace > propertyValue.indexOf("_") || propertyValue.contains(":") && indexOfSpace > propertyValue.indexOf(":")) {
                String typeDef = propertyValue.substring(0, indexOfSpace);
                try {
                    QName dataType = QName.createQName((String)typeDef.replace('_', ':'), (NamespacePrefixResolver)this.namespaceService);
                    dataTypeDefinition = this.dictionaryService.getDataType(dataType);
                    propertyValue = propertyValue.substring(indexOfSpace + 1);
                }
                catch (Exception e) {
                    throw new ApiException("Error translating propertyName " + propertyName + " with value " + propertyValue);
                }
            }
        }
        actualValue = dataTypeDefinition != null && "java.util.Date".equalsIgnoreCase(dataTypeDefinition.getJavaClassName()) ? ISO8601DateFormat.parse((String)propertyValue) : (dataTypeDefinition != null ? DefaultTypeConverter.INSTANCE.convert(dataTypeDefinition, (Object)propertyValue) : propertyValue);
        this.variableProperties.add(new QueryVariableHolder(localPropertyName, type, actualValue, scopeDef));
    }

    protected boolean handleUnmatchedComparison(int type, String propertyName, String propertyValue) {
        return false;
    }

    public static class QueryVariableHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String propertyName;
        private int operator;
        private Object propertyValue;
        private String scope;

        public QueryVariableHolder() {
        }

        public QueryVariableHolder(String propertyName, int operator, Object propertyValue, String scope) {
            this.propertyName = propertyName;
            this.operator = operator;
            this.propertyValue = propertyValue;
            this.scope = scope;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public int getOperator() {
            return this.operator;
        }

        public void setOperator(int operator) {
            this.operator = operator;
        }

        public Object getPropertyValue() {
            return this.propertyValue;
        }

        public void setPropertyValue(Object propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public boolean isGlobalScope() {
            return "global".equals(this.scope);
        }
    }
}

