/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import java.io.IOException;
import java.util.Locale;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.repo.search.impl.solr.SolrSQLJSONResultSet;
import org.alfresco.repo.security.permissions.impl.acegi.FilteringResultSet;
import org.alfresco.rest.api.search.impl.ResultMapper;
import org.alfresco.rest.api.search.impl.SearchMapper;
import org.alfresco.rest.api.search.model.SearchSQLQuery;
import org.alfresco.rest.api.search.model.TupleList;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rest.framework.tools.RequestReader;
import org.alfresco.rest.framework.tools.ResponseWriter;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class SearchSQLApiWebscript
extends AbstractWebScript
implements RecognizedParamsExtractor,
RequestReader,
ResponseWriter,
InitializingBean {
    private ServiceRegistry serviceRegistry;
    private SearchService searchService;
    private SearchMapper searchMapper;
    private ResultMapper resultMapper;
    protected ApiAssistant assistant;
    protected ResourceWebScriptHelper helper;

    public void execute(WebScriptRequest webScriptRequest, WebScriptResponse res) throws IOException {
        try {
            SearchSQLQuery searchQuery = (SearchSQLQuery)this.extractJsonContent(webScriptRequest, this.assistant.getJsonHelper(), SearchSQLQuery.class);
            SearchParameters sparams = this.buildSearchParameters(searchQuery);
            ResultSet results = this.searchService.query(sparams);
            FilteringResultSet frs = (FilteringResultSet)results;
            SolrSQLJSONResultSet ssjr = (SolrSQLJSONResultSet)frs.getUnFilteredResultSet();
            if (searchQuery.getFormat().equalsIgnoreCase("solr")) {
                res.getWriter().write(ssjr.getSolrResponse());
            } else {
                CollectionWithPagingInfo<TupleList> nodes = this.resultMapper.toCollectionWithPagingInfo(ssjr.getDocs(), searchQuery);
                this.renderJsonResponse(res, nodes, this.assistant.getJsonHelper());
            }
            this.setResponse(res, DEFAULT_SUCCESS);
        }
        catch (Exception exception) {
            if (exception instanceof QueryParserException) {
                this.renderException(exception, res, this.assistant);
            }
            this.renderException((Exception)((Object)new WebScriptException(400, exception.getMessage())), res, this.assistant);
        }
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.serviceRegistry);
        this.searchService = this.serviceRegistry.getSearchService();
        ParameterCheck.mandatory((String)"assistant", (Object)this.assistant);
        ParameterCheck.mandatory((String)"searchMapper", (Object)this.searchMapper);
        ParameterCheck.mandatory((String)"resultMapper", (Object)this.resultMapper);
    }

    public SearchParameters buildSearchParameters(SearchSQLQuery searchQuery) {
        SearchParameters sparams = new SearchParameters();
        sparams.setLanguage("index-sql");
        sparams.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        if (StringUtils.isEmpty((CharSequence)searchQuery.getStmt())) {
            throw new AlfrescoRuntimeException("Required stmt parameter is missing.");
        }
        if (searchQuery.getFormat().equalsIgnoreCase("solr")) {
            sparams.addExtraParameter("format", "solr");
        }
        if (!StringUtils.isEmpty((CharSequence)searchQuery.getTimezone())) {
            sparams.setTimezone(searchQuery.getTimezone());
        }
        sparams.setQuery(searchQuery.getStmt());
        searchQuery.getLocales().forEach(action -> {
            Locale locale = new Locale((String)action);
            sparams.addLocale(locale);
        });
        searchQuery.getFilterQueries().forEach(arg_0 -> ((SearchParameters)sparams).addFilterQuery(arg_0));
        sparams.setIncludeMetadata(searchQuery.isIncludeMetadata());
        return sparams;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSearchMapper(SearchMapper searchMapper) {
        this.searchMapper = searchMapper;
    }

    public void setResultMapper(ResultMapper resultMapper) {
        this.resultMapper = resultMapper;
    }

    public void setAssistant(ApiAssistant assistant) {
        this.assistant = assistant;
    }

    public void setHelper(ResourceWebScriptHelper helper) {
        this.helper = helper;
    }
}

