/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.Queries;
import org.alfresco.rest.api.Sites;
import org.alfresco.rest.api.impl.Util;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.Person;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.resource.parameters.SortColumn;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.AlfrescoCollator;
import org.alfresco.util.ISO9075;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.SearchLanguageConversion;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class QueriesImpl
implements Queries,
InitializingBean {
    private static final Map<String, QName> NODE_SORT_PARAMS_TO_QNAMES = QueriesImpl.sortParamsToQNames("name", ContentModel.PROP_NAME, "createdAt", ContentModel.PROP_CREATED, "modifiedAt", ContentModel.PROP_MODIFIED);
    private static final Map<String, QName> PEOPLE_SORT_PARAMS_TO_QNAMES = QueriesImpl.sortParamsToQNames("id", ContentModel.PROP_USERNAME, ContentModel.PROP_FIRSTNAME, ContentModel.PROP_LASTNAME);
    private static final Map<String, QName> SITE_SORT_PARAMS_TO_QNAMES = QueriesImpl.sortParamsToQNames("id", ContentModel.PROP_NAME, "title", ContentModel.PROP_TITLE, "description", ContentModel.PROP_DESCRIPTION);
    private ServiceRegistry sr;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private SiteService siteService;
    private Nodes nodes;
    private People people;
    private Sites sites;

    private static Map<String, QName> sortParamsToQNames(Object ... parameters) {
        HashMap<String, QName> map = new HashMap<String, QName>();
        for (int i = 0; i < parameters.length; ++i) {
            map.put(parameters[i] instanceof String ? (String)parameters[i++] : ((QName)parameters[i]).getLocalName(), (QName)parameters[i]);
        }
        return Collections.unmodifiableMap(map);
    }

    public void setServiceRegistry(ServiceRegistry sr) {
        this.sr = sr;
    }

    public void setNodes(Nodes nodes) {
        this.nodes = nodes;
    }

    public void setPeople(People people) {
        this.people = people;
    }

    public void setSites(Sites sites) {
        this.sites = sites;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"sr", (Object)this.sr);
        ParameterCheck.mandatory((String)"nodes", (Object)this.nodes);
        ParameterCheck.mandatory((String)"people", (Object)this.people);
        ParameterCheck.mandatory((String)"sites", (Object)this.sites);
        this.nodeService = this.sr.getNodeService();
        this.namespaceService = this.sr.getNamespaceService();
        this.dictionaryService = this.sr.getDictionaryService();
        this.siteService = this.sr.getSiteService();
    }

    @Override
    public CollectionWithPagingInfo<Node> findNodes(final Parameters parameters) {
        SearchService searchService = this.sr.getSearchService();
        return new AbstractQuery<Node>(this.nodeService, searchService){
            private final Map<String, UserInfo> mapUserInfo;
            {
                super(nodeService, searchService);
                this.mapUserInfo = new HashMap<String, UserInfo>(10);
            }

            @Override
            protected void buildQuery(StringBuilder query, String term, SearchParameters sp, String queryTemplateName) {
                String nodeTypeStr;
                sp.addQueryTemplate(queryTemplateName, "%(cm:name cm:title cm:description TEXT TAG)");
                String rootNodeId = parameters.getParameter("rootNodeId");
                if (rootNodeId != null) {
                    NodeRef nodeRef = QueriesImpl.this.nodes.validateOrLookupNode(rootNodeId, null);
                    query.append("PATH:\"").append(this.getQNamePath(nodeRef.getId())).append("//*\" AND (");
                }
                if (term != null) {
                    query.append("\"");
                    query.append(term);
                    query.append("\"");
                }
                if (rootNodeId != null) {
                    query.append(")");
                }
                if ((nodeTypeStr = parameters.getParameter("nodeType")) != null) {
                    QName filterNodeTypeQName = QueriesImpl.this.nodes.createQName(nodeTypeStr);
                    if (QueriesImpl.this.dictionaryService.getType(filterNodeTypeQName) == null) {
                        throw new InvalidArgumentException("Unknown filter nodeType: " + nodeTypeStr);
                    }
                    query.append(" AND (+TYPE:\"").append(nodeTypeStr).append("\")");
                    query.append(" AND -ASPECT:\"sys:hidden\" AND -cm:creator:system AND -QNAME:comment\\-* ");
                } else {
                    query.append(" AND (+TYPE:\"cm:content\" OR +TYPE:\"cm:folder\")");
                    query.append(" AND -TYPE:\"cm:thumbnail\" AND -TYPE:\"cm:failedThumbnail\" AND -TYPE:\"cm:rating\" AND -TYPE:\"fm:post\"");
                    query.append(" AND -TYPE:\"st:site\" AND -ASPECT:\"st:siteContainer\"");
                    query.append(" AND -ASPECT:\"sys:hidden\" AND -cm:creator:system AND -QNAME:comment\\-* ");
                }
            }

            private String getQNamePath(String nodeId) {
                NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, nodeId);
                HashMap<String, String> cache = new HashMap<String, String>();
                StringBuilder buf = new StringBuilder(128);
                Path path = null;
                try {
                    path = QueriesImpl.this.nodeService.getPath(nodeRef);
                }
                catch (InvalidNodeRefException inre) {
                    throw new EntityNotFoundException(nodeId);
                }
                for (Path.Element e : path) {
                    if (e instanceof Path.ChildAssocElement) {
                        QName qname = ((Path.ChildAssocElement)e).getRef().getQName();
                        if (qname == null) continue;
                        String prefix = (String)cache.get(qname.getNamespaceURI());
                        if (prefix == null) {
                            Collection prefixes = QueriesImpl.this.namespaceService.getPrefixes(qname.getNamespaceURI());
                            prefix = prefixes.size() != 0 ? (String)prefixes.iterator().next() : "";
                            cache.put(qname.getNamespaceURI(), prefix);
                        }
                        buf.append('/').append(prefix).append(':').append(ISO9075.encode((String)qname.getLocalName()));
                        continue;
                    }
                    buf.append('/').append(e.toString());
                }
                return buf.toString();
            }

            @Override
            protected List<Node> newList(int capacity) {
                return new ArrayList<Node>(capacity);
            }

            @Override
            protected Node convert(NodeRef nodeRef, List<String> includeParam) {
                return QueriesImpl.this.nodes.getFolderOrDocument(nodeRef, null, null, includeParam, this.mapUserInfo);
            }

            @Override
            protected String escapeTerm(String term) {
                term = term.trim();
                term = SearchLanguageConversion.escapeLuceneQuery((String)term);
                return term;
            }
        }.find(parameters, "term", 3, "keywords", AbstractQuery.Sort.IN_QUERY_SORT, NODE_SORT_PARAMS_TO_QNAMES, new SortColumn("modifiedAt", false));
    }

    @Override
    public CollectionWithPagingInfo<Person> findPeople(Parameters parameters) {
        SearchService searchService = this.sr.getSearchService();
        return new AbstractQuery<Person>(this.nodeService, searchService){

            @Override
            protected void buildQuery(StringBuilder query, String term, SearchParameters sp, String queryTemplateName) {
                sp.addQueryTemplate(queryTemplateName, "|%firstName OR |%lastName OR |%userName");
                sp.setExcludeTenantFilter(false);
                sp.setPermissionEvaluation(PermissionEvaluationMode.EAGER);
                query.append("TYPE:\"").append(ContentModel.TYPE_PERSON).append("\" AND (\"*");
                query.append(term);
                query.append("*\")");
            }

            @Override
            protected List<Person> newList(int capacity) {
                return new ArrayList<Person>(capacity);
            }

            @Override
            protected Person convert(NodeRef nodeRef, List<String> includeParam) {
                String personId = (String)((Object)QueriesImpl.this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
                Person person = QueriesImpl.this.people.getPerson(personId);
                return person;
            }
        }.find(parameters, "term", 2, "_PERSON", AbstractQuery.Sort.POST_QUERY_SORT, PEOPLE_SORT_PARAMS_TO_QNAMES, new SortColumn(PARAM_FIRSTNAME, true), new SortColumn(PARAM_LASTNAME, true));
    }

    @Override
    public CollectionWithPagingInfo<Site> findSites(Parameters parameters) {
        SearchService searchService = this.sr.getSearchService();
        return new AbstractQuery<Site>(this.nodeService, searchService){

            @Override
            protected void buildQuery(StringBuilder query, String term, SearchParameters sp, String queryTemplateName) {
                sp.addQueryTemplate(queryTemplateName, "%(cm:name cm:title cm:description)");
                sp.setExcludeTenantFilter(false);
                sp.setPermissionEvaluation(PermissionEvaluationMode.EAGER);
                query.append("TYPE:\"").append(SiteModel.TYPE_SITE).append("\" AND (\"*");
                query.append(term);
                query.append("*\")");
            }

            @Override
            protected List<Site> newList(int capacity) {
                return new ArrayList<Site>(capacity);
            }

            @Override
            protected Site convert(NodeRef nodeRef, List<String> includeParam) {
                return this.getSite(QueriesImpl.this.siteService.getSite(nodeRef), true);
            }

            private Site getSite(SiteInfo siteInfo, boolean includeRole) {
                String siteId = siteInfo.getShortName();
                String role = null;
                if (includeRole) {
                    role = QueriesImpl.this.sites.getSiteRole(siteId);
                }
                return new Site(siteInfo, role);
            }
        }.find(parameters, "term", 2, "_SITE", AbstractQuery.Sort.POST_QUERY_SORT, SITE_SORT_PARAMS_TO_QNAMES, new SortColumn("title", true));
    }

    public static abstract class AbstractQuery<T> {
        private final NodeService nodeService;
        private final SearchService searchService;

        public AbstractQuery(NodeService nodeService, SearchService searchService) {
            this.nodeService = nodeService;
            this.searchService = searchService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CollectionWithPagingInfo<T> find(Parameters parameters, String termName, int minTermLength, String queryTemplateName, Sort sort, Map<String, QName> sortParamsToQNames, SortColumn ... defaultSort) {
            List<SortColumn> defaultSortCols;
            SearchParameters sp = new SearchParameters();
            sp.setLanguage("fts-alfresco");
            sp.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            sp.setDefaultFieldName(queryTemplateName);
            String term = this.getTerm(parameters, termName, minTermLength);
            StringBuilder query = new StringBuilder();
            this.buildQuery(query, term, sp, queryTemplateName);
            sp.setQuery(query.toString());
            Paging paging = parameters.getPaging();
            PagingRequest pagingRequest = Util.getPagingRequest(paging);
            List<SortColumn> list = defaultSortCols = defaultSort != null ? Arrays.asList(defaultSort) : Collections.emptyList();
            if (sort == Sort.IN_QUERY_SORT) {
                this.addSortOrder(parameters, sortParamsToQNames, defaultSortCols, sp);
                sp.setSkipCount(pagingRequest.getSkipCount());
                sp.setMaxItems(pagingRequest.getMaxItems());
            }
            List<T> collection = null;
            try (ResultSet queryResults = null;){
                CollectionWithPagingInfo<T> collectionWithPagingInfo;
                queryResults = this.searchService.query(sp);
                List<NodeRef> nodeRefs = queryResults.getNodeRefs();
                if (sort == Sort.POST_QUERY_SORT) {
                    nodeRefs = this.postQuerySort(parameters, sortParamsToQNames, defaultSortCols, nodeRefs);
                }
                collection = this.newList(nodeRefs.size());
                List<String> includeParam = parameters.getInclude();
                for (NodeRef nodeRef : nodeRefs) {
                    T t = this.convert(nodeRef, includeParam);
                    collection.add(t);
                }
                if (sort == Sort.POST_QUERY_SORT) {
                    collectionWithPagingInfo = AbstractQuery.listPage(collection, paging);
                    return collectionWithPagingInfo;
                }
                collectionWithPagingInfo = CollectionWithPagingInfo.asPaged(paging, collection, queryResults.hasMore(), Long.valueOf(queryResults.getNumberFound()).intValue());
                return collectionWithPagingInfo;
            }
        }

        protected abstract void buildQuery(StringBuilder var1, String var2, SearchParameters var3, String var4);

        protected abstract List<T> newList(int var1);

        protected abstract T convert(NodeRef var1, List<String> var2);

        protected String getTerm(Parameters parameters, String termName, int minTermLength) {
            char c;
            String term = parameters.getParameter(termName);
            if (term == null) {
                throw new InvalidArgumentException("Query '" + termName + "' not specified");
            }
            term = this.escapeTerm(term);
            int cnt = 0;
            for (int i = 0; !(i >= term.length() || Character.isLetterOrDigit(c = term.charAt(i)) && ++cnt == minTermLength); ++i) {
            }
            if (cnt < minTermLength) {
                throw new InvalidArgumentException("Query '" + termName + "' is too short. Must have at least " + minTermLength + " alphanumeric chars");
            }
            return term;
        }

        protected String escapeTerm(String term) {
            term = term.trim();
            term = term.replace("\"", "");
            term = SearchLanguageConversion.escapeLuceneQuery((String)term);
            return term;
        }

        protected void addSortOrder(Parameters parameters, Map<String, QName> sortParamsToQNames, List<SortColumn> defaultSortCols, SearchParameters sp) {
            List<SortColumn> sortCols = this.getSorting(parameters, defaultSortCols);
            for (SortColumn sortCol : sortCols) {
                QName sortPropQName = sortParamsToQNames.get(sortCol.column);
                if (sortPropQName == null) {
                    throw new InvalidArgumentException("Invalid sort field: " + sortCol.column);
                }
                sp.addSort("@" + String.valueOf(sortPropQName), sortCol.asc);
            }
        }

        private List<SortColumn> getSorting(Parameters parameters, List<SortColumn> defaultSortCols) {
            List<SortColumn> sortCols = parameters.getSorting();
            if (sortCols == null || sortCols.size() == 0) {
                sortCols = defaultSortCols == null ? Collections.emptyList() : defaultSortCols;
            }
            return sortCols;
        }

        protected List<NodeRef> postQuerySort(Parameters parameters, Map<String, QName> sortParamsToQNames, List<SortColumn> defaultSortCols, List<NodeRef> nodeRefs) {
            final List<SortColumn> sortCols = this.getSorting(parameters, defaultSortCols);
            int sortColCount = sortCols.size();
            if (sortColCount > 0) {
                nodeRefs = new ArrayList<NodeRef>(nodeRefs);
                final ArrayList<QName> sortPropQNames = new ArrayList<QName>(sortColCount);
                for (SortColumn sortCol : sortCols) {
                    QName sortPropQName = sortParamsToQNames.get(sortCol.column);
                    if (sortPropQName == null) {
                        throw new InvalidArgumentException("Invalid sort field: " + sortCol.column);
                    }
                    sortPropQNames.add(sortPropQName);
                }
                final Collator col = AlfrescoCollator.getInstance((Locale)I18NUtil.getLocale());
                Collections.sort(nodeRefs, new Comparator<NodeRef>(){

                    @Override
                    public int compare(NodeRef n1, NodeRef n2) {
                        int result = 0;
                        for (int i = 0; i < sortCols.size(); ++i) {
                            SortColumn sortCol = (SortColumn)sortCols.get(i);
                            QName sortPropQName = (QName)sortPropQNames.get(i);
                            Serializable p1 = this.getProperty(n1, sortPropQName);
                            Serializable p2 = this.getProperty(n2, sortPropQName);
                            result = (p1 instanceof Long && p2 instanceof Long ? Long.compare((Long)p1, (Long)p2) : col.compare(p1.toString(), p2.toString())) * (sortCol.asc ? 1 : -1);
                            if (result != 0) break;
                        }
                        return result;
                    }

                    private Serializable getProperty(NodeRef nodeRef, QName sortPropQName) {
                        Serializable result = nodeService.getProperty(nodeRef, sortPropQName);
                        return result == null ? "" : result;
                    }
                });
            }
            return nodeRefs;
        }

        protected static <T> CollectionWithPagingInfo<T> listPage(List<T> result, Paging paging) {
            int skipCount = paging.getSkipCount();
            int pageSize = paging.getMaxItems();
            int pageEnd = skipCount + pageSize;
            ArrayList<T> page = new ArrayList<T>(pageSize);
            if (result == null) {
                result = Collections.emptyList();
            }
            Iterator<T> it = result.iterator();
            for (int counter = 0; counter < pageEnd && it.hasNext(); ++counter) {
                T element = it.next();
                if (counter < skipCount) continue;
                if (counter > pageEnd - 1) break;
                page.add(element);
            }
            int totalCount = result.size();
            boolean hasMoreItems = skipCount + page.size() < totalCount;
            return CollectionWithPagingInfo.asPaged(paging, page, hasMoreItems, totalCount);
        }

        public static enum Sort {
            IN_QUERY_SORT,
            POST_QUERY_SORT;

        }
    }
}

