/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.DefaultChildApplicationContextManager;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.PublicApiAuthenticatorFactory;
import org.alfresco.rest.api.impl.AuthenticationsImpl;
import org.alfresco.rest.api.model.LoginTicket;
import org.alfresco.rest.api.model.LoginTicketResponse;
import org.alfresco.rest.api.sites.SiteEntityResource;
import org.alfresco.rest.api.tests.InterceptingDefaultRemoteUserMapper;
import org.alfresco.rest.api.tests.InterceptingIdentityRemoteUserMapper;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Folder;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.apache.commons.codec.binary.Base64;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthenticationsTest
extends AbstractSingleNetworkSiteTest {
    private static final String TICKETS_URL = "tickets";
    private static final String TICKETS_API_NAME = "authentication";
    private PublicApiAuthenticatorFactory authFactory;
    private TransactionServiceImpl transactionService;

    @Before
    public void setUpAuthTest() {
        this.authFactory = (PublicApiAuthenticatorFactory)this.applicationContext.getBean("publicapi.authenticator");
        this.transactionService = (TransactionServiceImpl)this.applicationContext.getBean("transactionService");
    }

    @Test
    public void canDisableBasicAuthChallenge() throws Exception {
        this.authFactory.setUseBasicAuth(false);
        this.testAuthChallenge("AlfTicket");
    }

    @Test
    public void canEnableBasicAuthChallenge() throws Exception {
        this.authFactory.setUseBasicAuth(true);
        this.testAuthChallenge("Basic");
    }

    private void testAuthChallenge(String expectedScheme) throws Exception {
        this.setRequestContext(null);
        HttpResponse response = this.getAll(SiteEntityResource.class, this.getPaging(0, 100), null, 401);
        String authenticateHeader = response.getHeaders().get("WWW-Authenticate");
        Assert.assertNotNull((String)"Expected an authentication challenge", (Object)authenticateHeader);
        String authScheme = authenticateHeader.split(" ")[0];
        Assert.assertEquals((Object)expectedScheme, (Object)authScheme);
    }

    @Test
    public void testCreateValidateDeleteTicketAlfTicketParameter() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        this.setRequestContext(null);
        this.getAll(SiteEntityResource.class, paging, null, 401);
        LoginTicket loginRequest = new LoginTicket();
        this.post(TICKETS_URL, RestApiUtil.toJsonAsString(loginRequest), null, null, TICKETS_API_NAME, 400);
        loginRequest.setUserId(null);
        loginRequest.setPassword("user1Password");
        this.post(TICKETS_URL, RestApiUtil.toJsonAsString(loginRequest), null, null, TICKETS_API_NAME, 400);
        loginRequest.setUserId(user1);
        loginRequest.setPassword(null);
        this.post(TICKETS_URL, RestApiUtil.toJsonAsString(loginRequest), null, null, TICKETS_API_NAME, 400);
        loginRequest.setUserId(user1);
        loginRequest.setPassword("user1Password");
        HttpResponse response = this.post(TICKETS_URL, RestApiUtil.toJsonAsString(loginRequest), null, null, TICKETS_API_NAME, 201);
        LoginTicketResponse loginResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), LoginTicketResponse.class);
        Assert.assertNotNull((Object)loginResponse.getId());
        Assert.assertNotNull((Object)loginResponse.getUserId());
        Map<String, String> ticket = Collections.singletonMap("alf_ticket", loginResponse.getId());
        this.getAll(SiteEntityResource.class, paging, ticket, 200);
        this.getAll(SiteEntityResource.class, paging, Collections.singletonMap("alf_ticket", "TICKET_" + System.currentTimeMillis()), 401);
        this.getSingle(TICKETS_URL, loginResponse.getId(), ticket, null, TICKETS_API_NAME, 400);
        response = this.getSingle(TICKETS_URL, "-me-", ticket, null, TICKETS_API_NAME, 200);
        LoginTicketResponse validatedTicket = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), LoginTicketResponse.class);
        Assert.assertEquals((Object)loginResponse.getId(), (Object)validatedTicket.getId());
        this.getSingle(TICKETS_URL, loginResponse.getId(), ticket, null, TICKETS_API_NAME, 400);
        this.delete(TICKETS_URL, "-me-", ticket, null, TICKETS_API_NAME, 204);
        this.getSingle(TICKETS_URL, "-me-", ticket, null, TICKETS_API_NAME, 401);
        this.setRequestContext(user1);
        response = this.getSingle(TICKETS_URL, "-me-", ticket, null, TICKETS_API_NAME, 404);
        PublicApiClient.ExpectedErrorResponse error = RestApiUtil.parseErrorResponse(response.getJsonResponse());
        Assert.assertEquals((long)404L, (long)error.getStatusCode());
        this.delete(TICKETS_URL, "-me-", ticket, null, TICKETS_API_NAME, 404);
        this.setRequestContext(null);
        this.getAll(SiteEntityResource.class, paging, ticket, 401);
    }

    @Test
    public void testCreateValidateDeleteTicketViaBasicAuthHeader() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        this.setRequestContext(null);
        this.getAll(SiteEntityResource.class, paging, null, 401);
        LoginTicket loginRequest = new LoginTicket();
        this.post(TICKETS_URL, RestApiUtil.toJsonAsString(loginRequest), null, null, TICKETS_API_NAME, 400);
        loginRequest.setUserId(null);
        loginRequest.setPassword("user1Password");
        this.post(TICKETS_URL, RestApiUtil.toJsonAsString(loginRequest), null, null, TICKETS_API_NAME, 400);
        this.setRequestContext(user2);
        Folder folderResp = this.createFolder("-my-", "F2", null);
        Assert.assertNotNull((Object)folderResp.getId());
        this.setRequestContext(null);
        this.getAll(this.getNodeChildrenUrl("-my-"), paging, 401);
        loginRequest = new LoginTicket();
        loginRequest.setUserId(user2);
        loginRequest.setPassword("wrongPassword");
        this.post(TICKETS_URL, RestApiUtil.toJsonAsString(loginRequest), null, null, TICKETS_API_NAME, 403);
        loginRequest.setUserId(user1);
        loginRequest.setPassword("user2Password");
        this.post(TICKETS_URL, RestApiUtil.toJsonAsString(loginRequest), null, null, TICKETS_API_NAME, 403);
        loginRequest.setUserId(user2);
        loginRequest.setPassword("user2Password");
        HttpResponse response = this.post(TICKETS_URL, RestApiUtil.toJsonAsString(loginRequest), null, null, TICKETS_API_NAME, 201);
        LoginTicketResponse loginResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), LoginTicketResponse.class);
        Assert.assertNotNull((Object)loginResponse.getId());
        Assert.assertNotNull((Object)loginResponse.getUserId());
        String encodedTicket = this.encodeB64(loginResponse.getId());
        Map<String, CallSite> header = Collections.singletonMap("Authorization", "Basic " + encodedTicket);
        response = this.getAll(this.getNodeChildrenUrl("-my-"), paging, null, header, 200);
        List<Document> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        Assert.assertEquals((long)1L, (long)nodes.size());
        this.getSingle(TICKETS_URL, loginResponse.getId(), null, header, TICKETS_API_NAME, 400);
        response = this.getSingle(TICKETS_URL, "-me-", null, header, TICKETS_API_NAME, 200);
        LoginTicketResponse validatedTicket = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), LoginTicketResponse.class);
        Assert.assertEquals((Object)loginResponse.getId(), (Object)validatedTicket.getId());
        header = Collections.singletonMap("Authorization", "bearer " + encodedTicket);
        response = this.getSingle(TICKETS_URL, "-me-", null, header, TICKETS_API_NAME, 401);
        header = Collections.singletonMap("Authorization", "junk " + encodedTicket);
        response = this.getSingle(TICKETS_URL, "-me-", null, header, TICKETS_API_NAME, 401);
        String encodedUserIdAndTicket = this.encodeB64("ROLE_TICKET:" + loginResponse.getId());
        header = Collections.singletonMap("Authorization", "Basic " + encodedUserIdAndTicket);
        response = this.getAll(this.getNodeChildrenUrl("-my-"), paging, null, header, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        Assert.assertEquals((long)1L, (long)nodes.size());
        encodedUserIdAndTicket = this.encodeB64("ROLE_TICKET:" + loginResponse.getId());
        header = Collections.singletonMap("Authorization", "bearer " + encodedUserIdAndTicket);
        response = this.getAll(this.getNodeChildrenUrl("-my-"), paging, null, header, 401);
        Map<String, String> ticket = Collections.singletonMap("alf_ticket", loginResponse.getId());
        response = this.getAll(this.getNodeChildrenUrl("-my-"), paging, ticket, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
        Assert.assertEquals((long)1L, (long)nodes.size());
        this.setRequestContext(user2);
        this.getSingle(TICKETS_URL, "-me-", null, null, TICKETS_API_NAME, 400);
        this.setRequestContext(null);
        header = Collections.singletonMap("Authorization", "Basic " + encodedUserIdAndTicket);
        this.delete(TICKETS_URL, loginResponse.getId(), null, header, TICKETS_API_NAME, 400);
        this.delete(TICKETS_URL, "-me-", null, header, TICKETS_API_NAME, 204);
        this.getAll(this.getNodeChildrenUrl("-my-"), paging, null, header, 401);
    }

    @Test
    public void testGetTicketViaBearerAuthHeaderWithExternalAuthentication() throws Exception {
        RemoteUserMapper originalRemoteUserMapper = (RemoteUserMapper)this.applicationContext.getBean("RemoteUserMapper");
        try {
            this.checkGetTicketViaBearerAuthHeader(false);
        }
        finally {
            this.resetAuthentication(originalRemoteUserMapper);
        }
    }

    @Test
    public void testGetTicketViaBearerAuthHeaderWithAlfrescoIdentityService() throws Exception {
        RemoteUserMapper originalRemoteUserMapper = (RemoteUserMapper)this.applicationContext.getBean("RemoteUserMapper");
        try {
            this.checkGetTicketViaBearerAuthHeader(true);
        }
        finally {
            this.resetAuthentication(originalRemoteUserMapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTicketLoginSystemReadOnly() throws Exception {
        QName veto = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"TestVeto");
        try {
            this.transactionService.setAllowWrite(false, veto);
            LoginTicket loginRequest = new LoginTicket();
            loginRequest.setUserId(user1);
            loginRequest.setPassword("user1Password");
            HttpResponse response = this.post(TICKETS_URL, RestApiUtil.toJsonAsString(loginRequest), null, null, TICKETS_API_NAME, 201);
            LoginTicketResponse validatedTicket = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), LoginTicketResponse.class);
            Map<String, String> ticket = Collections.singletonMap("alf_ticket", validatedTicket.getId());
            this.delete(TICKETS_URL, "-me-", ticket, null, TICKETS_API_NAME, 204);
        }
        finally {
            this.transactionService.setAllowWrite(true, veto);
        }
    }

    private void resetAuthentication(RemoteUserMapper originalRemoteUserMapper) {
        DefaultChildApplicationContextManager childApplicationContextManager = (DefaultChildApplicationContextManager)this.applicationContext.getBean("Authentication");
        PublicApiAuthenticatorFactory publicApiAuthenticatorFactory = (PublicApiAuthenticatorFactory)this.applicationContext.getBean("publicapi.authenticator");
        String chain = "alfrescoNtlm1:alfrescoNtlm";
        childApplicationContextManager.stop();
        childApplicationContextManager.setProperty("chain", chain);
        ChildApplicationContextFactory childApplicationContextFactory = childApplicationContextManager.getChildApplicationContextFactory("alfrescoNtlm1");
        childApplicationContextFactory.stop();
        childApplicationContextFactory.start();
        publicApiAuthenticatorFactory = (PublicApiAuthenticatorFactory)this.applicationContext.getBean("publicapi.authenticator");
        publicApiAuthenticatorFactory.setRemoteUserMapper(originalRemoteUserMapper);
        AuthenticationsImpl authentications = (AuthenticationsImpl)this.applicationContext.getBean("authentications");
        authentications.setRemoteUserMapper(originalRemoteUserMapper);
    }

    private void checkGetTicketViaBearerAuthHeader(boolean useIdentityService) throws Exception {
        String folderName = "F2_" + GUID.generate();
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        Object loginRequest = null;
        LoginTicketResponse validatedTicket = null;
        HttpResponse response = null;
        HashMap<String, String> header = new HashMap<String, String>();
        this.runPreCheckToEnsureBasicFunctionalityWorks(folderName, paging);
        RemoteUserMapper remoteUserMapper = this.createRemoteUserMapperToUseForTheTest(useIdentityService);
        this.setupAuthChainForTest(useIdentityService, remoteUserMapper);
        if (!useIdentityService) {
            header.put("X-Alfresco-Remote-User", this.buildUserNameMultiTenancyAware());
            response = this.getAll(this.getNodeChildrenUrl("-my-"), paging, null, header, 200);
            List<Document> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Document.class);
            Assert.assertEquals((long)0L, (long)nodes.size());
        }
        this.getSingle(TICKETS_URL, "-me-", null, header, TICKETS_API_NAME, 400);
        HashMap<String, String> headersWtihBasicAuth = new HashMap<String, String>(header);
        headersWtihBasicAuth.put("Authorization", "basic " + this.encodeB64("someRandomString"));
        this.getSingle(TICKETS_URL, "-me-", null, headersWtihBasicAuth, TICKETS_API_NAME, 404);
        this.checkRemoteUserMapperWasCalled(useIdentityService);
        this.reset(useIdentityService);
        headersWtihBasicAuth = new HashMap<String, String>(header);
        headersWtihBasicAuth.put("Authorization", "basic " + this.encodeB64(user2 + ":user2password"));
        this.getSingle(TICKETS_URL, "-me-", null, headersWtihBasicAuth, TICKETS_API_NAME, 400);
        this.checkRemoteUserMapperWasCalled(useIdentityService);
        this.reset(useIdentityService);
        header.put("Authorization", "bearer someOtherRandomString");
        response = this.getSingle(TICKETS_URL, "-me-", null, header, TICKETS_API_NAME, 200);
        validatedTicket = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), LoginTicketResponse.class);
        Assert.assertNotNull((String)"We should have gotten a valid ticket id", (Object)validatedTicket.getId());
        this.checkRemoteUserMapperWasCalled(useIdentityService);
        this.reset(useIdentityService);
    }

    private String buildUserNameMultiTenancyAware() {
        return "someUserName" + (String)(useDefaultNetwork ? "" : "@" + this.getClass().getName().toLowerCase());
    }

    private void runPreCheckToEnsureBasicFunctionalityWorks(String folderName, PublicApiClient.Paging paging) throws Exception {
        this.setRequestContext(null);
        this.getAll(SiteEntityResource.class, paging, null, 401);
        this.setRequestContext(user2);
        Folder folderResp = this.createFolder("-my-", folderName, null);
        Assert.assertNotNull((Object)folderResp.getId());
        this.setRequestContext(null);
        this.getAll(this.getNodeChildrenUrl("-my-"), paging, 401);
    }

    private void setupAuthChainForTest(boolean useIdentityService, RemoteUserMapper remoteUserMapper) {
        PublicApiAuthenticatorFactory publicApiAuthenticatorFactory = (PublicApiAuthenticatorFactory)this.applicationContext.getBean("publicapi.authenticator");
        publicApiAuthenticatorFactory.setRemoteUserMapper(remoteUserMapper);
        AuthenticationsImpl authentications = (AuthenticationsImpl)this.applicationContext.getBean("authentications");
        authentications.setRemoteUserMapper(remoteUserMapper);
        String chain = useIdentityService ? "identity-service1:identity-service,alfrescoNtlm1:alfrescoNtlm" : "external1:external,alfrescoNtlm1:alfrescoNtlm";
        String chainId = useIdentityService ? "identity-service1" : "external1";
        DefaultChildApplicationContextManager childApplicationContextManager = (DefaultChildApplicationContextManager)this.applicationContext.getBean("Authentication");
        childApplicationContextManager.stop();
        childApplicationContextManager.setProperty("chain", chain);
        ChildApplicationContextFactory childApplicationContextFactory = childApplicationContextManager.getChildApplicationContextFactory(chainId);
        childApplicationContextFactory.stop();
        childApplicationContextFactory.setProperty("external.authentication.proxyUserName", "");
        childApplicationContextFactory.start();
    }

    private RemoteUserMapper createRemoteUserMapperToUseForTheTest(boolean useIdentityService) {
        Object remoteUserMapper;
        PersonService personServiceLocal = (PersonService)this.applicationContext.getBean("PersonService");
        if (useIdentityService) {
            InterceptingIdentityRemoteUserMapper interceptingRemoteUserMapper = new InterceptingIdentityRemoteUserMapper();
            interceptingRemoteUserMapper.setActive(true);
            interceptingRemoteUserMapper.setPersonService(personServiceLocal);
            interceptingRemoteUserMapper.setIdentityServiceDeployment(null);
            interceptingRemoteUserMapper.setUserIdToReturn(user2);
            remoteUserMapper = interceptingRemoteUserMapper;
        } else {
            InterceptingDefaultRemoteUserMapper interceptingRemoteUserMapper = new InterceptingDefaultRemoteUserMapper();
            interceptingRemoteUserMapper.setActive(true);
            interceptingRemoteUserMapper.setPersonService(personServiceLocal);
            interceptingRemoteUserMapper.setProxyUserName(null);
            remoteUserMapper = interceptingRemoteUserMapper;
        }
        return remoteUserMapper;
    }

    private void checkRemoteUserMapperWasCalled(boolean useIdentityService) {
        if (useIdentityService) {
            Assert.assertTrue((boolean)InterceptingIdentityRemoteUserMapper.isGetRemoteUserCalled());
        } else {
            Assert.assertTrue((boolean)InterceptingDefaultRemoteUserMapper.isGetRemoteUserCalled());
        }
    }

    private void reset(boolean useIdentityService) {
        if (useIdentityService) {
            InterceptingIdentityRemoteUserMapper.reset();
        } else {
            InterceptingDefaultRemoteUserMapper.reset();
        }
    }

    private String encodeB64(String str) {
        return Base64.encodeBase64String((byte[])str.getBytes());
    }

    @Override
    public String getScope() {
        return "public";
    }
}

