/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.alfresco.repo.audit.model.AuditModelRegistryImpl;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.data.AuditApp;
import org.alfresco.rest.api.tests.client.data.AuditEntry;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.ISO8601DateFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.util.ResourceUtils;

public class AuditAppTest
extends AbstractSingleNetworkSiteTest {
    protected PermissionService permissionService;
    protected AuthorityService authorityService;
    protected AuditService auditService;
    protected static String AUDIT_APP_ID = "alfresco-access";

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService", PermissionService.class);
        this.authorityService = (AuthorityService)this.applicationContext.getBean("AuthorityService");
        this.auditService = (AuditService)this.applicationContext.getBean("AuditService", AuditService.class);
        AuditModelRegistryImpl auditModelRegistry = (AuditModelRegistryImpl)this.applicationContext.getBean("auditModel.modelRegistry");
        URL testModelUrl = ResourceUtils.getURL((String)"classpath:alfresco/audit/alfresco-audit-access.xml");
        auditModelRegistry.registerModel(testModelUrl);
        auditModelRegistry.loadAuditModels();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetAuditApps() throws Exception {
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        this.testGetAuditAppsSkipPaging();
    }

    @Test
    public void testGetAuditApp() throws Exception {
        PublicApiClient.AuditApps auditAppsProxy = this.publicApiClient.auditApps();
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        String appId = this.getFirstAuditAppId();
        AuthenticationUtil.setFullyAuthenticatedUser((String)networkAdmin);
        this.enableSystemAudit();
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        auditAppsProxy.getAuditApp("invalidAuditId", 404);
        this.setRequestContext(networkOne.getId(), user1, null);
        auditAppsProxy.getAuditApp("randomAuditId", 403);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        AuthenticationUtil.setFullyAuthenticatedUser((String)networkAdmin);
        this.disableSystemAudit();
        auditAppsProxy.getAuditApp(appId, 501);
        this.enableSystemAudit();
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        AuditApp auditApp = auditAppsProxy.getAuditApp(appId);
        this.validateAuditApplicationFields(auditApp);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        auditApp = auditAppsProxy.getAuditApp("alfresco-access");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "min");
        auditApp = auditAppsProxy.getAuditApp(auditApp.getId(), params, 200);
        this.validateAuditApplicationFields(auditApp, params);
        params.put("include", "max,min");
        auditApp = auditAppsProxy.getAuditApp(auditApp.getId(), params, 200);
        this.validateAuditApplicationFields(auditApp, params);
        params.put("include", "test,test1,test2");
        auditApp = auditAppsProxy.getAuditApp(auditApp.getId(), params, 200);
        this.validateAuditApplicationFields(auditApp, params);
        params.put("include", "max,max");
        auditApp = auditAppsProxy.getAuditApp(auditApp.getId(), params, 200);
        this.validateAuditApplicationFields(auditApp, params);
    }

    private void testGetAuditAppsSkipPaging() throws Exception {
        int skipCount = 0;
        int maxItems = 4;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        PublicApiClient.ListResponse<AuditApp> resp = this.getAuditApps(paging);
        skipCount = 2;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems);
        PublicApiClient.ListResponse<AuditApp> sublistResponse = this.getAuditApps(paging);
        List<AuditApp> expectedSublist = this.sublist(resp.getList(), skipCount, maxItems);
        this.checkList(expectedSublist, sublistResponse.getPaging(), sublistResponse);
        this.getAuditApps(this.getPaging(-1, null), "", 400);
    }

    private PublicApiClient.ListResponse<AuditApp> getAuditApps(PublicApiClient.Paging paging, String errorMessage, int expectedStatus) throws Exception {
        PublicApiClient.AuditApps auditAppsProxy = this.publicApiClient.auditApps();
        return auditAppsProxy.getAuditApps(this.createParams(paging), errorMessage, expectedStatus);
    }

    private PublicApiClient.ListResponse<AuditApp> getAuditApps(PublicApiClient.Paging paging) throws Exception {
        return this.getAuditApps(paging, "Failed to get audit applications", 200);
    }

    protected Map<String, String> createParams(PublicApiClient.Paging paging) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        if (paging != null) {
            if (paging.getSkipCount() != null) {
                params.put("skipCount", String.valueOf(paging.getSkipCount()));
            }
            if (paging.getMaxItems() != null) {
                params.put("maxItems", String.valueOf(paging.getMaxItems()));
            }
        }
        return params;
    }

    private void validateAuditApplicationFields(AuditApp auditApp) {
        Assert.assertNotNull((Object)auditApp);
        Assert.assertNotNull((Object)auditApp.getId());
        Assert.assertNotNull((Object)auditApp.getName());
        Assert.assertNotNull((Object)auditApp.getIsEnabled());
        Assert.assertFalse((boolean)auditApp.getId().isEmpty());
        Assert.assertFalse((boolean)auditApp.getName().isEmpty());
        Assert.assertTrue((boolean)auditApp.getIsEnabled());
    }

    private void validateAuditApplicationFields(AuditApp auditApp, HashMap<String, String> params) {
        this.validateAuditApplicationFields(auditApp);
        if (params.get("include").contains("max")) {
            Assert.assertNotNull((Object)auditApp.getMaxEntryId());
        }
        if (params.get("include").contains("min")) {
            Assert.assertNotNull((Object)auditApp.getMinEntryId());
        }
    }

    private void validateAuditEntryFields(AuditEntry auditEntry, AuditApp auditApp) {
        String auditAppid = auditApp.getId();
        Assert.assertNotNull((Object)auditEntry);
        Assert.assertNotNull((Object)auditEntry.getId());
        Assert.assertNotNull((Object)auditEntry.getAuditApplicationId());
        Assert.assertNotNull((Object)auditEntry.getCreatedAt());
        Assert.assertNotNull((Object)auditEntry.getCreatedByUser());
        Assert.assertFalse((boolean)auditEntry.getId().toString().isEmpty());
        Assert.assertFalse((boolean)auditEntry.getAuditApplicationId().isEmpty());
        if (auditApp.getId().equals(AUDIT_APP_ID)) {
            Assert.assertTrue((boolean)auditEntry.getAuditApplicationId().toString().equals(auditAppid));
        }
    }

    private String getFirstAuditAppId() throws PublicApiException {
        PublicApiClient.ListResponse<AuditApp> apps = this.publicApiClient.auditApps().getAuditApps(null, "Getting audit apps error ", 200);
        if (apps.getList().size() == 0) {
            Assert.fail((String)"There are no audit applications to run this test against.");
        }
        return apps.getList().get(0).getId();
    }

    @Test
    public void testEnableDisableAuditApplication() throws Exception {
        AuditApp requestAuditApp = new AuditApp();
        AuditApp responseAuditApp = null;
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        String appId = this.getFirstAuditAppId();
        requestAuditApp.setIsEnabled(false);
        responseAuditApp = this.publicApiClient.auditApps().updateAuditApp(appId, requestAuditApp, null, 200);
        Assert.assertFalse((String)"Wrong response for request to disable audit app.", (boolean)responseAuditApp.getIsEnabled());
        Assert.assertFalse((String)"Disable audit app test failed.", (boolean)this.publicApiClient.auditApps().getAuditApp(appId).getIsEnabled());
        requestAuditApp.setIsEnabled(true);
        responseAuditApp = this.publicApiClient.auditApps().updateAuditApp(appId, requestAuditApp, null, 200);
        Assert.assertTrue((String)"Wrong response for request to enable audit app.", (boolean)responseAuditApp.getIsEnabled());
        Assert.assertTrue((String)"Enable audit app test failed.", (boolean)this.publicApiClient.auditApps().getAuditApp(appId).getIsEnabled());
        this.publicApiClient.auditApps().update("audit-applications", appId, null, null, "badBody", null, "Was expecting error 400", 400);
        this.setRequestContext(networkOne.getId(), networkAdmin, "fakepswd");
        this.publicApiClient.auditApps().updateAuditApp(appId, requestAuditApp, null, 401);
        this.setRequestContext(networkOne.getId(), user1, null);
        this.publicApiClient.auditApps().updateAuditApp(appId, requestAuditApp, null, 403);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        this.publicApiClient.auditApps().updateAuditApp("fakeid", requestAuditApp, null, 404);
        AuthenticationUtil.setFullyAuthenticatedUser((String)networkAdmin);
        this.disableSystemAudit();
        this.publicApiClient.auditApps().updateAuditApp(appId, requestAuditApp, null, 501);
        this.enableSystemAudit();
    }

    protected void enableSystemAudit() {
        boolean isEnabled = this.auditService.isAuditEnabled();
        if (!isEnabled) {
            this.auditService.setAuditEnabled(true);
            isEnabled = this.auditService.isAuditEnabled();
            if (!isEnabled) {
                Assert.fail((String)"Failed to enable system audit for testing");
            }
        }
    }

    protected void disableSystemAudit() {
        boolean isEnabled = this.auditService.isAuditEnabled();
        if (isEnabled) {
            this.auditService.setAuditEnabled(false);
            isEnabled = this.auditService.isAuditEnabled();
            if (isEnabled) {
                Assert.fail((String)"Failed to disable system audit for testing");
            }
        }
    }

    @Test
    public void testAuditEntries() throws Exception {
        PublicApiClient.AuditApps auditAppsProxy = this.publicApiClient.auditApps();
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        AuditApp auditApp = auditAppsProxy.getAuditApp("alfresco-access");
        this.testGetAuditEntries(auditAppsProxy, auditApp);
        this.testAuditEntriesSorting(auditAppsProxy, auditApp);
        this.testAuditEntriesWhereDate(auditAppsProxy, auditApp);
        this.testAuditEntriesWhereId(auditAppsProxy, auditApp);
        this.testAuditEntriesWithInclude(auditAppsProxy, auditApp);
        this.testAuditEntriesSkipCount(auditAppsProxy, auditApp);
        this.testRetrieveAuditEntry(auditAppsProxy, auditApp);
        this.testDeleteAuditEntry(auditAppsProxy, auditApp);
        this.testDeleteAuditEntries(auditAppsProxy, auditApp);
    }

    private void testGetAuditEntries(PublicApiClient.AuditApps auditAppsProxy, AuditApp auditApp) throws Exception {
        PublicApiClient.ListResponse<AuditEntry> auditEntries = auditAppsProxy.getAuditAppEntries(auditApp.getId(), null, 200);
        for (AuditEntry ae : auditEntries.getList()) {
            this.validateAuditEntryFields(ae, auditApp);
        }
        int auditEntriesTotalItems = auditEntries.getPaging().getTotalItems();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("maxItems", "1");
        auditEntries = auditAppsProxy.getAuditAppEntries(auditApp.getId(), params, 200);
        int AuditEntriesTotalItemsAfterLimit = auditEntries.getPaging().getTotalItems();
        int retrievedAuditEntriesCount = auditEntries.getPaging().getCount();
        Assert.assertEquals((long)(auditEntriesTotalItems + 2), (long)AuditEntriesTotalItemsAfterLimit);
        Assert.assertEquals((long)1L, (long)retrievedAuditEntriesCount);
        params.put("omitTotalItems", "true");
        auditEntries = auditAppsProxy.getAuditAppEntries(auditApp.getId(), params, 200);
        Assert.assertNull((Object)auditEntries.getPaging().getTotalItems());
        this.setRequestContext(networkOne.getId(), networkAdmin, "wrongPassword");
        auditAppsProxy.getAuditAppEntries(auditApp.getId(), null, 401);
        this.setRequestContext(networkOne.getId(), user1, null);
        auditAppsProxy.getAuditAppEntries(auditApp.getId(), null, 403);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        auditAppsProxy.getAuditAppEntries("randomId", null, 404);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        AuthenticationUtil.setFullyAuthenticatedUser((String)networkAdmin);
        this.disableSystemAudit();
        auditAppsProxy.getAuditAppEntries("randomId", null, 501);
        this.enableSystemAudit();
    }

    private void testAuditEntriesSorting(PublicApiClient.AuditApps auditAppsProxy, AuditApp auditApp) throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, 10);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        this.addOrderBy(otherParams, "createdAt", null);
        PublicApiClient.ListResponse<AuditEntry> auditEntries = auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        Assert.assertNotNull(auditEntries);
        Assert.assertTrue((String)"audit entry size more that 2", (auditEntries.getList().size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"auditEntries order not valid", (boolean)auditEntries.getList().get(0).getCreatedAt().before(auditEntries.getList().get(1).getCreatedAt()));
    }

    private void testAuditEntriesWhereDate(PublicApiClient.AuditApps auditAppsProxy, AuditApp auditApp) throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, 10);
        Date dateBefore = new Date();
        String dateBeforeWhere = ISO8601DateFormat.format((Date)dateBefore);
        this.createUser("usern-" + this.RUNID, "userNPassword", networkOne);
        this.login("usern-" + this.RUNID, "userNPassword");
        Date dateAfter = new Date();
        String dateAfterWhere = ISO8601DateFormat.format((Date)dateAfter);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(createdAt between ('" + dateBeforeWhere + "', '" + dateAfterWhere + "'))");
        PublicApiClient.ListResponse<AuditEntry> auditEntries = auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        Assert.assertNotNull(auditEntries);
        Assert.assertTrue((auditEntries.getList().size() > 0 ? 1 : 0) != 0);
        for (AuditEntry ae : auditEntries.getList()) {
            this.validateAuditEntryFields(ae, auditApp);
        }
        otherParams.put("where", "(createdAt between ('2016-06-02T12:13:51.593+01:00', '2017-06-04T10:05:16.536+01:00'))");
        auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        otherParams.put("where", "(createdAt between ('2016-06-02T11:13:51.593+0000', '2017-06-04T09:05:16.536+0000'))");
        auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        otherParams.put("where", "(createdAt between ('2016-06-02T11:13:51.593Z', '2017-06-04T09:05:16.536Z'))");
        auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        otherParams = new HashMap();
        otherParams.put("where", "(createdAt between ('2017-06-04T10:05:16.536+01:00', '2016-06-02T12:13:51.593+01:00'))");
        auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 400);
    }

    private void testAuditEntriesWhereId(PublicApiClient.AuditApps auditAppsProxy, AuditApp auditApp) throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, 10);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(id between ('1' , '10'))");
        PublicApiClient.ListResponse<AuditEntry> auditEntries = auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        Assert.assertNotNull(auditEntries);
        otherParams = new HashMap();
        otherParams.put("where", "(createdAt between between ('10' , '1'))");
        auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 400);
    }

    private void testAuditEntriesWithInclude(PublicApiClient.AuditApps auditAppsProxy, AuditApp auditApp) throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, 10);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        PublicApiClient.ListResponse<AuditEntry> auditEntriesWithoutValues = auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        Assert.assertNotNull(auditEntriesWithoutValues);
        for (AuditEntry ae : auditEntriesWithoutValues.getList()) {
            this.validateAuditEntryFields(ae, auditApp);
            Assert.assertNull((Object)ae.getValues());
        }
        otherParams.put("include", "values");
        PublicApiClient.ListResponse<AuditEntry> auditEntriesWithValues = auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        Assert.assertNotNull(auditEntriesWithValues);
        for (AuditEntry ae : auditEntriesWithValues.getList()) {
            this.validateAuditEntryFields(ae, auditApp);
            Assert.assertNotNull((Object)ae.getValues());
            Assert.assertTrue((String)"audit values not empty", (ae.getValues().keySet().size() > 0 ? 1 : 0) != 0);
        }
    }

    private void testAuditEntriesSkipCount(PublicApiClient.AuditApps auditAppsProxy, AuditApp auditApp) throws Exception {
        int skipCount = 0;
        int maxItems = 4;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        PublicApiClient.ListResponse<AuditEntry> resp = auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        skipCount = 2;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems);
        PublicApiClient.ListResponse<AuditEntry> sublistResponse = auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        List<AuditEntry> expectedSublist = this.sublist(resp.getList(), skipCount, maxItems);
        this.checkList(expectedSublist, sublistResponse.getPaging(), sublistResponse);
    }

    private void testRetrieveAuditEntry(PublicApiClient.AuditApps auditAppsProxy, AuditApp auditApp) throws Exception {
        int skipCount = 0;
        int maxItems = 4;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        PublicApiClient.ListResponse<AuditEntry> resp = auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        String id = resp.getList().get(0).getId().toString();
        AuditEntry entryResp = auditAppsProxy.getAuditEntry(auditApp.getId(), id, null, 200);
        this.validateAuditEntryFields(entryResp, auditApp);
        Assert.assertNotNull((Object)entryResp.getValues());
        auditAppsProxy.getAuditEntry(auditApp.getId(), id + "invalidIdText", null, 400);
        this.setRequestContext(networkOne.getId(), networkAdmin, "wrongPassword");
        auditAppsProxy.getAuditEntry(auditApp.getId(), id, null, 401);
        this.setRequestContext(networkOne.getId(), user1, null);
        auditAppsProxy.getAuditEntry(auditApp.getId(), id, null, 403);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        auditAppsProxy.getAuditEntry(auditApp.getId(), "" + Math.abs(new Random().nextLong()), null, 404);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        AuthenticationUtil.setFullyAuthenticatedUser((String)networkAdmin);
        this.disableSystemAudit();
        auditAppsProxy.getAuditEntry(auditApp.getId(), id, null, 501);
        this.enableSystemAudit();
    }

    private void testDeleteAuditEntry(PublicApiClient.AuditApps auditAppsProxy, AuditApp auditApp) throws Exception {
        int skipCount = 0;
        int maxItems = 4;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        PublicApiClient.ListResponse<AuditEntry> resp = auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        String id = resp.getList().get(0).getId().toString();
        auditAppsProxy.getAuditEntry(auditApp.getId(), id + "invalidIdText", null, 400);
        this.setRequestContext(networkOne.getId(), networkAdmin, "wrongPassword");
        auditAppsProxy.deleteAuditEntry(auditApp.getId(), id, null, 401);
        this.setRequestContext(networkOne.getId(), user1, null);
        auditAppsProxy.deleteAuditEntry(auditApp.getId(), id, null, 403);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        auditAppsProxy.deleteAuditEntry(auditApp.getId(), "" + Math.abs(new Random().nextLong()), null, 404);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        AuthenticationUtil.setFullyAuthenticatedUser((String)networkAdmin);
        this.disableSystemAudit();
        auditAppsProxy.deleteAuditEntry(auditApp.getId(), id, null, 501);
        this.enableSystemAudit();
        auditAppsProxy.deleteAuditEntry(auditApp.getId(), id, null, 204);
    }

    private void testDeleteAuditEntries(PublicApiClient.AuditApps auditAppsProxy, AuditApp auditApp) throws Exception {
        int skipCount = 0;
        int maxItems = 4;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        PublicApiClient.ListResponse<AuditEntry> resp = auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, otherParams), 200);
        String dateBefore = ISO8601DateFormat.format((Date)resp.getList().get(0).getCreatedAt());
        String dateAfter = ISO8601DateFormat.format((Date)resp.getList().get(2).getCreatedAt());
        Long secondDeleteEntryId = resp.getList().get(1).getId();
        Long lastDeleteEntryId = resp.getList().get(2).getId();
        otherParams.put("where", "(createdAt between ('" + dateAfter + "', '" + dateBefore + "'))");
        auditAppsProxy.deleteAuditEntries(auditApp.getId(), otherParams, 400);
        otherParams.put("where", "(id between ('" + lastDeleteEntryId + "', '" + secondDeleteEntryId + "'))");
        auditAppsProxy.deleteAuditEntries(auditApp.getId(), otherParams, 400);
        otherParams.put("where", "(createdAt between ('" + dateBefore + "', '" + dateAfter + "'))");
        this.setRequestContext(networkOne.getId(), networkAdmin, "wrongPassword");
        auditAppsProxy.deleteAuditEntries(auditApp.getId(), otherParams, 401);
        this.setRequestContext(networkOne.getId(), user1, null);
        auditAppsProxy.deleteAuditEntries(auditApp.getId(), otherParams, 403);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        auditAppsProxy.deleteAuditEntries("invalidAppId", otherParams, 404);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        AuthenticationUtil.setFullyAuthenticatedUser((String)networkAdmin);
        this.disableSystemAudit();
        auditAppsProxy.deleteAuditEntries(auditApp.getId(), otherParams, 501);
        this.enableSystemAudit();
        auditAppsProxy.deleteAuditEntries(auditApp.getId(), otherParams, 204);
        resp = auditAppsProxy.getAuditAppEntries(auditApp.getId(), this.createParams(paging, new HashMap<String, String>()), 200);
        Assert.assertTrue((String)"Entries were not deleted", (resp.getList().get(0).getId() > lastDeleteEntryId ? 1 : 0) != 0);
    }

    private void login(final String username, final String password) throws Exception {
        AuthenticationUtil.RunAsWork<Void> failureWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                try {
                    AbstractBaseApiTest.authenticationService.authenticate(username, password.toCharArray());
                    Assert.fail((String)"Failed to force authentication failure");
                }
                catch (AuthenticationException authenticationException) {
                    // empty catch block
                }
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)failureWork, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected Map<String, String> createParams(PublicApiClient.Paging paging, Map<String, String> otherParams) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        if (paging != null) {
            if (paging.getSkipCount() != null) {
                params.put("skipCount", String.valueOf(paging.getSkipCount()));
            }
            if (paging.getMaxItems() != null) {
                params.put("maxItems", String.valueOf(paging.getMaxItems()));
            }
        }
        if (otherParams != null) {
            params.putAll(otherParams);
        }
        return params;
    }

    private void addOrderBy(Map<String, String> otherParams, String sortColumn, Boolean asc) {
        otherParams.put("orderBy", sortColumn + (String)(asc != null ? " " + (asc != false ? "ASC" : "DESC") : ""));
    }

    private String createFolderInPrivateSite(String siteTitle, String folderName) throws Exception {
        String siteId = this.createSite(siteTitle, SiteVisibility.PRIVATE).getId();
        String siteDocLibNodeId = this.getSiteContainerNodeId(siteId, "documentLibrary");
        return this.createFolder(siteDocLibNodeId, folderName).getId();
    }

    private void renameNode(String nodeId, String newName) throws Exception {
        Node nUpdate = new Node();
        nUpdate.setName(newName);
        this.put("nodes", nodeId, RestApiUtil.toJsonAsStringNonNull(nUpdate), null, 200);
    }

    @Test
    public void testAuditEntriesByNodeId() throws Exception {
        PublicApiClient.AuditApps auditAppsProxy = this.publicApiClient.auditApps();
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        String adminNodeId = this.createFolderInPrivateSite("testSiteAdmin" + this.RUNID, "testFolderAdmin" + this.RUNID);
        AuditApp alfAccessAuditApp = auditAppsProxy.getAuditApp(AUDIT_APP_ID);
        this.setRequestContext(user1);
        String nodeId = this.createFolderInPrivateSite("testSiteUser" + this.RUNID, "testFolderUser1" + this.RUNID);
        this.renameNode(nodeId, "testFolderUser1" + this.RUNID + "b");
        this.testGetAuditEntriesByNodeId(auditAppsProxy, nodeId, alfAccessAuditApp);
        this.testAuditEntriesSortingByNodeId(auditAppsProxy, nodeId);
        this.testAuditEntriesWhereDateByNodeId(auditAppsProxy, nodeId);
        this.testAuditEntriesWithIncludeByNodeId(auditAppsProxy, nodeId, alfAccessAuditApp);
        this.testAuditEntriesSkipCountByNodeId(auditAppsProxy, nodeId);
        this.testAuditEntriesWhereUserByNodeId(auditAppsProxy, adminNodeId, alfAccessAuditApp);
    }

    private void testAuditEntriesSkipCountByNodeId(PublicApiClient.AuditApps auditAppsProxy, String nodeId) throws Exception {
        this.setRequestContext(user1);
        int skipCount = 0;
        int maxItems = 4;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        Map<String, String> params = this.createParams(paging, otherParams);
        PublicApiClient.ListResponse<AuditEntry> resp = auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, params, 200);
        skipCount = 2;
        maxItems = 2;
        PublicApiClient.Paging pagingSkip = this.getPaging(skipCount, maxItems);
        params = this.createParams(pagingSkip, otherParams);
        PublicApiClient.ListResponse<AuditEntry> sublistResponse = auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, params, 200);
        List<AuditEntry> expectedSublist = this.sublist(resp.getList(), skipCount, maxItems);
        this.checkList(expectedSublist, sublistResponse.getPaging(), sublistResponse);
    }

    private void testAuditEntriesWithIncludeByNodeId(PublicApiClient.AuditApps auditAppsProxy, String nodeId, AuditApp alfAccessAuditApp) throws Exception {
        this.setRequestContext(user1);
        PublicApiClient.Paging paging = this.getPaging(0, 10);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        Map<String, String> params = this.createParams(paging, otherParams);
        PublicApiClient.ListResponse<AuditEntry> auditEntriesWithoutValues = auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, params, 200);
        Assert.assertNotNull(auditEntriesWithoutValues);
        for (AuditEntry ae : auditEntriesWithoutValues.getList()) {
            this.validateAuditEntryFields(ae, alfAccessAuditApp);
            Assert.assertNull((Object)ae.getValues());
        }
        otherParams.put("include", "values");
        params = this.createParams(paging, otherParams);
        PublicApiClient.ListResponse<AuditEntry> auditEntriesWithValues = auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, params, 200);
        Assert.assertNotNull(auditEntriesWithValues);
        for (AuditEntry ae : auditEntriesWithValues.getList()) {
            this.validateAuditEntryFields(ae, alfAccessAuditApp);
            Assert.assertNotNull((Object)ae.getValues());
            Assert.assertTrue((String)"audit values not empty", (ae.getValues().keySet().size() > 0 ? 1 : 0) != 0);
        }
    }

    private void testAuditEntriesWhereDateByNodeId(PublicApiClient.AuditApps auditAppsProxy, String nodeId) throws Exception {
        this.setRequestContext(user1);
        PublicApiClient.Paging paging = this.getPaging(0, 10);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(createdAt between ('2016-06-02T12:13:51.593+01:00', '2017-06-04T10:05:16.536+01:00'))");
        Map<String, String> params = this.createParams(paging, otherParams);
        auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, params, 200);
        otherParams.put("where", "(createdAt between ('2016-06-02T11:13:51.593+0000', '2017-06-04T09:05:16.536+0000'))");
        params = this.createParams(paging, otherParams);
        auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, params, 200);
        otherParams.put("where", "(createdAt between ('2016-06-02T11:13:51.593Z', '2017-06-04T09:05:16.536Z'))");
        params = this.createParams(paging, otherParams);
        auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, params, 200);
        otherParams.put("where", "(createdAt between ('2017-06-04T10:05:16.536+01:00', '2016-06-02T12:13:51.593+01:00'))");
        params = this.createParams(paging, otherParams);
        auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, params, 400);
    }

    private void testAuditEntriesWhereUserByNodeId(PublicApiClient.AuditApps auditAppsProxy, String nodeId, AuditApp alfAccessAuditApp) throws Exception {
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        PublicApiClient.Paging paging = this.getPaging(0, 10);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(createdByUser='" + networkAdmin + "')");
        Map<String, String> params = this.createParams(paging, otherParams);
        PublicApiClient.ListResponse<AuditEntry> auditEntries = auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, params, 200);
        int countEntries = auditEntries.getList().size();
        otherParams.put("where", "(createdByUser='-me-')");
        params = this.createParams(paging, otherParams);
        auditEntries = auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, params, 200);
        Assert.assertTrue((String)"The number of entries should be the same in both GET calls", (countEntries == auditEntries.getList().size() ? 1 : 0) != 0);
        Assert.assertNotNull(auditEntries);
        for (AuditEntry ae : auditEntries.getList()) {
            this.validateAuditEntryFields(ae, alfAccessAuditApp);
        }
    }

    private void testGetAuditEntriesByNodeId(PublicApiClient.AuditApps auditAppsProxy, String nodeId, AuditApp alfAccessAuditApp) throws Exception {
        this.setRequestContext(user1);
        PublicApiClient.ListResponse<AuditEntry> auditEntries = auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, null, 200);
        for (AuditEntry ae : auditEntries.getList()) {
            this.validateAuditEntryFields(ae, alfAccessAuditApp);
        }
        this.setRequestContext(networkOne.getId(), networkAdmin, "wrongPassword");
        auditAppsProxy.getAuditAppEntries(nodeId, null, 401);
        this.setRequestContext(networkOne.getId(), user1, null);
        auditAppsProxy.getAuditAppEntries(nodeId, null, 403);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        auditAppsProxy.getAuditAppEntries("randomId", null, 404);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        AuthenticationUtil.setFullyAuthenticatedUser((String)networkAdmin);
        this.disableSystemAudit();
        auditAppsProxy.getAuditAppEntries("randomId", null, 501);
        this.enableSystemAudit();
    }

    private void testAuditEntriesSortingByNodeId(PublicApiClient.AuditApps auditAppsProxy, String nodeId) throws Exception {
        this.setRequestContext(user1);
        PublicApiClient.Paging paging = this.getPaging(0, 10);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        this.addOrderBy(otherParams, "createdAt", null);
        Map<String, String> params = this.createParams(paging, otherParams);
        PublicApiClient.ListResponse<AuditEntry> auditEntries = auditAppsProxy.getAuditAppEntriesByNodeRefId(nodeId, params, 200);
        Assert.assertNotNull(auditEntries);
        Assert.assertTrue((String)"audit entry size less than 2", (auditEntries.getList().size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"auditEntries order not valid", (boolean)auditEntries.getList().get(0).getCreatedAt().before(auditEntries.getList().get(1).getCreatedAt()));
    }
}

