/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.web.util.JettyComponent;
import org.alfresco.util.BaseApplicationContextHelper;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.WebApplicationContextLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public abstract class AbstractJettyComponent
implements JettyComponent {
    protected static final Log logger = LogFactory.getLog(AbstractJettyComponent.class);
    public static final int JETTY_STOP_PORT = 8079;
    public static final String JETTY_LOCAL_IP = "127.0.0.1";
    protected int port = 8081;
    protected String contextPath = "/alfresco";
    protected String publicApiServletName = "api";
    protected String[] configLocations;
    protected String[] classLocations;
    protected static Server server;
    private WebAppContext webAppContext;

    public AbstractJettyComponent(int port, String contextPath, String[] configLocations, String[] classLocations) {
        this.configLocations = configLocations;
        this.classLocations = classLocations;
        this.port = port;
        this.contextPath = contextPath;
        server = new Server(port);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext sc, ApplicationContext parent) {
        GenericWebApplicationContext wac = (GenericWebApplicationContext)BeanUtils.instantiateClass(GenericWebApplicationContext.class);
        wac.setId(ConfigurableWebApplicationContext.APPLICATION_CONTEXT_ID_PREFIX + this.contextPath);
        wac.setParent(parent);
        wac.setServletContext(sc);
        wac.refresh();
        return wac;
    }

    @Override
    public ConfigurableApplicationContext getApplicationContext() {
        return (ConfigurableApplicationContext)this.webAppContext.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    protected abstract void configureWebAppContext(WebAppContext var1);

    @Override
    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[" + String.valueOf(new Date()) + "] startJetty: starting embedded Jetty server ..."));
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[" + String.valueOf(new Date()) + "] startJetty"));
            }
            this.webAppContext = new WebAppContext();
            this.webAppContext.setContextPath(this.contextPath);
            this.configure(this.webAppContext);
            server.setHandler((Handler)this.webAppContext);
            MonitorThread monitor = new MonitorThread();
            monitor.start();
            this.configureWebAppContext(this.webAppContext);
            server.start();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[" + String.valueOf(new Date()) + "] startJetty: ... embedded Jetty server started on port " + this.port));
            }
        }
        catch (Exception e) {
            logger.error((Object)("[" + String.valueOf(new Date()) + "] startJetty: ... failed to start embedded Jetty server on port " + this.port + ", " + String.valueOf(e)));
        }
    }

    protected void configure(WebAppContext webAppContext) {
        try {
            ClassLoader classLoader = BaseApplicationContextHelper.buildClassLoader((String[])this.classLocations);
            webAppContext.setClassLoader(classLoader);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        webAppContext.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                try {
                    ServletContext servletContext = sce.getServletContext();
                    WebApplicationContextLoader.getApplicationContext((ServletContext)servletContext, (String[])AbstractJettyComponent.this.configLocations, (String[])AbstractJettyComponent.this.classLocations);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("contextInitialized " + String.valueOf(sce)));
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)("Failed to start Jetty server: " + String.valueOf(t)));
                    throw new AlfrescoRuntimeException("Failed to start Jetty server", t);
                }
            }

            public void contextDestroyed(ServletContextEvent sce) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("contextDestroyed " + String.valueOf(sce)));
                }
            }
        });
        webAppContext.getSecurityHandler().setLoginService((LoginService)new HashLoginService());
        File tmp = new File(TempFileProvider.getSystemTempDir(), String.valueOf(System.currentTimeMillis()));
        webAppContext.setResourceBase(tmp.getAbsolutePath());
    }

    @Override
    public void shutdown() {
        try {
            server.stop();
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("", (Throwable)e);
        }
    }

    private static class MonitorThread
    extends Thread {
        private ServerSocket socket;

        public MonitorThread() {
            this.setDaemon(true);
            this.setName("StopMonitor");
            try {
                this.socket = new ServerSocket(8079, 1, InetAddress.getByName(AbstractJettyComponent.JETTY_LOCAL_IP));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            try {
                Socket accept = this.socket.accept();
                BufferedReader reader = new BufferedReader(new InputStreamReader(accept.getInputStream()));
                reader.readLine();
                server.stop();
                accept.close();
                this.socket.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

