/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.person;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.UserNameMatcherImpl;
import org.alfresco.repo.service.ServiceDescriptorRegistry;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.usage.ContentUsageImpl;
import org.alfresco.repo.usage.UserUsageTrackingComponent;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.apache.commons.lang3.RandomStringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class PersonServiceTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private UserNameMatcherImpl userNameMatcherImpl;
    private NodeService nodeService;
    private ContentService contentService;
    private UserUsageTrackingComponent userUsageTrackingComponent;
    private ContentUsageImpl contentUsage;
    private TransactionService transactionService;
    @Mock
    private SearchService mockSearchService;
    @Mock
    private ResultSet mockSearchServiceQueryResultSet;
    private List<NodeRef> dummySearchServiceQueryNodeRefs = new ArrayList<NodeRef>();
    private int callCount = 0;
    private ServiceDescriptorRegistry serviceRegistry;
    private static final String USER_ONE = "User.One";
    private static final String USER_TWO = "User.Two";
    private static final String USER_THREE = "User.Three";
    private static final String URL_PEOPLE = "/api/people";
    private static final String SORT_BY_USERNAME = "userName";
    private static final String SORT_BY_FULLNAME = "fullName";
    private static final String SORT_BY_JOBTITLE = "jobtitle";
    private static final String SORT_BY_EMAIL = "email";
    private static final String SORT_BY_QUOTA = "quota";
    private static final String SORT_BY_USAGE = "usage";
    private static final String ASC_DIR = "asc";
    private static final String DESC_DIR = "desc";
    private List<String> createdPeople = new ArrayList<String>(5);

    protected void setUp() throws Exception {
        super.setUp();
        MockitoAnnotations.initMocks((Object)((Object)this));
        ApplicationContext ctx = this.getServer().getApplicationContext();
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.personService = (PersonService)ctx.getBean("PersonService");
        this.userNameMatcherImpl = (UserNameMatcherImpl)ctx.getBean("userNameMatcher");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.contentService = (ContentService)ctx.getBean("contentService");
        this.userUsageTrackingComponent = (UserUsageTrackingComponent)ctx.getBean("userUsageTrackingComponent");
        this.contentUsage = (ContentUsageImpl)ctx.getBean("contentUsageImpl");
        this.transactionService = (TransactionService)ctx.getBean("TransactionService");
        this.serviceRegistry = (ServiceDescriptorRegistry)ctx.getBean("ServiceRegistry");
        this.serviceRegistry.setMockSearchService(this.mockSearchService);
        Mockito.when((Object)this.mockSearchService.query((SearchParameters)Matchers.any())).thenReturn((Object)this.mockSearchServiceQueryResultSet);
        Mockito.when((Object)this.mockSearchServiceQueryResultSet.getNodeRefs()).thenReturn(this.dummySearchServiceQueryNodeRefs);
        this.contentUsage.setEnabled(true);
        this.contentUsage.init();
        this.userUsageTrackingComponent.setEnabled(true);
        this.userUsageTrackingComponent.init();
        this.userUsageTrackingComponent.bootstrapInternal();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        this.createUser(USER_THREE);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"myFirstName");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"myLastName");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"myFirstName.myLastName@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"myJobTitle");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"myOrganisation");
            this.personService.createPerson((Map)personProps);
            this.createdPeople.add(userName);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        String adminUser = this.authenticationComponent.getSystemUserName();
        this.authenticationComponent.setCurrentUser(adminUser);
        for (String userName : this.createdPeople) {
            this.personService.deletePerson(userName);
        }
        this.createdPeople.clear();
        if (this.serviceRegistry != null) {
            this.serviceRegistry.setMockSearchService(null);
        }
    }

    private JSONObject updatePerson(String userName, String title, String firstName, String lastName, String organisation, String jobTitle, String email, String bio, String avatarUrl, int expectedStatus) throws Exception {
        String currentUser = this.authenticationComponent.getCurrentUserName();
        String adminUser = this.authenticationComponent.getSystemUserName();
        this.authenticationComponent.setCurrentUser(adminUser);
        JSONObject person = new JSONObject();
        person.put(SORT_BY_USERNAME, (Object)userName);
        person.put("title", (Object)title);
        person.put("firstName", (Object)firstName);
        person.put("lastName", (Object)lastName);
        person.put("organisation", (Object)organisation);
        person.put(SORT_BY_JOBTITLE, (Object)jobTitle);
        person.put(SORT_BY_EMAIL, (Object)email);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/people/" + userName, person.toString(), "application/json"), expectedStatus);
        this.authenticationComponent.setCurrentUser(currentUser);
        return new JSONObject(response.getContentAsString());
    }

    private JSONObject createPerson(String userName, String title, String firstName, String lastName, String organisation, String jobTitle, String email, String bio, String avatarUrl, long quota, int expectedStatus) throws Exception {
        String currentUser = this.authenticationComponent.getCurrentUserName();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        JSONObject person = new JSONObject();
        person.put(SORT_BY_USERNAME, (Object)userName);
        person.put("title", (Object)title);
        person.put("firstName", (Object)firstName);
        person.put("lastName", (Object)lastName);
        person.put("organisation", (Object)organisation);
        person.put(SORT_BY_JOBTITLE, (Object)jobTitle);
        person.put(SORT_BY_EMAIL, (Object)email);
        if (quota > 0L) {
            person.put(SORT_BY_QUOTA, quota);
        }
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_PEOPLE, person.toString(), "application/json"), expectedStatus);
        if (userName != null && userName.length() != 0) {
            this.createdPeople.add(userName);
        }
        this.authenticationComponent.setCurrentUser(currentUser);
        return new JSONObject(response.getContentAsString());
    }

    private JSONObject deletePerson(String userName, int expectedStatus) throws Exception {
        String currentUser = this.authenticationComponent.getCurrentUserName();
        String adminUser = this.authenticationComponent.getSystemUserName();
        this.authenticationComponent.setCurrentUser(adminUser);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/people/" + userName), expectedStatus);
        this.createdPeople.remove(userName);
        this.authenticationComponent.setCurrentUser(currentUser);
        return new JSONObject(response.getContentAsString());
    }

    public void testGetPeople() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_PEOPLE), 200);
    }

    public void testJobWithSpace() throws Exception {
        String userName = RandomStringUtils.randomNumeric((int)6);
        String userJob = "myJob" + RandomStringUtils.randomNumeric((int)2) + " myJob" + RandomStringUtils.randomNumeric((int)3);
        String jobSearchString = userJob.replace(" ", "\\ ");
        this.createPerson(userName, "myTitle", "myFirstName", "myLastName", "myOrganisation", userJob, "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 0L, 200);
        this.dummySearchServiceQueryNodeRefs.clear();
        NodeRef nodeRef = this.personService.getPerson(userName);
        this.dummySearchServiceQueryNodeRefs.add(nodeRef);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?filter=" + URLEncoder.encode((String)("jobtitle:" + jobSearchString))), 200);
        this.assertSearchQuery("jobtitle:\"" + jobSearchString + "\"", false);
        JSONObject res = new JSONObject(response.getContentAsString());
        PersonServiceTest.assertEquals((int)1, (int)res.getJSONArray("people").length());
        this.dummySearchServiceQueryNodeRefs.clear();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?filter=" + URLEncoder.encode((String)("jobtitle:" + userJob))), 200);
        this.assertSearchQuery("jobtitle:\"" + userJob.replace(" ", "\" \"") + "\" ", false);
        res = new JSONObject(response.getContentAsString());
        PersonServiceTest.assertEquals((int)0, (int)res.getJSONArray("people").length());
    }

    public void testGetPerson() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/nonExistantUser"), 404);
        String userName = RandomStringUtils.randomNumeric((int)6);
        JSONObject result = this.createPerson(userName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "myEmailAddress", "myBio", "images/avatar.jpg", 0L, 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/" + userName), 200);
    }

    public void testGetPeopleSkipCount() throws Exception {
        int skipCount = 1;
        String filter = "*";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?filter=" + filter), 200);
        JSONObject res = new JSONObject(response.getContentAsString());
        int peopleFound = res.getJSONArray("people").length();
        PersonServiceTest.assertTrue((String)"No people found", (peopleFound > 0 ? 1 : 0) != 0);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?filter=" + filter + "&skipCount=" + skipCount), 200);
        res = new JSONObject(response.getContentAsString());
        PersonServiceTest.assertTrue((String)"skipCount ignored", (res.getJSONArray("people").length() < peopleFound ? 1 : 0) != 0);
    }

    private TestWebScriptServer.Request addHeadersToRequest(TestWebScriptServer.Request req) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("referer", "console/admin-console/users");
        req.setHeaders(headers);
        return req;
    }

    public void testGetPeoplePaging() throws Exception {
        JSONObject person;
        int i;
        this.dummySearchServiceQueryNodeRefs.clear();
        String filter = GUID.generate();
        for (int i2 = 0; i2 < 6; ++i2) {
            String username = filter + i2;
            this.createPerson(username, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "myEmailAddress", "myBio", "images/avatar.jpg", 0L, 200);
            NodeRef nodeRef = this.personService.getPerson(username);
            this.dummySearchServiceQueryNodeRefs.add(nodeRef);
        }
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?filter=" + filter + "&startIndex=0&pageSize=6"), 200);
        JSONObject res = new JSONObject(response.getContentAsString());
        JSONArray peopleAsc = res.getJSONArray("people");
        PersonServiceTest.assertEquals((String)"The number of returned results is not correct.", (int)6, (int)peopleAsc.length());
        this.checkPaging(6, 0, 6, res);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?filter=" + filter + "&startIndex=0&pageSize=2"), 200);
        res = new JSONObject(response.getContentAsString());
        peopleAsc = res.getJSONArray("people");
        PersonServiceTest.assertEquals((String)"The number of returned results is not correct.", (int)2, (int)peopleAsc.length());
        this.checkPaging(6, 0, 2, res);
        for (i = 0; i < peopleAsc.length(); ++i) {
            person = peopleAsc.getJSONObject(i);
            PersonServiceTest.assertEquals((String)"The name of a person does not match. Paging is not correct", (String)(filter + i), (String)person.getString(SORT_BY_USERNAME));
        }
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?filter=" + filter + "&startIndex=2&pageSize=2"), 200);
        res = new JSONObject(response.getContentAsString());
        peopleAsc = res.getJSONArray("people");
        PersonServiceTest.assertEquals((String)"The number of returned results is not correct.", (int)2, (int)peopleAsc.length());
        this.checkPaging(6, 2, 2, res);
        for (i = 0; i < peopleAsc.length(); ++i) {
            person = peopleAsc.getJSONObject(i);
            PersonServiceTest.assertEquals((String)"The name of a person does not match. Paging is not correct", (String)(filter + (2 + i)), (String)person.getString(SORT_BY_USERNAME));
        }
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?filter=" + filter + "&startIndex=4&pageSize=2"), 200);
        res = new JSONObject(response.getContentAsString());
        peopleAsc = res.getJSONArray("people");
        PersonServiceTest.assertEquals((String)"The number of returned results is not correct.", (int)2, (int)peopleAsc.length());
        this.checkPaging(6, 4, 2, res);
        for (i = 0; i < peopleAsc.length(); ++i) {
            person = peopleAsc.getJSONObject(i);
            PersonServiceTest.assertEquals((String)"The name of a person does not match. Paging is not correct", (String)(filter + (4 + i)), (String)person.getString(SORT_BY_USERNAME));
        }
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?filter=" + filter + "&startIndex=3&pageSize=5"), 200);
        res = new JSONObject(response.getContentAsString());
        peopleAsc = res.getJSONArray("people");
        PersonServiceTest.assertEquals((String)"The number of returned results is not correct.", (int)3, (int)peopleAsc.length());
        this.checkPaging(6, 3, 5, res);
        for (i = 0; i < peopleAsc.length(); ++i) {
            person = peopleAsc.getJSONObject(i);
            PersonServiceTest.assertEquals((String)"The name of a person does not match. Paging is not correct", (String)(filter + (i + 3)), (String)person.getString(SORT_BY_USERNAME));
        }
    }

    private void checkPaging(int totalItems, int skipCount, int maxItems, JSONObject response) throws Exception {
        JSONObject paging = response.getJSONObject("paging");
        PersonServiceTest.assertEquals((String)"totalItems was not correct in the response", (int)totalItems, (int)paging.getInt("totalItems"));
        PersonServiceTest.assertEquals((String)"skipCount was not correct in the response", (int)skipCount, (int)paging.getInt("skipCount"));
        PersonServiceTest.assertEquals((String)"maxItems was not correct in the response", (int)maxItems, (int)paging.getInt("maxItems"));
    }

    public void testGetPeopleSorting() throws Exception {
        String filter = GUID.generate();
        String filterByJob = "jobtitle:job";
        String usernameA = filter + "-aaa-";
        String usernameB = filter + "-BBB-";
        String usernameC = filter + "-ccc-";
        String usernameD = filter + "-ddd-";
        String randomUserName = "userFilterTest-" + GUID.generate();
        this.createPerson(randomUserName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "myEmailAddress", "myBio", "images/avatar.jpg", 0L, 200);
        this.checkSorting(randomUserName, SORT_BY_USERNAME, randomUserName);
        this.createPerson(usernameA, "myTitle", filter, "aaa", "myOrganisation", "jobaaa", usernameA + "@alfresco.com", "myBio", "images/avatar.jpg", 2048L, 200);
        this.createPerson(usernameB, "myTitle", filter, "bbb", "myOrganisation", "bbjobb", usernameB + "@alfresco.com", "myBio", "images/avatar.jpg", 256L, 200);
        this.createPerson(usernameC, "myTitle", filter, "ccc", "myOrganisation", "cccjob", usernameC + "@alfresco.com", "myBio", "images/avatar.jpg", 512L, 200);
        this.createPerson(usernameD, "myTitle", filter, "DDD", "myOrganisation", "aJobd", usernameD + "@alfresco.com", "myBio", "images/avatar.jpg", 1024L, 200);
        this.addUserUsageContent(usernameA, 22);
        this.addUserUsageContent(usernameB, 10);
        this.addUserUsageContent(usernameC, 37);
        this.addUserUsageContent(usernameD, 50);
        this.userUsageTrackingComponent.execute();
        this.checkSorting(filter, SORT_BY_USERNAME, usernameA, usernameB, usernameC, usernameD);
        this.checkSorting(filter, SORT_BY_FULLNAME, usernameA, usernameB, usernameC, usernameD);
        this.checkSorting(filterByJob, SORT_BY_USERNAME, usernameA, usernameB, usernameC, usernameD);
        this.checkSorting(filterByJob, SORT_BY_FULLNAME, usernameA, usernameB, usernameC, usernameD);
        this.checkSorting(filterByJob, SORT_BY_JOBTITLE, usernameA, usernameB, usernameC, usernameD);
        this.checkSorting(filterByJob, SORT_BY_EMAIL, usernameA, usernameB, usernameC, usernameD);
        this.checkSorting(filterByJob, SORT_BY_QUOTA, usernameA, usernameB, usernameC, usernameD);
        this.checkSorting(filterByJob, SORT_BY_USAGE, usernameA, usernameB, usernameC, usernameD);
    }

    private void checkSorting(String filter, String sortBy, String ... usernames) throws Exception {
        this.dummySearchServiceQueryNodeRefs.clear();
        for (String username : usernames) {
            NodeRef nodeRef = this.personService.getPerson(username);
            this.dummySearchServiceQueryNodeRefs.add(nodeRef);
        }
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?sortBy=" + sortBy + "&filter=" + filter + "&dir=asc"), 200);
        JSONObject res = new JSONObject(response.getContentAsString());
        JSONArray peopleAsc = res.getJSONArray("people");
        PersonServiceTest.assertEquals((int)usernames.length, (int)peopleAsc.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?sortBy=" + sortBy + "&filter=" + filter + "&dir=desc"), 200);
        res = new JSONObject(response.getContentAsString());
        JSONArray peopleDesc = res.getJSONArray("people");
        PersonServiceTest.assertEquals((int)usernames.length, (int)peopleDesc.length());
        for (int i = 0; i < peopleAsc.length(); ++i) {
            PersonServiceTest.assertEquals((String)peopleAsc.getJSONObject(i).getString(SORT_BY_USERNAME), (String)peopleDesc.getJSONObject(peopleAsc.length() - i - 1).getString(SORT_BY_USERNAME));
        }
        this.assertCorrectSort(sortBy, peopleAsc);
    }

    private void assertCorrectSort(String sortBy, JSONArray peopleAsc) {
        for (int i = 0; i < peopleAsc.length() - 1; ++i) {
            long usageUser2;
            JSONObject person;
            if (SORT_BY_USERNAME.equals(sortBy)) {
                String userName2;
                person = peopleAsc.getJSONObject(i);
                String userName1 = person.getString(SORT_BY_USERNAME);
                PersonServiceTest.assertTrue((String)"Users are not ordered correctly ascending by username", (userName1.compareToIgnoreCase(userName2 = (person = peopleAsc.getJSONObject(i + 1)).getString(SORT_BY_USERNAME)) <= 0 ? 1 : 0) != 0);
                continue;
            }
            if (SORT_BY_FULLNAME.equals(sortBy)) {
                person = peopleAsc.getJSONObject(i);
                String firstName1 = person.getString("firstName");
                String lastName1 = person.getString("lastName");
                String fullName1 = (firstName1 == null ? "" : firstName1) + (lastName1 == null ? "" : lastName1);
                person = peopleAsc.getJSONObject(i + 1);
                String firstName2 = person.getString("firstName");
                String lastName2 = person.getString("lastName");
                String fullName2 = (firstName2 == null ? "" : firstName2) + (lastName2 == null ? "" : lastName2);
                PersonServiceTest.assertTrue((String)"Users are not ordered correctly ascending by fullname", (fullName1.compareToIgnoreCase(fullName2) <= 0 ? 1 : 0) != 0);
                continue;
            }
            if (SORT_BY_JOBTITLE.equals(sortBy)) {
                person = peopleAsc.getJSONObject(i);
                String jobUser1 = person.getString(SORT_BY_JOBTITLE);
                person = peopleAsc.getJSONObject(i + 1);
                String jobUser2 = person.getString(SORT_BY_JOBTITLE);
                PersonServiceTest.assertTrue((String)"Users are not ordered correctly ascending by jobtitle", ((jobUser1 == null ? "" : jobUser1).compareToIgnoreCase(jobUser2 == null ? "" : jobUser2) <= 0 ? 1 : 0) != 0);
                continue;
            }
            if (SORT_BY_EMAIL.equals(sortBy)) {
                person = peopleAsc.getJSONObject(i);
                String emailUser1 = person.getString(SORT_BY_EMAIL);
                person = peopleAsc.getJSONObject(i + 1);
                String emailUser2 = person.getString(SORT_BY_EMAIL);
                PersonServiceTest.assertTrue((String)"Users are not ordered correctly ascending by email", ((emailUser1 == null ? "" : emailUser1).compareToIgnoreCase(emailUser2 == null ? "" : emailUser2) <= 0 ? 1 : 0) != 0);
                continue;
            }
            if (SORT_BY_QUOTA.equals(sortBy)) {
                long quotaUser2;
                person = peopleAsc.getJSONObject(i);
                long quotaUser1 = person.getLong(SORT_BY_QUOTA);
                PersonServiceTest.assertTrue((String)"Users are not ordered correctly ascending by quota", (quotaUser1 <= (quotaUser2 = (person = peopleAsc.getJSONObject(i + 1)).getLong(SORT_BY_QUOTA)) ? 1 : 0) != 0);
                continue;
            }
            if (!SORT_BY_USAGE.equals(sortBy)) continue;
            person = peopleAsc.getJSONObject(i);
            long usageUser1 = person.getLong("sizeCurrent");
            PersonServiceTest.assertTrue((String)"Users are not ordered correctly ascending by usage", (usageUser1 <= (usageUser2 = (person = peopleAsc.getJSONObject(i + 1)).getLong("sizeCurrent")) ? 1 : 0) != 0);
        }
    }

    private void assertSearchQuery(String term, boolean buildFilter) {
        if (buildFilter) {
            String termWithEscapedAsterisks = ((String)term).replaceAll("\\*", "\\\\*");
            term = "\"*" + termWithEscapedAsterisks + "*\"";
        }
        String expectedQuery = "TYPE:\"{http://www.alfresco.org/model/content/1.0}person\" AND (" + (String)term + ")";
        ArgumentCaptor searchParametersCaptor = ArgumentCaptor.forClass(SearchParameters.class);
        ((SearchService)Mockito.verify((Object)this.mockSearchService, (VerificationMode)Mockito.times((int)(++this.callCount)))).query((SearchParameters)searchParametersCaptor.capture());
        SearchParameters parameters = (SearchParameters)searchParametersCaptor.getValue();
        PersonServiceTest.assertEquals((String)"Query", (String)expectedQuery, (String)parameters.getQuery());
    }

    private void addUserUsageContent(final String userName, final int stringDataLength) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> usageCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void execute() throws Throwable {
                try {
                    AuthenticationUtil.pushAuthentication();
                    AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
                    Object textData = "This is default text added. Add more: ";
                    for (int i = 0; i < stringDataLength; ++i) {
                        textData = (String)textData + "abc";
                    }
                    NodeRef homeFolder = PersonServiceTest.this.getHomeSpaceFolderNode(userName);
                    NodeRef folder = PersonServiceTest.this.nodeService.createNode(homeFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
                    PersonServiceTest.this.addTextContent(folder, "text1.txt", (String)textData);
                }
                finally {
                    AuthenticationUtil.popAuthentication();
                }
                return null;
            }
        };
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)usageCallback);
    }

    private NodeRef getHomeSpaceFolderNode(String userName) {
        return (NodeRef)this.nodeService.getProperty(this.personService.getPerson(userName), ContentModel.PROP_HOMEFOLDER);
    }

    private NodeRef addTextContent(NodeRef folderRef, String name, String textData) {
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, name);
        ChildAssociationRef association = this.nodeService.createNode(folderRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        ContentWriter writer = this.contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(textData);
        return content;
    }

    public void testUpdatePerson() throws Exception {
        String userName = RandomStringUtils.randomNumeric((int)6);
        this.createPerson(userName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 0L, 200);
        JSONObject result = this.updatePerson(userName, "updatedTitle", "updatedFirstName", "updatedLastName", "updatedOrganisation", "updatedJobTitle", "updatedFN.updatedLN@email.com", "updatedBio", "images/updatedAvatar.jpg", 200);
        PersonServiceTest.assertEquals((Object)userName, (Object)result.get(SORT_BY_USERNAME));
        PersonServiceTest.assertEquals((Object)"updatedFirstName", (Object)result.get("firstName"));
        PersonServiceTest.assertEquals((Object)"updatedLastName", (Object)result.get("lastName"));
        PersonServiceTest.assertEquals((Object)"updatedOrganisation", (Object)result.get("organization"));
        PersonServiceTest.assertEquals((Object)"updatedJobTitle", (Object)result.get(SORT_BY_JOBTITLE));
        PersonServiceTest.assertEquals((Object)"updatedFN.updatedLN@email.com", (Object)result.get(SORT_BY_EMAIL));
    }

    public void testDeletePerson() throws Exception {
        String userName = RandomStringUtils.randomNumeric((int)6);
        this.createPerson(userName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 0L, 200);
        this.deletePerson(userName, 200);
        this.deletePerson(userName, 404);
    }

    public void testCreatePerson() throws Exception {
        String userName = RandomStringUtils.randomNumeric((int)6);
        JSONObject result = this.createPerson(userName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 0L, 200);
        PersonServiceTest.assertEquals((Object)userName, (Object)result.get(SORT_BY_USERNAME));
        PersonServiceTest.assertEquals((Object)"myFirstName", (Object)result.get("firstName"));
        PersonServiceTest.assertEquals((Object)"myLastName", (Object)result.get("lastName"));
        PersonServiceTest.assertEquals((Object)"myOrganisation", (Object)result.get("organization"));
        PersonServiceTest.assertEquals((Object)"myJobTitle", (Object)result.get(SORT_BY_JOBTITLE));
        PersonServiceTest.assertEquals((Object)"firstName.lastName@email.com", (Object)result.get(SORT_BY_EMAIL));
        this.createPerson(userName, "myTitle", "myFirstName", "mylastName", "myOrganisation", "myJobTitle", "myEmail", "myBio", "images/avatar.jpg", 0L, 409);
    }

    public void testCreatePersonMissingUserName() throws Exception {
        this.createPerson(null, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 0L, 400);
        this.createPerson("", "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 0L, 400);
    }

    public void testCreatePersonMissingFirstName() throws Exception {
        String userName = RandomStringUtils.randomNumeric((int)6);
        this.createPerson(userName, "myTitle", null, "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 0L, 400);
        this.createPerson(userName, "myTitle", "", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 0L, 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserNameCaseSensitivityCQ() throws Exception {
        String upperCaseUserName = "PersonServiceTest.MixedCaseUser";
        String lowerCaseUserName = upperCaseUserName.toLowerCase();
        String currentUser = this.authenticationComponent.getCurrentUserName();
        try {
            this.createPerson(lowerCaseUserName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 0L, 200);
            String adminUser = this.authenticationComponent.getSystemUserName();
            this.authenticationComponent.setCurrentUser(adminUser);
            this.personService.setCreateMissingPeople(false);
            String filter = "PerSOnSerVIceTest.MixEDCasEUseR";
            this.assertPersonIsFound(filter);
            filter = "MyFiRsTnAmE";
            this.assertPersonIsFound(filter);
            filter = "MyLaStNaMe";
            this.assertPersonIsFound(filter);
        }
        finally {
            this.authenticationComponent.setCurrentUser(currentUser);
        }
    }

    private void assertPersonIsFound(String filter) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people?filter=" + filter), 200);
        JSONObject res = new JSONObject(response.getContentAsString());
        int peopleFound = res.getJSONArray("people").length();
        PersonServiceTest.assertTrue((String)"No people found", (peopleFound > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserNameCaseSensitivity() throws Exception {
        String upperCaseUserName = "PersonServiceTest.MixedCaseUser";
        String lowerCaseUserName = upperCaseUserName.toLowerCase();
        String currentUser = this.authenticationComponent.getCurrentUserName();
        boolean existingValue = this.userNameMatcherImpl.getUserNamesAreCaseSensitive();
        try {
            this.createPerson(lowerCaseUserName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 0L, 200);
            String adminUser = this.authenticationComponent.getSystemUserName();
            this.authenticationComponent.setCurrentUser(adminUser);
            this.personService.setCreateMissingPeople(false);
            this.userNameMatcherImpl.setUserNamesAreCaseSensitive(true);
            PersonServiceTest.assertTrue((String)"case sensitive exists by matching case", (boolean)this.personService.personExists(lowerCaseUserName));
            PersonServiceTest.assertFalse((String)"case sensitive exists by non matching case", (boolean)this.personService.personExists(upperCaseUserName));
            PersonServiceTest.assertNotNull((String)"case sensitive lookup by matching case", (Object)this.personService.getPerson(lowerCaseUserName));
            try {
                this.personService.getPerson(upperCaseUserName);
                PersonServiceTest.fail((String)"case sensitive lookup by non matching case");
            }
            catch (NoSuchPersonException noSuchPersonException) {
                // empty catch block
            }
            this.userNameMatcherImpl.setUserNamesAreCaseSensitive(false);
            PersonServiceTest.assertNotNull((String)"case insensitive lookup by matching case", (Object)this.personService.getPerson(lowerCaseUserName));
            PersonServiceTest.assertNotNull((String)"case insensitive lookup by non matching case", (Object)this.personService.getPerson(upperCaseUserName));
            PersonServiceTest.assertTrue((String)"case insensitive exists by matching case", (boolean)this.personService.personExists(lowerCaseUserName));
            PersonServiceTest.assertTrue((String)"case insensitive exists by non matching case", (boolean)this.personService.personExists(upperCaseUserName));
            this.personService.deletePerson(upperCaseUserName);
        }
        finally {
            this.userNameMatcherImpl.setUserNamesAreCaseSensitive(existingValue);
            this.authenticationComponent.setCurrentUser(currentUser);
        }
    }

    public void testDisableEnablePerson() throws Exception {
        String userName = RandomStringUtils.randomNumeric((int)6);
        this.createPerson(userName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 0L, 200);
        String currentUser = this.authenticationComponent.getCurrentUserName();
        String adminUser = this.authenticationComponent.getSystemUserName();
        this.authenticationComponent.setCurrentUser(adminUser);
        PersonServiceTest.assertTrue((String)"User isn't enabled", (boolean)this.personService.isEnabled(userName));
        this.authenticationComponent.setCurrentUser(adminUser);
        this.authenticationService.setAuthenticationEnabled(userName, false);
        this.authenticationComponent.setCurrentUser(adminUser);
        PersonServiceTest.assertFalse((String)"User must be disabled", (boolean)this.personService.isEnabled(userName));
        this.deletePerson(userName, 200);
        this.authenticationComponent.setCurrentUser(currentUser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_MNT10404_AuthenticationUtil() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        String user1 = "user1";
        String user2 = "user2";
        String user3 = "user3";
        ArrayList<String> users = new ArrayList<String>();
        try {
            users.add(user1);
            users.add(user2);
            users.add(user3);
            for (String user : users) {
                this.createPerson(user);
                PersonServiceTest.assertEquals((String)user, (String)this.getAuthInRun(user));
            }
        }
        finally {
            if (users.size() > 0) {
                for (String user : users) {
                    if (!this.personService.personExists(user)) continue;
                    this.personService.deletePerson(user);
                }
            }
        }
    }

    private String getAuthInRun(String userName) {
        AuthenticationUtil.RunAsWork<String> getWork = new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return AuthenticationUtil.getRunAsUser();
            }
        };
        return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)getWork, (String)userName);
    }

    private NodeRef createPerson(String userName) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, userName);
        return this.personService.createPerson(properties);
    }
}

