/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.trashcan;

import org.alfresco.repo.content.directurl.DirectAccessUrlDisabledException;
import org.alfresco.rest.api.DeletedNodes;
import org.alfresco.rest.api.DirectAccessUrlHelper;
import org.alfresco.rest.api.model.DirectAccessUrlRequest;
import org.alfresco.rest.api.model.Rendition;
import org.alfresco.rest.api.trashcan.TrashcanEntityResource;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceBinaryAction;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="renditions", entityResource=TrashcanEntityResource.class, title="Node renditions via archived node")
public class TrashcanRenditionsRelation
implements RelationshipResourceAction.Read<Rendition>,
RelationshipResourceAction.ReadById<Rendition>,
RelationshipResourceBinaryAction.Read,
InitializingBean {
    private DeletedNodes deletedNodes;
    private DirectAccessUrlHelper directAccessUrlHelper;

    public void setDeletedNodes(DeletedNodes deletedNodes) {
        this.deletedNodes = deletedNodes;
    }

    public void setDirectAccessUrlHelper(DirectAccessUrlHelper directAccessUrlHelper) {
        this.directAccessUrlHelper = directAccessUrlHelper;
    }

    @Override
    @WebApiDescription(title="List renditions", description="List available (created) renditions")
    public CollectionWithPagingInfo<Rendition> readAll(String nodeId, Parameters parameters) {
        return this.deletedNodes.getRenditions(nodeId, parameters);
    }

    @Override
    @WebApiDescription(title="Retrieve rendition information", description="Retrieve (created) rendition information")
    public Rendition readById(String nodeId, String renditionId, Parameters parameters) {
        return this.deletedNodes.getRendition(nodeId, renditionId, parameters);
    }

    @Override
    @WebApiDescription(title="Download archived node rendition", description="Download rendition for an archived node")
    @BinaryProperties(value={"content"})
    public BinaryResource readProperty(String nodeId, String renditionId, Parameters parameters) {
        return this.deletedNodes.getContent(nodeId, renditionId, parameters);
    }

    @Operation(value="request-direct-access-url")
    @WebApiParam(name="directAccessUrlRequest", title="Request direct access url", description="Options for direct access url request", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Request content url", description="Generates a direct access URL.", successStatus=200)
    public DirectAccessUrl requestContentDirectUrl(String originalNodeId, String renditionId, DirectAccessUrlRequest directAccessUrlRequest, Parameters parameters, WithResponse withResponse) {
        DirectAccessUrl directAccessUrl;
        boolean attachment = this.directAccessUrlHelper.getAttachment(directAccessUrlRequest);
        Long validFor = this.directAccessUrlHelper.getDefaultExpiryTimeInSec();
        try {
            directAccessUrl = this.deletedNodes.requestContentDirectUrl(originalNodeId, renditionId, attachment, validFor);
        }
        catch (DirectAccessUrlDisabledException ex) {
            throw new DisabledServiceException(ex.getMessage());
        }
        return directAccessUrl;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"deletedNodes", (Object)this.deletedNodes);
    }
}

