/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.trashcan;

import org.alfresco.repo.content.directurl.DirectAccessUrlDisabledException;
import org.alfresco.rest.api.DeletedNodes;
import org.alfresco.rest.api.DirectAccessUrlHelper;
import org.alfresco.rest.api.model.DirectAccessUrlRequest;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.NodeTargetAssoc;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.DisabledServiceException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.repository.DirectAccessUrl;

@EntityResource(name="deleted-nodes", title="Deleted Nodes")
public class TrashcanEntityResource
implements EntityResourceAction.ReadById<Node>,
EntityResourceAction.Read<Node>,
EntityResourceAction.Delete,
BinaryResourceAction.Read {
    private DeletedNodes deletedNodes;
    private DirectAccessUrlHelper directAccessUrlHelper;

    public void setDeletedNodes(DeletedNodes deletedNodes) {
        this.deletedNodes = deletedNodes;
    }

    public void setDirectAccessUrlHelper(DirectAccessUrlHelper directAccessUrlHelper) {
        this.directAccessUrlHelper = directAccessUrlHelper;
    }

    @Override
    public CollectionWithPagingInfo<Node> readAll(Parameters params) {
        return this.deletedNodes.listDeleted(params);
    }

    @Override
    public Node readById(String nodeId, Parameters parameters) throws EntityNotFoundException {
        return this.deletedNodes.getDeletedNode(nodeId, parameters, true, null);
    }

    @Operation(value="restore")
    @WebApiDescription(title="Restore deleted Node", description="Restores an archived node", successStatus=200)
    @WebApiParam(name="nodeAssocTarget", title="Target parent id and association type", description="Target parent id and association type", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT, required=false)
    public Node restoreDeletedNode(String nodeId, NodeTargetAssoc nodeTargetAssoc, Parameters parameters, WithResponse withResponse) {
        return this.deletedNodes.restoreArchivedNode(nodeId, nodeTargetAssoc);
    }

    @Override
    @WebApiDescription(title="Download content", description="Download content")
    @BinaryProperties(value={"content"})
    public BinaryResource readProperty(String nodeId, Parameters parameters) {
        return this.deletedNodes.getContent(nodeId, null, parameters);
    }

    @Operation(value="request-direct-access-url")
    @WebApiParam(name="directAccessUrlRequest", title="Request direct access url", description="Options for direct access url request", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Request content url", description="Generates a direct access URL.", successStatus=200)
    public DirectAccessUrl requestContentDirectUrl(String originalNodeId, DirectAccessUrlRequest directAccessUrlRequest, Parameters parameters, WithResponse withResponse) {
        DirectAccessUrl directAccessUrl;
        boolean attachment = this.directAccessUrlHelper.getAttachment(directAccessUrlRequest);
        Long validFor = this.directAccessUrlHelper.getDefaultExpiryTimeInSec();
        try {
            directAccessUrl = this.deletedNodes.requestContentDirectUrl(originalNodeId, null, attachment, validFor);
        }
        catch (DirectAccessUrlDisabledException ex) {
            throw new DisabledServiceException(ex.getMessage());
        }
        return directAccessUrl;
    }

    @Override
    public void delete(String nodeId, Parameters parameters) {
        this.deletedNodes.purgeArchivedNode(nodeId);
    }
}

