/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav.auth;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.jlan.server.auth.kerberos.KerberosDetails;
import org.alfresco.jlan.server.auth.kerberos.SessionSetupPrivilegedAction;
import org.alfresco.jlan.server.auth.spnego.NegTokenInit;
import org.alfresco.jlan.server.auth.spnego.NegTokenTarg;
import org.alfresco.jlan.server.auth.spnego.OID;
import org.alfresco.jlan.server.auth.spnego.SPNEGO;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.auth.KerberosCredentials;
import org.alfresco.repo.web.auth.TicketCredentials;
import org.alfresco.repo.webdav.auth.BaseSSOAuthenticationFilter;
import org.apache.commons.codec.binary.Base64;
import org.ietf.jgss.Oid;

public abstract class BaseKerberosAuthenticationFilter
extends BaseSSOAuthenticationFilter
implements CallbackHandler {
    private static final String LoginConfigEntry = "AlfrescoHTTP";
    private String m_accountName;
    private String m_password;
    private String m_krbRealm;
    private String m_loginEntryName = "AlfrescoHTTP";
    private LoginContext m_loginContext;
    private boolean m_stripKerberosUsernameSuffix = true;

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void setRealm(String realm) {
        this.m_krbRealm = realm;
    }

    public void setJaasConfigEntryName(String jaasConfigEntryName) {
        this.m_loginEntryName = jaasConfigEntryName;
    }

    public void setStripKerberosUsernameSuffix(boolean stripKerberosUsernameSuffix) {
        this.m_stripKerberosUsernameSuffix = stripKerberosUsernameSuffix;
    }

    @Override
    protected void init() throws ServletException {
        super.init();
        if (this.m_krbRealm == null) {
            throw new ServletException("Kerberos realm not specified");
        }
        if (this.m_password == null) {
            throw new ServletException("HTTP service account password not specified");
        }
        if (this.m_loginEntryName == null) {
            throw new ServletException("Invalid login entry specified");
        }
        String localName = null;
        try {
            localName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            throw new ServletException("Failed to get local host name");
        }
        try {
            this.m_loginContext = new LoginContext(this.m_loginEntryName, this);
            this.m_loginContext.login();
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)"HTTP Kerberos login successful");
            }
        }
        catch (LoginException ex) {
            this.getLogger().error((Object)"HTTP Kerberos web filter error", (Throwable)ex);
            throw new ServletException("Failed to login HTTP server service");
        }
        Subject subj = this.m_loginContext.getSubject();
        Principal princ = subj.getPrincipals().iterator().next();
        this.m_accountName = princ.getName();
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("Logged on using principal " + AuthenticationUtil.maskUsername((String)this.m_accountName)));
        }
        Vector<Oid> mechTypes = new Vector<Oid>();
        mechTypes.add(OID.KERBEROS5);
        mechTypes.add(OID.MSKERBEROS5);
        try {
            String mecListMIC = null;
            StringBuilder mic = new StringBuilder();
            mic.append(localName);
            mic.append("$@");
            mic.append(this.m_krbRealm);
            mecListMIC = mic.toString();
            NegTokenInit negTokenInit = new NegTokenInit(mechTypes, mecListMIC);
            negTokenInit.encode();
        }
        catch (IOException ex) {
            this.getLogger().error((Object)"Error creating SPNEGO NegTokenInit blob", (Throwable)ex);
            throw new ServletException("Failed to create SPNEGO NegTokenInit blob");
        }
    }

    @Override
    public boolean authenticateRequest(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String authHdr = req.getHeader("Authorization");
        boolean reqAuth = false;
        if (authHdr != null) {
            if (authHdr.startsWith("Negotiate")) {
                reqAuth = true;
            } else {
                if (authHdr.startsWith("NTLM")) {
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace((Object)"Received NTLM logon from client");
                    }
                    this.restartLoginChallenge(context, req, resp);
                    return false;
                }
                if (this.isFallbackEnabled()) {
                    return this.performFallbackAuthentication(context, req, resp);
                }
            }
        }
        SessionUser user = this.getSessionUser(context, req, resp, true);
        HttpSession httpSess = req.getSession(true);
        if (user == null && (user = (SessionUser)httpSess.getAttribute("_alfAuthTicket")) != null) {
            String userName = user.getUserName();
            AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
        }
        if (user != null && !reqAuth) {
            this.onValidate(context, req, resp, new TicketCredentials(user.getTicket()));
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)"Authentication not required (user), chaining ...");
            }
            return true;
        }
        if (this.checkLoginPage(req, resp)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Login page requested, chaining ...");
            }
            return true;
        }
        if (authHdr == null) {
            if (this.allowsTicketLogons() && this.checkForTicketParameter(context, req, resp)) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace((Object)"Authenticated with a ticket parameter.");
                }
                if (user == null) {
                    user = (SessionUser)httpSess.getAttribute(this.getUserAttributeName());
                }
                this.onValidate(context, req, resp, new TicketCredentials(user.getTicket()));
                return true;
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)("New Kerberos auth request from " + req.getRemoteHost() + " (" + req.getRemoteAddr() + ":" + req.getRemotePort() + ")"));
            }
            if (req.getRequestURL().toString().contains("webdav")) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"WebDAV request, fallback");
                }
                this.logonStartAgain(context, req, resp, false);
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Non-WebDAV request, don't fallback");
                }
                this.logonStartAgain(context, req, resp, true);
            }
            return false;
        }
        byte[] spnegoByts = Base64.decodeBase64((byte[])authHdr.substring(10).getBytes());
        if (this.isNTLMSSPBlob(spnegoByts, 0)) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)"Client sent an NTLMSSP security blob");
            }
            this.restartLoginChallenge(context, req, resp);
            return false;
        }
        int tokType = -1;
        try {
            tokType = SPNEGO.checkTokenType((byte[])spnegoByts, (int)0, (int)spnegoByts.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (tokType == 0) {
            NegTokenInit negToken = new NegTokenInit();
            try {
                negToken.decode(spnegoByts, 0, spnegoByts.length);
                String oidStr = null;
                if (negToken.numberOfOids() > 0) {
                    oidStr = negToken.getOidAt(0).toString();
                }
                if (oidStr != null && (oidStr.equals("1.2.840.48018.1.2.2") || oidStr.equals("1.2.840.113554.1.2.2"))) {
                    try {
                        NegTokenTarg negTokenTarg = this.doKerberosLogon(negToken, req, resp, httpSess);
                        if (negTokenTarg != null) {
                            this.onValidate(context, req, resp, new KerberosCredentials(negToken, negTokenTarg));
                            if (this.getLogger().isTraceEnabled()) {
                                this.getLogger().trace((Object)"Authenticated through Kerberos.");
                            }
                            return true;
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)"Failed SPNEGO authentication.");
                        }
                        this.restartLoginChallenge(context, req, resp);
                        return false;
                    }
                    catch (AuthenticationException ex) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)"Validate failed.", (Throwable)ex);
                        }
                        TicketCredentials webCredentials = user == null ? null : new TicketCredentials(user.getTicket());
                        this.onValidateFailed(context, req, resp, httpSess, webCredentials);
                        return false;
                    }
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Unsupported SPNEGO mechanism " + oidStr));
                }
                this.restartLoginChallenge(context, req, resp);
            }
            catch (IOException ex) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)ex);
                }
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Unknown SPNEGO token type");
            }
            this.restartLoginChallenge(context, req, resp);
        }
        return false;
    }

    protected boolean checkLoginPage(HttpServletRequest req, HttpServletResponse resp) {
        return this.hasLoginPage() && req.getRequestURI().endsWith(this.getLoginPage());
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("Processing the JAAS callback list of " + callbacks.length + " items."));
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cb;
            if (callbacks[i] instanceof NameCallback) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace((Object)"Request for user name.");
                }
                cb = (NameCallback)callbacks[i];
                ((NameCallback)cb).setName(this.m_accountName);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace((Object)"Request for password.");
                }
                cb = (PasswordCallback)callbacks[i];
                ((PasswordCallback)cb).setPassword(this.m_password.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof RealmCallback) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace((Object)"Request for realm.");
                }
                cb = (RealmCallback)callbacks[i];
                ((TextInputCallback)cb).setText(this.m_krbRealm);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    private final NegTokenTarg doKerberosLogon(NegTokenInit negToken, HttpServletRequest req, HttpServletResponse resp, HttpSession httpSess) {
        NegTokenTarg negTokenTarg;
        block9: {
            KerberosDetails krbDetails = null;
            String userName = null;
            negTokenTarg = null;
            try {
                SessionSetupPrivilegedAction sessSetupAction = new SessionSetupPrivilegedAction(this.m_accountName, negToken.getMechtoken());
                Object result = Subject.doAs(this.m_loginContext.getSubject(), sessSetupAction);
                if (result != null) {
                    krbDetails = (KerberosDetails)result;
                    userName = this.m_stripKerberosUsernameSuffix ? krbDetails.getUserName() : krbDetails.getSourceName();
                    negTokenTarg = new NegTokenTarg(0, OID.KERBEROS5, krbDetails.getResponseToken());
                    if (negTokenTarg != null) {
                        SessionUser user = this.createUserEnvironment(httpSess, userName);
                        if (this.getLogger().isTraceEnabled()) {
                            this.getLogger().trace((Object)("User " + AuthenticationUtil.maskUsername((String)user.getUserName()) + " logged on via Kerberos"));
                        }
                    }
                } else if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"No SPNEGO response, Kerberos logon failed");
                }
            }
            catch (AuthenticationException ex) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Failed to validate user " + AuthenticationUtil.maskUsername(userName)), (Throwable)ex);
                }
                throw ex;
            }
            catch (Exception ex) {
                if (!this.getLogger().isDebugEnabled()) break block9;
                this.getLogger().debug((Object)"Kerberos logon error", (Throwable)ex);
            }
        }
        return negTokenTarg;
    }

    @Override
    public void restartLoginChallenge(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)"Clearing session.");
            }
            session.invalidate();
        }
        this.logonStartAgain(context, req, resp);
    }

    public void logonStartAgain(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.logonStartAgain(context, req, resp, false);
    }

    private void logonStartAgain(ServletContext context, HttpServletRequest req, HttpServletResponse resp, boolean ignoreFallback) throws IOException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)"Issuing login challenge to browser.");
        }
        resp.setHeader("WWW-Authenticate", "Negotiate");
        if (!ignoreFallback && this.isFallbackEnabled()) {
            this.includeFallbackAuth(context, req, resp);
        }
        resp.setStatus(401);
        this.writeLoginPageLink(context, req, resp);
        resp.flushBuffer();
    }
}

