/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRuntime;

public class CMISHttpServletResponse
implements HttpServletResponse {
    protected HttpServletResponse httpResp;
    protected Set<String> nonAttachContentTypes = Collections.emptySet();
    private static final String HDR_CONTENT_DISPOSITION = "Content-Disposition";
    private static final String ATTACHMENT = "attachment";
    private static final String INLINE = "inline";

    public CMISHttpServletResponse(WebScriptResponse res, Set<String> nonAttachContentTypes) {
        this.httpResp = WebScriptServletRuntime.getHttpServletResponse((WebScriptResponse)res);
        this.nonAttachContentTypes = nonAttachContentTypes;
    }

    public void addCookie(Cookie cookie) {
        this.httpResp.addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this.httpResp.containsHeader(name);
    }

    public String encodeURL(String url) {
        return this.httpResp.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        return this.httpResp.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeUrl(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.httpResp.encodeRedirectUrl(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.httpResp.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.httpResp.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.httpResp.sendRedirect(location);
    }

    public void setDateHeader(String name, long date) {
        this.httpResp.setDateHeader(name, date);
    }

    public void addDateHeader(String name, long date) {
        this.httpResp.addDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.httpResp.setHeader(name, this.getStringHeaderValue(name, value, this.httpResp.getContentType()));
    }

    public void addHeader(String name, String value) {
        this.httpResp.addHeader(name, this.getStringHeaderValue(name, value, this.httpResp.getContentType()));
    }

    private String getStringHeaderValue(String name, String value, String contentType) {
        if (HDR_CONTENT_DISPOSITION.equals(name) && !this.nonAttachContentTypes.contains(contentType)) {
            if (((String)value).startsWith(INLINE)) {
                value = ATTACHMENT + ((String)value).substring(INLINE.length());
            } else if (!((String)value).startsWith(ATTACHMENT)) {
                throw new AlfrescoRuntimeException("Unexpected - header could not be set: " + name + " = " + (String)value);
            }
        }
        return value;
    }

    public void setIntHeader(String name, int value) {
        this.httpResp.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        this.httpResp.addIntHeader(name, value);
    }

    public void setStatus(int sc) {
        this.httpResp.setStatus(sc);
    }

    public void setStatus(int sc, String sm) {
        this.httpResp.setStatus(sc, sm);
    }

    public int getStatus() {
        return this.httpResp.getStatus();
    }

    public String getHeader(String name) {
        return this.httpResp.getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.httpResp.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this.httpResp.getHeaderNames();
    }

    public String getCharacterEncoding() {
        return this.httpResp.getCharacterEncoding();
    }

    public String getContentType() {
        return this.httpResp.getContentType();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.httpResp.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.httpResp.getWriter();
    }

    public void setCharacterEncoding(String charset) {
        this.httpResp.setCharacterEncoding(charset);
    }

    public void setContentLength(int len) {
        this.httpResp.setContentLength(len);
    }

    public void setContentType(String type) {
        this.httpResp.setContentType(type);
    }

    public void setBufferSize(int size) {
        this.httpResp.setBufferSize(size);
    }

    public int getBufferSize() {
        return this.httpResp.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.httpResp.flushBuffer();
    }

    public void resetBuffer() {
        this.httpResp.resetBuffer();
    }

    public boolean isCommitted() {
        return this.httpResp.isCommitted();
    }

    public void reset() {
        this.httpResp.reset();
    }

    public void setLocale(Locale loc) {
        this.httpResp.setLocale(loc);
    }

    public Locale getLocale() {
        return this.httpResp.getLocale();
    }
}

