/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.LockInfoImpl;
import org.alfresco.repo.webdav.MoveMethod;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVLockService;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={LuceneTests.class})
public class MoveMethodTest {
    private static ApplicationContext ctx;
    private MoveMethod moveMethod;
    @Mock
    private WebDAVHelper davHelper;
    private MockHttpServletRequest req;
    private MockHttpServletResponse resp;
    private NodeRef rootNode;
    @Mock
    private FileFolderService mockFileFolderService;
    @Mock
    private WebDAVLockService davLockService;
    @Mock
    private ServiceRegistry mockServiceRegistry;
    @Mock
    private ContentService mockContentService;
    private String destPath;
    private String sourcePath;
    private FileInfo sourceFileInfo;
    private NodeRef sourceParentNodeRef;
    private NodeRef destParentNodeRef;
    private NodeRef sourceNodeRef;
    private SearchService searchService;
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private ContentService contentService;
    private WebDAVHelper webDAVHelper;
    private Repository repositoryHelper;
    private NodeRef companyHomeNodeRef;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/remote-api-context.xml"});
    }

    @After
    public void tearDown() {
        this.moveMethod = null;
        this.req = null;
        this.resp = null;
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Before
    public void setUp() throws Exception {
        this.req = new MockHttpServletRequest();
        this.resp = new MockHttpServletResponse();
        this.rootNode = new NodeRef("workspace://SpacesStore/node1");
        this.moveMethod = new MoveMethod(){

            protected LockInfo checkNode(FileInfo fileInfo, boolean ignoreShared, boolean lockMethod) throws WebDAVServerException {
                return new LockInfoImpl();
            }

            protected LockInfo checkNode(FileInfo fileInfo) throws WebDAVServerException {
                return new LockInfoImpl();
            }
        };
        this.moveMethod.setDetails((HttpServletRequest)this.req, (HttpServletResponse)this.resp, this.davHelper, this.rootNode);
        this.sourceFileInfo = (FileInfo)Mockito.mock(FileInfo.class);
        Mockito.when((Object)this.sourceFileInfo.isFolder()).thenReturn((Object)true);
        this.moveMethod.m_strDestinationPath = this.destPath = "/path/to/dest.doc";
        this.moveMethod.m_strPath = this.sourcePath = "/path/to/source.doc";
        Mockito.when((Object)this.davHelper.getFileFolderService()).thenReturn((Object)this.mockFileFolderService);
        List<String> sourcePathSplit = Arrays.asList("path", "to", "source.doc");
        Mockito.when((Object)this.davHelper.splitAllPaths(this.sourcePath)).thenReturn(sourcePathSplit);
        List<String> destPathSplit = Arrays.asList("path", "to", "dest.doc");
        Mockito.when((Object)this.davHelper.splitAllPaths(this.destPath)).thenReturn(destPathSplit);
        Mockito.when((Object)this.mockFileFolderService.resolveNamePath(this.rootNode, sourcePathSplit)).thenReturn((Object)this.sourceFileInfo);
        FileInfo destFileInfo = (FileInfo)Mockito.mock(FileInfo.class);
        Mockito.when((Object)this.mockFileFolderService.resolveNamePath(this.rootNode, destPathSplit)).thenReturn((Object)destFileInfo);
        this.sourceParentNodeRef = new NodeRef("workspace://SpacesStore/parent");
        this.destParentNodeRef = new NodeRef("workspace://SpacesStore/parent");
        this.sourceNodeRef = new NodeRef("workspace://SpacesStore/sourcefile");
        Mockito.when((Object)this.davHelper.getLockService()).thenReturn((Object)this.davLockService);
        this.searchService = (SearchService)ctx.getBean("SearchService", SearchService.class);
        this.fileFolderService = (FileFolderService)ctx.getBean("FileFolderService", FileFolderService.class);
        this.nodeService = (NodeService)ctx.getBean("NodeService", NodeService.class);
        this.transactionService = (TransactionService)ctx.getBean("transactionService", TransactionService.class);
        this.contentService = (ContentService)ctx.getBean("contentService", ContentService.class);
        this.webDAVHelper = (WebDAVHelper)ctx.getBean("webDAVHelper", WebDAVHelper.class);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.repositoryHelper = (Repository)ctx.getBean("repositoryHelper");
        this.companyHomeNodeRef = this.repositoryHelper.getCompanyHome();
    }

    @Test
    public void canRenameFolders() throws Exception {
        this.moveMethod.moveOrCopy(this.sourceNodeRef, this.sourceParentNodeRef, this.destParentNodeRef, "dest.doc");
        ((FileFolderService)Mockito.verify((Object)this.mockFileFolderService)).rename(this.sourceNodeRef, "dest.doc");
        ((WebDAVLockService)Mockito.verify((Object)this.davLockService, (VerificationMode)Mockito.never())).unlock(this.sourceNodeRef);
        ((FileFolderService)Mockito.verify((Object)this.mockFileFolderService, (VerificationMode)Mockito.never())).create(this.destParentNodeRef, "dest.doc", ContentModel.TYPE_CONTENT);
    }

    @Test
    public void canRenameFoldersWhenNewNameMatchesShufflePattern() throws Exception {
        Mockito.when((Object)this.davHelper.isRenameShuffle(this.destPath)).thenReturn((Object)true);
        Mockito.when((Object)this.davHelper.isRenameShuffle(this.sourcePath)).thenReturn((Object)false);
        this.moveMethod.moveOrCopy(this.sourceNodeRef, this.sourceParentNodeRef, this.destParentNodeRef, "dest.doc");
        ((FileFolderService)Mockito.verify((Object)this.mockFileFolderService)).rename(this.sourceNodeRef, "dest.doc");
        ((WebDAVLockService)Mockito.verify((Object)this.davLockService, (VerificationMode)Mockito.never())).unlock(this.sourceNodeRef);
        ((FileFolderService)Mockito.verify((Object)this.mockFileFolderService, (VerificationMode)Mockito.never())).create(this.destParentNodeRef, "dest.doc", ContentModel.TYPE_CONTENT);
    }

    @Test
    public void canMoveFileUnlock() throws Exception {
        this.moveMethod = new MoveMethod(){

            protected LockInfo checkNode(FileInfo fileInfo, boolean ignoreShared, boolean lockMethod) throws WebDAVServerException {
                LockInfoImpl lockInfo = new LockInfoImpl();
                lockInfo.setExclusiveLockToken("opaque-lock-token");
                lockInfo.setDepth("infinity");
                lockInfo.setScope("exclusive");
                return lockInfo;
            }

            protected LockInfo checkNode(FileInfo fileInfo) throws WebDAVServerException {
                return this.checkNode(fileInfo, false, false);
            }
        };
        this.moveMethod.setDetails((HttpServletRequest)this.req, (HttpServletResponse)this.resp, this.davHelper, this.rootNode);
        this.sourceFileInfo = (FileInfo)Mockito.mock(FileInfo.class);
        Mockito.when((Object)this.sourceFileInfo.isFolder()).thenReturn((Object)true);
        this.moveMethod.m_strDestinationPath = this.destPath = "/path/to/test.doc";
        this.moveMethod.m_strPath = this.sourcePath = "/path/from/test.doc";
        Mockito.when((Object)this.davHelper.getServiceRegistry()).thenReturn((Object)this.mockServiceRegistry);
        Mockito.when((Object)this.mockServiceRegistry.getContentService()).thenReturn((Object)this.mockContentService);
        List<String> sourcePathSplit = Arrays.asList("path", "from", "test.doc");
        Mockito.when((Object)this.davHelper.splitAllPaths(this.sourcePath)).thenReturn(sourcePathSplit);
        List<String> destPathSplit = Arrays.asList("path", "to", "dest.doc");
        Mockito.when((Object)this.davHelper.splitAllPaths(this.destPath)).thenReturn(destPathSplit);
        Mockito.when((Object)this.mockFileFolderService.resolveNamePath(this.rootNode, sourcePathSplit)).thenReturn((Object)this.sourceFileInfo);
        FileInfo destFileInfo = (FileInfo)Mockito.mock(FileInfo.class);
        Mockito.when((Object)this.mockFileFolderService.resolveNamePath(this.rootNode, destPathSplit)).thenReturn((Object)destFileInfo);
        this.sourceParentNodeRef = new NodeRef("workspace://SpacesStore/parent1");
        this.destParentNodeRef = new NodeRef("workspace://SpacesStore/parent2");
        this.sourceNodeRef = new NodeRef("workspace://SpacesStore/sourcefile");
        this.moveMethod.moveOrCopy(this.sourceNodeRef, this.sourceParentNodeRef, this.destParentNodeRef, "test.doc");
        ((FileFolderService)Mockito.verify((Object)this.mockFileFolderService)).moveFrom(this.sourceNodeRef, this.sourceParentNodeRef, this.destParentNodeRef, "test.doc");
        ((WebDAVLockService)Mockito.verify((Object)this.davLockService)).unlock(this.sourceNodeRef);
    }

    @Test
    public void testMNT_13144() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute() throws Throwable {
                FileInfo dwgFI = null;
                String fileName = "source-" + GUID.generate();
                String sourceFileName = fileName + ".dwg";
                FileInfo atmpFI = null;
                String destFileName = "atmp1234";
                FileInfo tmpFI = null;
                String tmpFileName = fileName + ".tmp";
                String bakFileName = fileName + ".bak";
                String content = "Some dwg content.";
                String tmpContent = "Change dwg content.";
                try {
                    dwgFI = MoveMethodTest.this.fileFolderService.create(MoveMethodTest.this.companyHomeNodeRef, sourceFileName, ContentModel.TYPE_CONTENT);
                    ContentWriter writer = MoveMethodTest.this.contentService.getWriter(dwgFI.getNodeRef(), ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("application/dwg");
                    writer.setEncoding("UTF-8");
                    writer.putContent(content);
                    tmpFI = MoveMethodTest.this.fileFolderService.create(MoveMethodTest.this.companyHomeNodeRef, tmpFileName, ContentModel.TYPE_CONTENT);
                    writer = MoveMethodTest.this.contentService.getWriter(tmpFI.getNodeRef(), ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("application/dwg");
                    writer.setEncoding("UTF-8");
                    writer.putContent(tmpContent);
                    atmpFI = MoveMethodTest.this.fileFolderService.create(MoveMethodTest.this.companyHomeNodeRef, destFileName, ContentModel.TYPE_CONTENT);
                    MoveMethodTest.this.sourcePath = "/" + sourceFileName;
                    MoveMethodTest.this.moveMethod.m_strPath = MoveMethodTest.this.sourcePath;
                    MoveMethodTest.this.destPath = "/" + destFileName;
                    MoveMethodTest.this.moveMethod.m_strDestinationPath = MoveMethodTest.this.destPath;
                    List<String> sourcePathSplit = Arrays.asList(sourceFileName);
                    Mockito.when((Object)MoveMethodTest.this.davHelper.splitAllPaths(MoveMethodTest.this.sourcePath)).thenReturn(sourcePathSplit);
                    Mockito.when((Object)MoveMethodTest.this.mockFileFolderService.resolveNamePath(MoveMethodTest.this.rootNode, sourcePathSplit)).thenReturn((Object)dwgFI);
                    Mockito.when((Object)MoveMethodTest.this.davHelper.isRenameShuffle(MoveMethodTest.this.destPath)).thenReturn((Object)true);
                    Mockito.when((Object)MoveMethodTest.this.davHelper.isRenameShuffle(MoveMethodTest.this.sourcePath)).thenReturn((Object)false);
                    Mockito.when((Object)MoveMethodTest.this.mockFileFolderService.create(MoveMethodTest.this.companyHomeNodeRef, destFileName, ContentModel.TYPE_CONTENT)).thenReturn((Object)atmpFI);
                    ServiceRegistry mockServiceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
                    Mockito.when((Object)MoveMethodTest.this.davHelper.getServiceRegistry()).thenReturn((Object)mockServiceRegistry);
                    Mockito.when((Object)MoveMethodTest.this.davHelper.getServiceRegistry().getContentService()).thenReturn((Object)MoveMethodTest.this.contentService);
                    MoveMethodTest.this.moveMethod.moveOrCopy(dwgFI.getNodeRef(), MoveMethodTest.this.companyHomeNodeRef, MoveMethodTest.this.companyHomeNodeRef, destFileName);
                    ContentReader reader = MoveMethodTest.this.contentService.getReader(atmpFI.getNodeRef(), ContentModel.PROP_CONTENT);
                    Assert.assertNotNull((Object)reader);
                    Assert.assertEquals((Object)content, (Object)reader.getContentString());
                    MoveMethodTest.this.sourcePath = "/" + destFileName;
                    MoveMethodTest.this.moveMethod.m_strPath = MoveMethodTest.this.sourcePath;
                    MoveMethodTest.this.destPath = "/" + bakFileName;
                    MoveMethodTest.this.moveMethod.m_strDestinationPath = MoveMethodTest.this.destPath;
                    sourcePathSplit = Arrays.asList(destFileName);
                    Mockito.when((Object)MoveMethodTest.this.davHelper.splitAllPaths(MoveMethodTest.this.sourcePath)).thenReturn(sourcePathSplit);
                    Mockito.when((Object)MoveMethodTest.this.mockFileFolderService.resolveNamePath(MoveMethodTest.this.rootNode, sourcePathSplit)).thenReturn((Object)atmpFI);
                    Mockito.when((Object)MoveMethodTest.this.davHelper.isRenameShuffle(MoveMethodTest.this.destPath)).thenReturn((Object)true);
                    Mockito.when((Object)MoveMethodTest.this.davHelper.isRenameShuffle(MoveMethodTest.this.sourcePath)).thenReturn((Object)true);
                    MoveMethodTest.this.moveMethod.moveOrCopy(atmpFI.getNodeRef(), MoveMethodTest.this.companyHomeNodeRef, MoveMethodTest.this.companyHomeNodeRef, bakFileName);
                    ((FileFolderService)Mockito.verify((Object)MoveMethodTest.this.mockFileFolderService)).rename(atmpFI.getNodeRef(), bakFileName);
                    ((FileFolderService)Mockito.verify((Object)MoveMethodTest.this.mockFileFolderService, (VerificationMode)Mockito.never())).create(MoveMethodTest.this.destParentNodeRef, bakFileName, ContentModel.TYPE_CONTENT);
                    MoveMethodTest.this.sourcePath = "/" + tmpFileName;
                    MoveMethodTest.this.moveMethod.m_strPath = MoveMethodTest.this.sourcePath;
                    MoveMethodTest.this.destPath = "/" + sourceFileName;
                    MoveMethodTest.this.moveMethod.m_strDestinationPath = MoveMethodTest.this.destPath;
                    sourcePathSplit = Arrays.asList(tmpFileName);
                    Mockito.when((Object)MoveMethodTest.this.davHelper.splitAllPaths(MoveMethodTest.this.sourcePath)).thenReturn(sourcePathSplit);
                    Mockito.when((Object)MoveMethodTest.this.mockFileFolderService.resolveNamePath(MoveMethodTest.this.rootNode, sourcePathSplit)).thenReturn((Object)tmpFI);
                    Mockito.when((Object)MoveMethodTest.this.davHelper.isRenameShuffle(MoveMethodTest.this.destPath)).thenReturn((Object)false);
                    Mockito.when((Object)MoveMethodTest.this.davHelper.isRenameShuffle(MoveMethodTest.this.sourcePath)).thenReturn((Object)true);
                    MoveMethodTest.this.moveMethod.moveOrCopy(atmpFI.getNodeRef(), MoveMethodTest.this.companyHomeNodeRef, MoveMethodTest.this.companyHomeNodeRef, bakFileName);
                    reader = MoveMethodTest.this.contentService.getReader(dwgFI.getNodeRef(), ContentModel.PROP_CONTENT);
                    Assert.assertNotNull((Object)reader);
                    Assert.assertEquals((Object)tmpContent, (Object)reader.getContentString());
                }
                finally {
                    if (dwgFI != null) {
                        MoveMethodTest.this.nodeService.deleteNode(dwgFI.getNodeRef());
                    }
                    if (atmpFI != null) {
                        MoveMethodTest.this.nodeService.deleteNode(atmpFI.getNodeRef());
                    }
                }
                return null;
            }
        });
    }

    @Test(expected=AccessDeniedException.class)
    public void testMNT_10380_ThrowAccessDeniedExceptionWhenUserLacksPermissions() throws Exception {
        Mockito.when((Object)this.mockFileFolderService.rename(this.sourceNodeRef, "dest.doc")).thenThrow(new Throwable[]{new AccessDeniedException("Access denied in test by mockFileFolderService")});
        this.moveMethod.moveOrCopy(this.sourceNodeRef, this.sourceParentNodeRef, this.destParentNodeRef, "dest.doc");
    }

    @Test
    public void testMNT_9662() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute() throws Throwable {
                FileInfo testFileInfo = MoveMethodTest.this.fileFolderService.create(MoveMethodTest.this.companyHomeNodeRef, "folder-" + GUID.generate().substring(29), ContentModel.TYPE_FOLDER);
                MoveMethodTest.this.req = new MockHttpServletRequest("MOVE", "/alfresco/webdav/" + testFileInfo.getName());
                MoveMethodTest.this.resp = new MockHttpServletResponse();
                MoveMethodTest.this.req.setServerPort(8080);
                MoveMethodTest.this.req.setContextPath("/alfresco");
                MoveMethodTest.this.req.setServletPath("/webdav");
                MoveMethodTest.this.moveMethod = new MoveMethod();
                MoveMethodTest.this.moveMethod.setDetails((HttpServletRequest)MoveMethodTest.this.req, (HttpServletResponse)MoveMethodTest.this.resp, MoveMethodTest.this.webDAVHelper, MoveMethodTest.this.companyHomeNodeRef);
                String newName = GUID.generate().substring(28);
                MoveMethodTest.this.req.addHeader("Destination", (Object)("http://localhost:8080/alfresco/webdav/" + newName));
                try {
                    MoveMethodTest.this.moveMethod.execute();
                    Assert.assertTrue((boolean)MoveMethodTest.this.nodeService.exists(testFileInfo.getNodeRef()));
                    Assert.assertEquals((Object)newName, (Object)MoveMethodTest.this.nodeService.getProperty(testFileInfo.getNodeRef(), ContentModel.PROP_NAME));
                }
                catch (WebDAVServerException e) {
                    Assert.fail((String)("Fail to rename folder: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
                }
                finally {
                    MoveMethodTest.this.nodeService.deleteNode(testFileInfo.getNodeRef());
                }
                return null;
            }
        });
    }

    @Test
    public void testMNT_6480() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute() throws Throwable {
                String originalFileName = "content-" + GUID.generate() + ".txt";
                FileInfo testFileInfo = MoveMethodTest.this.fileFolderService.create(MoveMethodTest.this.companyHomeNodeRef, originalFileName, ContentModel.TYPE_CONTENT);
                String newFileName = originalFileName.toUpperCase();
                MoveMethodTest.this.req = new MockHttpServletRequest("MOVE", "/alfresco/webdav/" + testFileInfo.getName());
                MoveMethodTest.this.req.setServerPort(8080);
                MoveMethodTest.this.req.setContextPath("/alfresco");
                MoveMethodTest.this.req.setServletPath("/webdav");
                MoveMethodTest.this.req.addHeader("Destination", (Object)("http://localhost:8080/alfresco/webdav/" + newFileName));
                MoveMethodTest.this.resp = new MockHttpServletResponse();
                MoveMethodTest.this.moveMethod = new MoveMethod();
                MoveMethodTest.this.moveMethod.setDetails((HttpServletRequest)MoveMethodTest.this.req, (HttpServletResponse)MoveMethodTest.this.resp, MoveMethodTest.this.webDAVHelper, MoveMethodTest.this.companyHomeNodeRef);
                try {
                    MoveMethodTest.this.moveMethod.execute();
                    Assert.assertTrue((boolean)MoveMethodTest.this.nodeService.exists(testFileInfo.getNodeRef()));
                    Assert.assertEquals((Object)newFileName, (Object)MoveMethodTest.this.nodeService.getProperty(testFileInfo.getNodeRef(), ContentModel.PROP_NAME));
                }
                catch (WebDAVServerException e) {
                    Assert.fail((String)("Fail to rename node: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
                }
                finally {
                    MoveMethodTest.this.nodeService.deleteNode(testFileInfo.getNodeRef());
                }
                return null;
            }
        });
    }

    @Test
    public void testMNT_9777() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute() throws Throwable {
                String originalFileName = "tempfile-" + GUID.generate() + ".tmp";
                String newFileName = "destfile-" + GUID.generate() + ".txt";
                FileInfo sourceFileInfo = MoveMethodTest.this.fileFolderService.create(MoveMethodTest.this.companyHomeNodeRef, originalFileName, ContentModel.TYPE_CONTENT);
                FileInfo newFileInfo = MoveMethodTest.this.fileFolderService.create(MoveMethodTest.this.companyHomeNodeRef, newFileName, ContentModel.TYPE_CONTENT);
                String newContent = GUID.generate();
                ContentWriter writer = MoveMethodTest.this.contentService.getWriter(sourceFileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
                writer.putContent(newContent);
                MoveMethodTest.this.req = new MockHttpServletRequest("MOVE", "/alfresco/webdav/" + sourceFileInfo.getName());
                MoveMethodTest.this.resp = new MockHttpServletResponse();
                MoveMethodTest.this.req.setServerPort(8080);
                MoveMethodTest.this.req.setContextPath("/alfresco");
                MoveMethodTest.this.req.setServletPath("/webdav");
                MoveMethodTest.this.moveMethod = new MoveMethod();
                MoveMethodTest.this.moveMethod.setDetails((HttpServletRequest)MoveMethodTest.this.req, (HttpServletResponse)MoveMethodTest.this.resp, MoveMethodTest.this.webDAVHelper, MoveMethodTest.this.companyHomeNodeRef);
                String destPath = "http://localhost:8080/alfresco/webdav/" + newFileName;
                MoveMethodTest.this.req.addHeader("Destination", (Object)destPath);
                try {
                    MoveMethodTest.this.moveMethod.execute();
                    Assert.assertTrue((!MoveMethodTest.this.nodeService.exists(sourceFileInfo.getNodeRef()) ? 1 : 0) != 0);
                    ContentReader reader = MoveMethodTest.this.contentService.getReader(newFileInfo.getNodeRef(), ContentModel.PROP_CONTENT);
                    Assert.assertEquals((Object)newContent, (Object)reader.getContentString());
                }
                catch (WebDAVServerException e) {
                    Assert.fail((String)("Fail to move node: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
                }
                finally {
                    MoveMethodTest.this.nodeService.deleteNode(newFileInfo.getNodeRef());
                }
                return null;
            }
        });
    }
}

