/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.comment;

import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.post.lookup.PostLookup;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.security.permissions.impl.SimplePermissionEntry;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;
import org.springframework.extensions.webscripts.WebScriptException;

public class CommentsApiTest
extends BaseWebScriptTest {
    private static final String URL_POST_COMMENT = "api/node/{0}/{1}/{2}/comments";
    private static final String URL_DELETE_COMMENT = "api/comment/node/{0}/{1}/{2}?site={3}&itemtitle={4}&page={5}&pageParams={6}";
    private static final String URL_PUT_COMMENT = "api/comment/node/{0}/{1}/{2}";
    private static final String JSON = "application/json";
    private static final String SITE_SHORT_NAME = "SomeTestSiteShortName-" + System.currentTimeMillis();
    private static final String USER_ONE = "SomeTestUserOne";
    private static final String USER_TWO = "SomeTestUserTwo";
    private static final String USER_THREE = "SomeTestUserThree";
    private static final String USER_FOUR = "SomeTestUserFour";
    private static final String JSON_KEY_NODEREF = "nodeRef";
    private static final String JSON_KEY_ITEM = "item";
    private String requestBodyJson = "{\"title\" : \"Test Title\", \"content\" : \"Test Comment\"}";
    private FileFolderService fileFolderService;
    private TransactionService transactionService;
    private SearchService searchService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private VersionService versionService;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    protected PermissionServiceSPI permissionService;
    protected ModelDAO permissionModelDAO;
    private ActivityService activityService;
    private FeedGenerator feedGenerator;
    private PostLookup postLookup;
    private NodeRef rootNodeRef;
    private NodeRef companyHomeNodeRef;
    private NodeRef sharedHomeNodeRef;
    private NodeRef nodeRef;
    private NodeRef sitePage;
    private static final String USER_TEST = "UserTest";
    private static final String DOCLIB_CONTAINER = "documentLibrary";
    private UserTransaction txn;
    private String USER2 = "user2";
    private SiteService siteService;
    private NodeArchiveService nodeArchiveService;

    protected void setUp() throws Exception {
        NodeRef docLibContainer;
        super.setUp();
        ApplicationContext appContext = this.getServer().getApplicationContext();
        this.fileFolderService = (FileFolderService)appContext.getBean("fileFolderService");
        this.transactionService = (TransactionService)appContext.getBean("transactionService");
        this.searchService = (SearchService)appContext.getBean("SearchService");
        this.nodeService = (NodeService)appContext.getBean("nodeService");
        this.namespaceService = (NamespaceService)appContext.getBean("namespaceService");
        this.versionService = (VersionService)appContext.getBean("versionService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.permissionService = (PermissionServiceSPI)this.getServer().getApplicationContext().getBean("permissionService");
        this.permissionModelDAO = (ModelDAO)this.getServer().getApplicationContext().getBean("permissionsModelDAO");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.nodeArchiveService = (NodeArchiveService)this.getServer().getApplicationContext().getBean("nodeArchiveService");
        this.activityService = (ActivityService)this.getServer().getApplicationContext().getBean("activityService");
        ChildApplicationContextFactory activitiesFeed = (ChildApplicationContextFactory)this.getServer().getApplicationContext().getBean("ActivitiesFeed");
        ApplicationContext activitiesFeedCtx = activitiesFeed.getApplicationContext();
        this.feedGenerator = (FeedGenerator)activitiesFeedCtx.getBean("feedGenerator");
        this.postLookup = (PostLookup)activitiesFeedCtx.getBean("postLookup");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        List results = this.searchService.selectNodes(this.rootNodeRef, "/app:company_home", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Can't find /app:company_home");
        }
        this.companyHomeNodeRef = (NodeRef)results.get(0);
        results = this.searchService.selectNodes(this.rootNodeRef, "/app:company_home/app:shared", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Can't find /app:company_home/app:shared");
        }
        this.sharedHomeNodeRef = (NodeRef)results.get(0);
        results = this.searchService.selectNodes(this.rootNodeRef, "/app:company_home/cm:Commenty", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (results.size() > 0) {
            this.fileFolderService.delete((NodeRef)results.get(0));
        }
        this.nodeRef = this.fileFolderService.create(this.companyHomeNodeRef, "Commenty", ContentModel.TYPE_CONTENT).getNodeRef();
        this.versionService.ensureVersioningEnabled(this.nodeRef, null);
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.valueOf(true));
        this.createUser(this.USER2);
        this.createUser(USER_TEST);
        this.txn.commit();
        AuthenticationUtil.clearCurrentSecurityContext();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME);
        if (siteInfo == null) {
            siteInfo = this.siteService.createSite("SomeTestSite", SITE_SHORT_NAME, "SiteTitle", "SiteDescription", SiteVisibility.PUBLIC);
        }
        if ((docLibContainer = this.siteService.getContainer(SITE_SHORT_NAME, DOCLIB_CONTAINER)) == null) {
            this.siteService.createContainer(SITE_SHORT_NAME, DOCLIB_CONTAINER, ContentModel.TYPE_FOLDER, null);
        }
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.createUser(USER_ONE, "SiteConsumer");
        this.createUser(USER_TWO, "SiteContributor");
        this.createUser(USER_THREE, "SiteCollaborator");
        this.createUser(USER_FOUR, "SiteCollaborator");
        this.sitePage = this.nodeService.createNode(siteInfo.getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)"test"), ContentModel.TYPE_CONTENT).getChildRef();
        this.txn.commit();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        if (this.personService.personExists(USER_TEST)) {
            this.personService.deletePerson(USER_TEST);
        }
        if (this.authenticationService.authenticationExists(USER_TEST)) {
            this.authenticationService.deleteAuthentication(USER_TEST);
        }
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME);
        if (siteInfo != null) {
            this.siteService.deleteSite(SITE_SHORT_NAME);
            this.nodeArchiveService.purgeArchivedNode(this.nodeArchiveService.getArchivedNode(siteInfo.getNodeRef()));
        }
        this.deleteUser(USER_ONE);
        this.deleteUser(USER_TWO);
        this.deleteUser(USER_THREE);
        this.deleteUser(USER_FOUR);
    }

    private TestWebScriptServer.Response addComment(NodeRef nodeRef, String user, int status) throws Exception {
        TestWebScriptServer.Response response = null;
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        AuthenticationUtil.setFullyAuthenticatedUser((String)user);
        StringBuilder body = new StringBuilder("{");
        body.append("\"itemTitle\" : \"Test Title\", ");
        body.append("\"content\" : \"Test Comment\", ");
        body.append("\"pageParams\" : \"{\\\"nodeRef\\\" : \\\"");
        body.append(nodeRef.getStoreRef().getProtocol());
        body.append(":\\/\\/");
        body.append(nodeRef.getStoreRef().getIdentifier());
        body.append("\\/");
        body.append(nodeRef.getId());
        body.append("\\\"}");
        if (nodeRef.equals((Object)this.sitePage)) {
            body.append("\",\"site\" : \"");
            body.append(SITE_SHORT_NAME);
        }
        body.append("\"}");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(MessageFormat.format(URL_POST_COMMENT, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId()), body.toString(), JSON), status);
        CommentsApiTest.assertEquals((int)status, (int)response.getStatus());
        if (response.getStatus() == 500) {
            txn.rollback();
        } else {
            txn.commit();
        }
        return response;
    }

    private void deleteComment(NodeRef commentNodeRef, NodeRef parentNodeRef, String user, int status) throws Exception {
        TestWebScriptServer.Response response = null;
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        AuthenticationUtil.setFullyAuthenticatedUser((String)user);
        String itemTitle = "Test Title";
        String page = "document-details";
        StringBuilder pageParamsBuilder = new StringBuilder("{");
        pageParamsBuilder.append("\"nodeRef\" : \"");
        pageParamsBuilder.append(parentNodeRef.toString());
        pageParamsBuilder.append("\", ");
        pageParamsBuilder.append("}");
        String pageParams = pageParamsBuilder.toString();
        String URL2 = MessageFormat.format(URL_DELETE_COMMENT, commentNodeRef.getStoreRef().getProtocol(), commentNodeRef.getStoreRef().getIdentifier(), commentNodeRef.getId(), SITE_SHORT_NAME, itemTitle, page, pageParams);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL2), status);
        CommentsApiTest.assertEquals((int)status, (int)response.getStatus());
        if (response.getStatus() == 500) {
            txn.rollback();
        } else {
            txn.commit();
        }
    }

    private TestWebScriptServer.Response updateComment(NodeRef nodeRef, String user, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = null;
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        AuthenticationUtil.setFullyAuthenticatedUser((String)user);
        String now = "" + System.currentTimeMillis();
        JSONObject comment = new JSONObject();
        comment.put((Object)"title", (Object)("Test title updated " + now));
        comment.put((Object)"content", (Object)("Test comment updated " + now));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(MessageFormat.format(URL_PUT_COMMENT, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId()), comment.toString(), JSON), expectedStatus);
        CommentsApiTest.assertEquals((int)expectedStatus, (int)response.getStatus());
        if (response.getStatus() == 500) {
            txn.rollback();
        } else {
            txn.commit();
        }
        return response;
    }

    private String getCurrentVersion(NodeRef nodeRef) throws Exception {
        String version = this.versionService.getCurrentVersion(nodeRef).getVersionLabel();
        return version;
    }

    public void testCommentDoesNotVersion() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        String versionBefore = this.getCurrentVersion(this.nodeRef);
        this.addComment(this.nodeRef, AuthenticationUtil.getAdminUserName(), 200);
        String versionAfter = this.getCurrentVersion(this.nodeRef);
        CommentsApiTest.assertEquals((String)versionBefore, (String)versionAfter);
    }

    public void testCommentPermissions() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        NodeRef contentForUserContributor = this.fileFolderService.create(this.companyHomeNodeRef, "CommentyContributor" + System.currentTimeMillis(), ContentModel.TYPE_CONTENT).getNodeRef();
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(contentForUserContributor, this.getPermission("Contributor"), USER_TEST, AccessStatus.ALLOWED));
        NodeRef contentForUserConsumer = this.fileFolderService.create(this.companyHomeNodeRef, "CommentyConsumer" + System.currentTimeMillis(), ContentModel.TYPE_CONTENT).getNodeRef();
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(contentForUserConsumer, this.getPermission("Consumer"), USER_TEST, AccessStatus.ALLOWED));
        this.addComment(contentForUserContributor, USER_TEST, 200);
        txn.commit();
        this.addComment(contentForUserConsumer, USER_TEST, 500);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.nodeService.deleteNode(contentForUserContributor);
        this.nodeService.deleteNode(contentForUserConsumer);
        txn.commit();
    }

    public void testCommentUpdateAndDeletePermission() throws Exception {
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        NodeRef sharedContent = null;
        NodeRef siteContent = null;
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        sharedContent = this.fileFolderService.create(this.sharedHomeNodeRef, "SharedContent" + System.currentTimeMillis(), ContentModel.TYPE_CONTENT).getNodeRef();
        txn.commit();
        TestWebScriptServer.Response response = this.addComment(sharedContent, USER_THREE, 200);
        JSONObject jsonResponse = this.parseResponseJSON(response);
        NodeRef commentNodeRef = new NodeRef(this.getOrNull(jsonResponse, JSON_KEY_NODEREF));
        this.updateComment(commentNodeRef, USER_FOUR, 403);
        this.updateComment(commentNodeRef, USER_THREE, 200);
        this.deleteComment(commentNodeRef, sharedContent, USER_FOUR, 500);
        this.deleteComment(commentNodeRef, sharedContent, USER_THREE, 200);
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        NodeRef siteDocLibNodeRef = this.siteService.getContainer(SITE_SHORT_NAME, DOCLIB_CONTAINER);
        siteContent = this.fileFolderService.create(siteDocLibNodeRef, "SiteContent" + System.currentTimeMillis(), ContentModel.TYPE_CONTENT).getNodeRef();
        this.txn.commit();
        response = this.addComment(siteContent, USER_THREE, 200);
        jsonResponse = this.parseResponseJSON(response);
        commentNodeRef = new NodeRef(this.getOrNull(jsonResponse, JSON_KEY_NODEREF));
        this.updateComment(commentNodeRef, USER_FOUR, 403);
        this.updateComment(commentNodeRef, USER_THREE, 200);
        this.deleteComment(commentNodeRef, siteContent, USER_FOUR, 500);
        this.deleteComment(commentNodeRef, siteContent, USER_THREE, 200);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        if (sharedContent != null) {
            this.nodeService.deleteNode(sharedContent);
        }
        if (siteContent != null) {
            this.nodeService.deleteNode(siteContent);
        }
        this.txn.commit();
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"FirstNameTest");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"LastNameTest");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstNameTest.LastNameTest@test.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitleTest");
            this.personService.createPerson((Map)personProps);
        }
    }

    private PermissionReference getPermission(String permission) {
        return this.permissionModelDAO.getPermissionReference(null, permission);
    }

    public void testCommentDoesNotChangeModifier() throws Exception {
        this.permissionService.setPermission(this.nodeRef, this.USER2, "All", true);
        String modifierBefore = (String)((Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER));
        this.addComment(this.nodeRef, this.USER2, 200);
        String modifierAfter = (String)((Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER));
        CommentsApiTest.assertEquals((String)modifierBefore, (String)modifierAfter);
    }

    public void testDeleteCommentDoesNotChangeModifiedDate() throws Exception {
        this.permissionService.setPermission(this.sitePage, USER_TWO, "All", true);
        String modifierBefore = (String)((Object)this.nodeService.getProperty(this.sitePage, ContentModel.PROP_MODIFIER));
        Date modifiedDateBefore = (Date)this.nodeService.getProperty(this.sitePage, ContentModel.PROP_MODIFIED);
        TestWebScriptServer.Response response1 = this.addComment(this.sitePage, USER_TWO, 200);
        JSONObject jsonResponse1 = this.parseResponseJSON(response1);
        String nodeRefComment1 = this.getOrNull(jsonResponse1, JSON_KEY_NODEREF);
        if (nodeRefComment1 != null) {
            NodeRef commentNodeRef1 = new NodeRef(nodeRefComment1);
            this.deleteComment(commentNodeRef1, this.sitePage, USER_TWO, 200);
        }
        Date modifiedDateAfter = (Date)this.nodeService.getProperty(this.sitePage, ContentModel.PROP_MODIFIED);
        String modifierAfter = (String)((Object)this.nodeService.getProperty(this.sitePage, ContentModel.PROP_MODIFIER));
        CommentsApiTest.assertEquals((long)modifiedDateBefore.getTime(), (long)modifiedDateAfter.getTime());
        CommentsApiTest.assertEquals((String)modifierBefore, (String)modifierAfter);
        this.permissionService.setPermission(this.nodeRef, this.USER2, "All", true);
        modifierBefore = (String)((Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER));
        modifiedDateBefore = (Date)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        TestWebScriptServer.Response response2 = this.addComment(this.nodeRef, this.USER2, 200);
        JSONObject jsonResponse2 = this.parseResponseJSON(response2);
        String nodeRefComment2 = this.getOrNull(jsonResponse2, JSON_KEY_NODEREF);
        if (nodeRefComment2 != null) {
            NodeRef commentNodeRef2 = new NodeRef(nodeRefComment2);
            this.deleteComment(commentNodeRef2, this.nodeRef, this.USER2, 200);
        }
        modifiedDateAfter = (Date)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIED);
        modifierAfter = (String)((Object)this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_MODIFIER));
        CommentsApiTest.assertEquals((long)modifiedDateBefore.getTime(), (long)modifiedDateAfter.getTime());
        CommentsApiTest.assertEquals((String)modifierBefore, (String)modifierAfter);
    }

    public void testDeleteCommentPostActivity() throws Exception {
        this.permissionService.setPermission(this.sitePage, USER_TWO, "All", true);
        this.postLookup.execute();
        this.feedGenerator.execute();
        int activityNumStart = this.activityService.getSiteFeedEntries(SITE_SHORT_NAME).size();
        TestWebScriptServer.Response response = this.addComment(this.sitePage, USER_TWO, 200);
        this.postLookup.execute();
        this.feedGenerator.execute();
        int activityNumNext = this.activityService.getSiteFeedEntries(SITE_SHORT_NAME).size();
        CommentsApiTest.assertEquals((String)"The activity feeds were not generated after adding a comment", (int)(activityNumStart + 1), (int)activityNumNext);
        JSONObject jsonResponse = this.parseResponseJSON(response);
        String nodeRefComment = this.getOrNull(jsonResponse, JSON_KEY_NODEREF);
        NodeRef commentNodeRef = new NodeRef(nodeRefComment);
        this.deleteComment(commentNodeRef, this.sitePage, USER_TWO, 200);
        activityNumStart = activityNumNext;
        this.postLookup.execute();
        this.feedGenerator.execute();
        activityNumNext = this.activityService.getSiteFeedEntries(SITE_SHORT_NAME).size();
        CommentsApiTest.assertEquals((String)"The activity feeds were not generated after deleting a comment", (int)(activityNumStart + 1), (int)activityNumNext);
    }

    public void testConsumerCanNotComment() throws Exception {
        this.authenticationService.authenticate(USER_ONE, USER_ONE.toCharArray());
        String uri = MessageFormat.format(URL_POST_COMMENT, this.sitePage.getStoreRef().getProtocol(), this.sitePage.getStoreRef().getIdentifier(), this.sitePage.getId());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(uri, this.requestBodyJson, JSON), 500);
        CommentsApiTest.assertEquals((int)500, (int)response.getStatus());
    }

    public void testContributorCanComment() throws Exception {
        this.authenticationService.authenticate(USER_TWO, USER_TWO.toCharArray());
        String uri = MessageFormat.format(URL_POST_COMMENT, this.sitePage.getStoreRef().getProtocol(), this.sitePage.getStoreRef().getIdentifier(), this.sitePage.getId());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(uri, this.requestBodyJson, JSON), 200);
        CommentsApiTest.assertEquals((int)200, (int)response.getStatus());
    }

    private void createUser(String userName, String role) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, userName.toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"FirstName123");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"LastName123");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
        this.siteService.setMembership(SITE_SHORT_NAME, userName, role);
    }

    private void deleteUser(String user) {
        this.personService.deletePerson(user);
        if (this.authenticationService.authenticationExists(user)) {
            this.authenticationService.deleteAuthentication(user);
        }
    }

    protected String getOrNull(JSONObject json, String key) {
        if (json != null && json.containsKey((Object)key)) {
            return (String)json.get((Object)key);
        }
        JSONObject itemJsonObject = (JSONObject)json.get((Object)JSON_KEY_ITEM);
        if (itemJsonObject != null && itemJsonObject.containsKey((Object)key)) {
            return (String)itemJsonObject.get((Object)key);
        }
        return null;
    }

    protected JSONObject parseResponseJSON(TestWebScriptServer.Response response) {
        JSONObject json = null;
        String contentType = response.getContentType();
        if (contentType != null && contentType.indexOf(59) != -1) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        if (JSON.equals(contentType)) {
            JSONParser parser = new JSONParser();
            try {
                json = (JSONObject)parser.parse(response.getContentAsString());
            }
            catch (IOException io) {
                throw new WebScriptException(400, "Invalid JSON: " + io.getMessage());
            }
            catch (ParseException pe) {
                throw new WebScriptException(400, "Invalid JSON: " + pe.getMessage());
            }
        }
        return json;
    }
}

