/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.audit;

import java.net.URL;
import java.util.Date;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.AuditServiceImpl;
import org.alfresco.repo.audit.UserAuditFilter;
import org.alfresco.repo.audit.model.AuditModelRegistryImpl;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.LuceneTests;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.webscripts.TestWebScriptServer;
import org.springframework.util.ResourceUtils;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class})
public class AuditWebScriptTest
extends BaseWebScriptTest {
    private static final String APP_REPOTEST_NAME = "AlfrescoRepositoryTest";
    private static final String APP_REPOTEST_PATH = "/repositorytest";
    private static final String APP_SEARCHTEST_NAME = "SearchAudit";
    private static final String APP_SEARCHTEST_PATH = "/searchaudit";
    private ApplicationContext ctx;
    private AuditService auditService;
    private SearchService searchService;
    private AuthenticationService authenticationService;
    private FileFolderService fileFolderService;
    private Repository repositoryHelper;
    private String admin;
    private boolean wasGloballyEnabled;
    boolean wasRepoEnabled;
    private boolean wasSearchEnabled;
    private NodeRef testRoot;

    protected void setUp() throws Exception {
        super.setUp();
        this.ctx = this.getServer().getApplicationContext();
        UserAuditFilter userAuditFilter = new UserAuditFilter();
        userAuditFilter.setUserFilterPattern("System;.*");
        userAuditFilter.afterPropertiesSet();
        AuditComponent auditComponent = (AuditComponent)this.ctx.getBean("auditComponent");
        auditComponent.setUserAuditFilter(userAuditFilter);
        AuditServiceImpl auditServiceImpl = (AuditServiceImpl)this.ctx.getBean("auditService");
        auditServiceImpl.setAuditComponent(auditComponent);
        this.authenticationService = (AuthenticationService)this.ctx.getBean("AuthenticationService");
        this.auditService = (AuditService)this.ctx.getBean("AuditService");
        this.searchService = (SearchService)this.ctx.getBean("SearchService");
        this.repositoryHelper = (Repository)this.getServer().getApplicationContext().getBean("repositoryHelper");
        this.fileFolderService = (FileFolderService)this.getServer().getApplicationContext().getBean("FileFolderService");
        this.admin = AuthenticationUtil.getAdminUserName();
        AuditModelRegistryImpl auditModelRegistry = (AuditModelRegistryImpl)this.ctx.getBean("auditModel.modelRegistry");
        URL testModelUrl = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test-repository.xml");
        URL testModelUrl1 = ResourceUtils.getURL((String)"classpath:alfresco/testaudit/alfresco-audit-test-mnt-16748.xml");
        auditModelRegistry.registerModel(testModelUrl);
        auditModelRegistry.registerModel(testModelUrl1);
        auditModelRegistry.loadAuditModels();
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.admin);
        this.wasGloballyEnabled = this.auditService.isAuditEnabled();
        this.wasRepoEnabled = this.auditService.isAuditEnabled(APP_REPOTEST_NAME, APP_REPOTEST_PATH);
        this.wasSearchEnabled = this.auditService.isAuditEnabled(APP_SEARCHTEST_NAME, APP_SEARCHTEST_PATH);
        if (!this.wasGloballyEnabled) {
            this.auditService.setAuditEnabled(true);
            this.wasGloballyEnabled = this.auditService.isAuditEnabled();
            if (!this.wasGloballyEnabled) {
                AuditWebScriptTest.fail((String)"Failed to enable global audit for test");
            }
        }
        if (!this.wasRepoEnabled) {
            this.auditService.enableAudit(APP_REPOTEST_NAME, APP_REPOTEST_PATH);
            this.wasRepoEnabled = this.auditService.isAuditEnabled(APP_REPOTEST_NAME, APP_REPOTEST_PATH);
            if (!this.wasRepoEnabled) {
                AuditWebScriptTest.fail((String)"Failed to enable repo audit for test");
            }
        }
        if (!this.wasSearchEnabled) {
            this.auditService.enableAudit(APP_SEARCHTEST_NAME, APP_SEARCHTEST_PATH);
            this.wasSearchEnabled = this.auditService.isAuditEnabled(APP_SEARCHTEST_NAME, APP_SEARCHTEST_PATH);
            if (!this.wasSearchEnabled) {
                AuditWebScriptTest.fail((String)"Failed to enable search audit for test");
            }
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        try {
            if (!this.wasGloballyEnabled) {
                this.auditService.setAuditEnabled(false);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to set audit back to globally enabled/disabled state", e);
        }
        try {
            if (this.wasRepoEnabled) {
                this.auditService.enableAudit(APP_REPOTEST_NAME, APP_REPOTEST_PATH);
            } else {
                this.auditService.disableAudit(APP_REPOTEST_NAME, APP_REPOTEST_PATH);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to set repo audit back to enabled/disabled state", e);
        }
        try {
            if (this.wasSearchEnabled) {
                this.auditService.enableAudit(APP_SEARCHTEST_NAME, APP_SEARCHTEST_PATH);
            } else {
                this.auditService.disableAudit(APP_SEARCHTEST_NAME, APP_SEARCHTEST_PATH);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to set search audit back to enabled/disabled state", e);
        }
    }

    public void testGetWithoutPermissions() throws Exception {
        String url = "/api/audit/control";
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        this.sendRequest((TestWebScriptServer.Request)req, 401, AuthenticationUtil.getGuestRoleName());
    }

    public void testGetIsAuditEnabledGlobally() throws Exception {
        boolean wasEnabled = this.auditService.isAuditEnabled();
        Map checkApps = this.auditService.getAuditApplications();
        String url = "/api/audit/control";
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        JSONObject json = new JSONObject(response.getContentAsString());
        boolean enabled = json.getBoolean("enabled");
        AuditWebScriptTest.assertEquals((String)"Mismatched global audit enabled", (boolean)wasEnabled, (boolean)enabled);
        JSONArray apps = json.getJSONArray("applications");
        AuditWebScriptTest.assertEquals((String)"Incorrect number of applications reported", (int)checkApps.size(), (int)apps.length());
    }

    public void testGetIsAuditEnabledMissingApp() throws Exception {
        String url = "/api/audit/control/xxx";
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        this.sendRequest((TestWebScriptServer.Request)req, 404, this.admin);
    }

    public void testSetAuditEnabledGlobally() throws Exception {
        boolean wasEnabled = this.auditService.isAuditEnabled();
        if (wasEnabled) {
            String url = "/api/audit/control?enable=false";
            TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url, "", "application/json");
            this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        } else {
            String url = "/api/audit/control?enable=true";
            TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url, "", "application/json");
            this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        }
        this.testGetIsAuditEnabledGlobally();
    }

    public void testGetIsAuditEnabledRepo() throws Exception {
        boolean wasEnabled = this.auditService.isAuditEnabled(APP_REPOTEST_NAME, null);
        String url = "/api/audit/control/AlfrescoRepositoryTest/repositorytest";
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        if (wasEnabled) {
            TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
            JSONObject json = new JSONObject(response.getContentAsString());
            JSONArray apps = json.getJSONArray("applications");
            AuditWebScriptTest.assertEquals((String)"Incorrect number of applications reported", (int)1, (int)apps.length());
            JSONObject app = apps.getJSONObject(0);
            String appName = app.getString("name");
            String appPath = app.getString("path");
            boolean appEnabled = app.getBoolean("enabled");
            AuditWebScriptTest.assertEquals((String)"Mismatched application audit enabled", (boolean)wasEnabled, (boolean)appEnabled);
            AuditWebScriptTest.assertEquals((String)"Mismatched application audit name", (String)APP_REPOTEST_NAME, (String)appName);
            AuditWebScriptTest.assertEquals((String)"Mismatched application audit path", (String)APP_REPOTEST_PATH, (String)appPath);
        }
    }

    public void testGetAuditSearchService() throws Exception {
        String url = "/api/audit/clear/SearchAudit";
        TestWebScriptServer.PostRequest postReq = new TestWebScriptServer.PostRequest(url, "", "application/json");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)postReq, 200, this.admin);
        JSONObject json = new JSONObject(response.getContentAsString());
        AuditWebScriptTest.assertTrue((json.getInt("cleared") >= 0 ? 1 : 0) != 0);
        this.testRoot = this.repositoryHelper.getCompanyHome();
        String filename = "test_doc" + GUID.generate() + ".txt";
        NodeRef testFile = this.fileFolderService.create(this.testRoot, filename, ContentModel.TYPE_CONTENT).getNodeRef();
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("fts-alfresco");
        sp.setQuery("=cm:name:" + filename);
        sp.addStore(testFile.getStoreRef());
        this.searchService.query(sp);
        url = "/api/audit/query/SearchAudit/searchaudit/queryX/searchParametersX?verbose=true";
        TestWebScriptServer.GetRequest getReq = new TestWebScriptServer.GetRequest(url);
        response = this.sendRequest((TestWebScriptServer.Request)getReq, 200, this.admin);
        json = new JSONObject(response.getContentAsString());
        JSONArray jsonEntries = json.getJSONArray("entries");
        AuditWebScriptTest.assertEquals((String)"Incorrect number of entries reported", (int)1, (int)jsonEntries.length());
        JSONObject values = (JSONObject)((JSONObject)jsonEntries.get(0)).get("values");
        AuditWebScriptTest.assertTrue((String)"Audit entry was not found", (boolean)values.toString(0).contains("query==cm:name:" + filename));
        this.auditService.clearAudit(APP_SEARCHTEST_NAME, null, null);
    }

    public void testSetAuditEnabledRepo() throws Exception {
        boolean wasEnabled = this.auditService.isAuditEnabled(APP_REPOTEST_NAME, APP_REPOTEST_PATH);
        if (wasEnabled) {
            String url = "/api/audit/control/AlfrescoRepositoryTest/repositorytest?enable=false";
            TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url, "", "application/json");
            this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        } else {
            String url = "/api/audit/control/AlfrescoRepositoryTest/repositorytest?enable=true";
            TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url, "", "application/json");
            this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        }
        this.testGetIsAuditEnabledRepo();
    }

    private void loginWithFailure(final String username) throws Exception {
        AuthenticationUtil.RunAsWork<Void> failureWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                try {
                    AuditWebScriptTest.this.authenticationService.authenticate(username, "crud".toCharArray());
                    TestCase.fail((String)"Failed to force authentication failure");
                }
                catch (AuthenticationException authenticationException) {
                    // empty catch block
                }
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)failureWork, (String)AuthenticationUtil.getSystemUserName());
    }

    public synchronized void testClearAuditRepo() throws Exception {
        long now = System.currentTimeMillis() - 10L;
        long future = Long.MAX_VALUE;
        this.loginWithFailure(this.getName());
        try {
            ((Object)((Object)this)).wait(100L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object url = "/api/audit/clear/AlfrescoRepositoryTest?fromTime=" + future;
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest((String)url, "", "application/json");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        JSONObject json = new JSONObject(response.getContentAsString());
        int cleared = json.getInt("cleared");
        AuditWebScriptTest.assertEquals((String)"Could not have cleared more than 0", (int)0, (int)cleared);
        for (int i = 0; i < 60 && (cleared = (json = new JSONObject((response = this.sendRequest((TestWebScriptServer.Request)(req = new TestWebScriptServer.PostRequest((String)(url = "/api/audit/clear/AlfrescoRepositoryTest?fromTime=" + now + "&toTime=" + future), "", "application/json")), 200, this.admin)).getContentAsString())).getInt("cleared")) <= 0; ++i) {
            Thread.sleep(1000L);
        }
        AuditWebScriptTest.assertTrue((String)"Should have cleared at least 1 entry", (cleared > 0 ? 1 : 0) != 0);
        url = "/api/audit/clear/AlfrescoRepositoryTest";
        req = new TestWebScriptServer.PostRequest((String)url, "", "application/json");
        response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        json = new JSONObject(response.getContentAsString());
        cleared = json.getInt("cleared");
    }

    public void testQueryAuditRepo() throws Exception {
        long now = System.currentTimeMillis();
        long future = Long.MAX_VALUE;
        this.auditService.setAuditEnabled(true);
        this.auditService.enableAudit(APP_REPOTEST_NAME, APP_REPOTEST_PATH);
        this.loginWithFailure(this.getName());
        Object url = "/api/audit/query/AlfrescoRepositoryTest?fromTime=" + now + "&verbose=true";
        JSONArray jsonEntries = null;
        TestWebScriptServer.GetRequest req = null;
        TestWebScriptServer.Response response = null;
        JSONObject json = null;
        Long entryCount = null;
        for (int i = 0; i < 60; ++i) {
            req = new TestWebScriptServer.GetRequest((String)url);
            response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
            json = new JSONObject(response.getContentAsString());
            entryCount = json.getLong("count");
            jsonEntries = json.getJSONArray("entries");
            if (jsonEntries.length() > 0) break;
            Thread.sleep(1000L);
        }
        AuditWebScriptTest.assertTrue((String)"Expected at least one entry", (jsonEntries.length() > 0 ? 1 : 0) != 0);
        AuditWebScriptTest.assertEquals((String)"Entry count and physical count don't match", (Object)new Long(jsonEntries.length()), entryCount);
        JSONObject jsonEntry = jsonEntries.getJSONObject(0);
        Long entryId = jsonEntry.getLong("id");
        AuditWebScriptTest.assertNotNull((String)"No entry ID", (Object)entryId);
        String entryTimeStr = jsonEntry.getString("time");
        AuditWebScriptTest.assertNotNull((String)"No entry time String", (Object)entryTimeStr);
        Date entryTime = ISO8601DateFormat.parse((String)entryTimeStr);
        JSONObject jsonValues = jsonEntry.getJSONObject("values");
        String entryUsername = jsonValues.getString("/repositorytest/login/error/user");
        AuditWebScriptTest.assertEquals((String)"Didn't find the login-failure-user", (String)this.getName(), (String)entryUsername);
        Long fromEntryId = entryId;
        Long toEntryId = entryId + 1L;
        url = "/api/audit/query/AlfrescoRepositoryTest?fromId=" + fromEntryId + "&toId=" + toEntryId;
        req = new TestWebScriptServer.GetRequest((String)url);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        json = new JSONObject(response.getContentAsString());
        jsonEntries = json.getJSONArray("entries");
        AuditWebScriptTest.assertEquals((String)"Incorrect number of search results", (int)1, (int)jsonEntries.length());
        url = "/api/audit/query/AlfrescoRepositoryTest/repositorytest/login/error/userXXX?verbose=true";
        req = new TestWebScriptServer.GetRequest((String)url);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        json = new JSONObject(response.getContentAsString());
        jsonEntries = json.getJSONArray("entries");
        AuditWebScriptTest.assertTrue((String)"Should not have found anything", (jsonEntries.length() == 0 ? 1 : 0) != 0);
        url = "/api/audit/query/AlfrescoRepositoryTest/repositorytest/login/error/user?verbose=true";
        req = new TestWebScriptServer.GetRequest((String)url);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        json = new JSONObject(response.getContentAsString());
        jsonEntries = json.getJSONArray("entries");
        AuditWebScriptTest.assertTrue((String)"Should have found entries", (jsonEntries.length() > 0 ? 1 : 0) != 0);
        String missingUser = new Long(System.currentTimeMillis()).toString();
        url = "/api/audit/query/AlfrescoRepositoryTest/repositorytest/login/error/user?value=" + missingUser;
        req = new TestWebScriptServer.GetRequest((String)url);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        json = new JSONObject(response.getContentAsString());
        jsonEntries = json.getJSONArray("entries");
        AuditWebScriptTest.assertEquals((String)"Incorrect number of search results", (int)0, (int)jsonEntries.length());
        this.loginWithFailure(missingUser);
        url = "/api/audit/query/AlfrescoRepositoryTest/repositorytest/login/error/user?value=" + missingUser;
        for (int i = 0; i < 60 && (jsonEntries = (json = new JSONObject((response = this.sendRequest((TestWebScriptServer.Request)(req = new TestWebScriptServer.GetRequest((String)url)), 200, this.admin)).getContentAsString())).getJSONArray("entries")).length() != 1; ++i) {
            Thread.sleep(1000L);
        }
        AuditWebScriptTest.assertEquals((String)"Incorrect number of search results", (int)1, (int)jsonEntries.length());
        url = "/api/audit/query/AlfrescoRepositoryTest/repositorytest/login/error/user?value=" + missingUser + "&valueType=java.lang.Long";
        req = new TestWebScriptServer.GetRequest((String)url);
        response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        json = new JSONObject(response.getContentAsString());
        jsonEntries = json.getJSONArray("entries");
        AuditWebScriptTest.assertEquals((String)"Incorrect number of search results", (int)0, (int)jsonEntries.length());
        now = System.currentTimeMillis();
        String oddUser = "%$\u00a3\\\"'";
        this.loginWithFailure(oddUser);
        url = "/api/audit/query/AlfrescoRepositoryTest?forward=false&limit=1&verbose=true&fromTime=" + now;
        for (int i = 0; i < 60 && (jsonEntries = (json = new JSONObject((response = this.sendRequest((TestWebScriptServer.Request)(req = new TestWebScriptServer.GetRequest((String)url)), 200, this.admin)).getContentAsString())).getJSONArray("entries")).length() != 1; ++i) {
            Thread.sleep(1000L);
        }
        AuditWebScriptTest.assertEquals((String)"Incorrect number of search results", (int)1, (int)jsonEntries.length());
        jsonEntry = jsonEntries.getJSONObject(0);
        entryId = jsonEntry.getLong("id");
        AuditWebScriptTest.assertNotNull((String)"No entry ID", (Object)entryId);
        jsonValues = jsonEntry.getJSONObject("values");
        entryUsername = jsonValues.getString("/repositorytest/login/error/user");
        AuditWebScriptTest.assertEquals((String)"Didn't find the login-failure-user", (String)oddUser, (String)entryUsername);
    }
}

