/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import org.alfresco.rest.api.Actions;
import org.alfresco.rest.api.model.ActionDefinition;
import org.alfresco.rest.api.nodes.AbstractNodeRelation;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;

@RelationshipResource(name="action-definitions", entityResource=NodesEntityResource.class, title="Node action definitions")
public class NodeActionDefinitionsRelation
extends AbstractNodeRelation
implements RelationshipResourceAction.Read<ActionDefinition> {
    private Actions actions;

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        ParameterCheck.mandatory((String)"actions", (Object)this.actions);
    }

    public void setActions(Actions actions) {
        this.actions = actions;
    }

    @Override
    public CollectionWithPagingInfo<ActionDefinition> readAll(String entityResourceId, Parameters params) {
        NodeRef parentNodeRef = this.nodes.validateOrLookupNode(entityResourceId, null);
        return this.actions.getActionDefinitions(parentNodeRef, params);
    }
}

