/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.rest.api.model.AssocChild;
import org.alfresco.rest.api.model.AssocTarget;
import org.alfresco.rest.api.model.Document;
import org.alfresco.rest.api.model.Folder;
import org.alfresco.rest.api.model.LockInfo;
import org.alfresco.rest.api.model.Node;
import org.alfresco.rest.api.model.PathInfo;
import org.alfresco.rest.api.model.UserInfo;
import org.alfresco.rest.framework.resource.content.BasicContentInfo;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.servlet.FormData;

public interface Nodes {
    public static final String PATH_ROOT = "-root-";
    public static final String PATH_MY = "-my-";
    public static final String PATH_SHARED = "-shared-";
    public static final String OP_CREATE = "create";
    public static final String OP_DELETE = "delete";
    public static final String OP_UPDATE = "update";
    public static final String OP_UPDATE_PERMISSIONS = "updatePermissions";
    public static final String PARAM_RELATIVE_PATH = "relativePath";
    public static final String PARAM_PERMANENT = "permanent";
    public static final String PARAM_INCLUDE_PROPERTIES = "properties";
    public static final String PARAM_INCLUDE_PATH = "path";
    public static final String PARAM_INCLUDE_ASPECTNAMES = "aspectNames";
    public static final String PARAM_INCLUDE_ISLINK = "isLink";
    public static final String PARAM_INCLUDE_ISLOCKED = "isLocked";
    public static final String PARAM_INCLUDE_ALLOWABLEOPERATIONS = "allowableOperations";
    public static final String PARAM_INCLUDE_PERMISSIONS = "permissions";
    public static final String PARAM_INCLUDE_ISFAVORITE = "isFavorite";
    public static final String PARAM_INCLUDE_ASSOCIATION = "association";
    public static final String PARAM_INCLUDE_DEFINITION = "definition";
    public static final String PARAM_ISFOLDER = "isFolder";
    public static final String PARAM_ISFILE = "isFile";
    public static final String PARAM_INCLUDE_SUBTYPES = "INCLUDESUBTYPES";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_CREATEDAT = "createdAt";
    public static final String PARAM_MODIFIEDAT = "modifiedAt";
    public static final String PARAM_CREATEBYUSER = "createdByUser";
    public static final String PARAM_MODIFIEDBYUSER = "modifiedByUser";
    public static final String PARAM_MIMETYPE = "mimeType";
    public static final String PARAM_SIZEINBYTES = "sizeInBytes";
    public static final String PARAM_NODETYPE = "nodeType";
    public static final String PARAM_VERSION_MAJOR = "majorVersion";
    public static final String PARAM_VERSION_COMMENT = "comment";
    public static final String PARAM_OVERWRITE = "overwrite";
    public static final String PARAM_AUTO_RENAME = "autoRename";
    public static final String PARAM_ISPRIMARY = "isPrimary";
    public static final String PARAM_ASSOC_TYPE = "assocType";

    public Node getNode(String var1);

    public Document getDocument(NodeRef var1);

    public Folder getFolder(NodeRef var1);

    public Node getFolderOrDocument(String var1, Parameters var2);

    public Node getFolderOrDocumentFullInfo(NodeRef var1, NodeRef var2, QName var3, Parameters var4, Map<String, UserInfo> var5);

    public List<Node> getFoldersOrDocumentsFullInfo(List<NodeRef> var1, Parameters var2, Map<String, UserInfo> var3);

    public Node getFolderOrDocument(NodeRef var1, NodeRef var2, QName var3, List<String> var4, Map<String, UserInfo> var5);

    public List<Node> getFoldersOrDocuments(List<NodeRef> var1, List<String> var2, Map<String, UserInfo> var3);

    public CollectionWithPagingInfo<Node> listChildren(String var1, Parameters var2);

    public void deleteNode(String var1, Parameters var2);

    public Node createNode(String var1, Node var2, Parameters var3);

    public Node moveOrCopyNode(String var1, String var2, String var3, Parameters var4, boolean var5);

    public Node updateNode(String var1, Node var2, Parameters var3);

    public BinaryResource getContent(String var1, Parameters var2, boolean var3);

    public BinaryResource getContent(NodeRef var1, Parameters var2, boolean var3);

    public Node updateContent(String var1, BasicContentInfo var2, InputStream var3, Parameters var4);

    public Node upload(String var1, FormData var2, Parameters var3);

    public NodeRef validateNode(StoreRef var1, String var2);

    public List<NodeRef> validateNodes(StoreRef var1, List<String> var2);

    public NodeRef validateNode(String var1);

    public NodeRef validateNode(NodeRef var1);

    public NodeRef validateOrLookupNode(String var1, String var2);

    public boolean nodeMatches(NodeRef var1, Set<QName> var2, Set<QName> var3);

    public boolean isSubClass(NodeRef var1, QName var2, boolean var3);

    public QName createQName(String var1);

    public QName getAssocType(String var1);

    public QName getAssocType(String var1, boolean var2);

    public List<AssocChild> addChildren(String var1, List<AssocChild> var2);

    public List<AssocTarget> addTargets(String var1, List<AssocTarget> var2);

    public Node lock(String var1, LockInfo var2, Parameters var3);

    public Node unlock(String var1, Parameters var2);

    default public DirectAccessUrl requestContentDirectUrl(String nodeId, boolean attachment) {
        return this.requestContentDirectUrl(this.validateNode(nodeId), attachment);
    }

    default public DirectAccessUrl requestContentDirectUrl(NodeRef nodeRef, boolean attachment) {
        return this.requestContentDirectUrl(nodeRef, attachment, null);
    }

    default public DirectAccessUrl requestContentDirectUrl(String nodeId, boolean attachment, Long validFor) {
        return this.requestContentDirectUrl(this.validateNode(nodeId), attachment, validFor);
    }

    public DirectAccessUrl requestContentDirectUrl(NodeRef var1, boolean var2, Long var3);

    public Map<String, Object> mapFromNodeProperties(Map<QName, Serializable> var1, List<String> var2, Map<String, UserInfo> var3, List<String> var4, List<QName> var5);

    public Map<QName, Serializable> mapToNodeProperties(Map<String, Object> var1);

    public PathInfo lookupPathInfo(NodeRef var1, ChildAssociationRef var2);

    public Set<QName> mapToNodeAspects(List<String> var1);

    public List<String> mapFromNodeAspects(Set<QName> var1, List<String> var2, List<QName> var3);

    public void addCustomAspects(NodeRef var1, List<String> var2, List<QName> var3);

    public void updateCustomAspects(NodeRef var1, List<String> var2, List<QName> var3);

    public void validateAspects(List<String> var1, List<String> var2, List<QName> var3);

    public void validateProperties(Map<String, Object> var1, List<String> var2, List<QName> var3);
}

