/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.servlet;

import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.acegisecurity.DisabledException;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.web.auth.AuthenticationListener;
import org.alfresco.repo.web.auth.TicketCredentials;
import org.alfresco.repo.web.auth.WebCredentials;
import org.alfresco.repo.web.scripts.servlet.AuthenticationTimeoutException;
import org.alfresco.repo.web.scripts.servlet.BasicHttpAuthenticatorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public class RemoteUserAuthenticatorFactory
extends BasicHttpAuthenticatorFactory {
    private static Log logger = LogFactory.getLog(RemoteUserAuthenticatorFactory.class);
    public static final long GET_REMOTE_USER_TIMEOUT_MILLISECONDS_DEFAULT = 10000L;
    protected RemoteUserMapper remoteUserMapper;
    protected AuthenticationComponent authenticationComponent;
    private boolean alwaysAllowBasicAuthForAdminConsole = true;
    List<String> adminConsoleScriptFamilies;
    long getRemoteUserTimeoutMilliseconds = 10000L;

    public void setRemoteUserMapper(RemoteUserMapper remoteUserMapper) {
        this.remoteUserMapper = remoteUserMapper;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public boolean isAlwaysAllowBasicAuthForAdminConsole() {
        return this.alwaysAllowBasicAuthForAdminConsole;
    }

    public void setAlwaysAllowBasicAuthForAdminConsole(boolean alwaysAllowBasicAuthForAdminConsole) {
        this.alwaysAllowBasicAuthForAdminConsole = alwaysAllowBasicAuthForAdminConsole;
    }

    public List<String> getAdminConsoleScriptFamilies() {
        return this.adminConsoleScriptFamilies;
    }

    public void setAdminConsoleScriptFamilies(List<String> adminConsoleScriptFamilies) {
        this.adminConsoleScriptFamilies = adminConsoleScriptFamilies;
    }

    public long getGetRemoteUserTimeoutMilliseconds() {
        return this.getRemoteUserTimeoutMilliseconds;
    }

    public void setGetRemoteUserTimeoutMilliseconds(long getRemoteUserTimeoutMilliseconds) {
        this.getRemoteUserTimeoutMilliseconds = getRemoteUserTimeoutMilliseconds;
    }

    @Override
    public Authenticator create(WebScriptServletRequest req, WebScriptServletResponse res) {
        return new RemoteUserAuthenticator(req, res, this.listener);
    }

    public class RemoteUserAuthenticator
    extends BasicHttpAuthenticatorFactory.BasicHttpAuthenticator {
        public RemoteUserAuthenticator(WebScriptServletRequest req, WebScriptServletResponse res, AuthenticationListener listener) {
            super(req, res, listener);
        }

        @Override
        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            boolean authenticated;
            block19: {
                authenticated = false;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Authenticate level required: " + String.valueOf(required) + " is guest: " + isGuest));
                }
                String userId = null;
                if (this.isRemoteUserMapperActive()) {
                    if (RemoteUserAuthenticatorFactory.this.isAlwaysAllowBasicAuthForAdminConsole()) {
                        boolean useTimeoutForAdminAccessingAdminConsole = this.shouldUseTimeoutForAdminAccessingAdminConsole(required, isGuest);
                        if (useTimeoutForAdminAccessingAdminConsole && this.isBasicAuthHeaderPresentForAdmin()) {
                            return this.callBasicAuthForAdminConsoleAccess(required, isGuest);
                        }
                        try {
                            userId = this.getRemoteUserWithTimeout(useTimeoutForAdminAccessingAdminConsole);
                        }
                        catch (AuthenticationTimeoutException e) {
                            return false;
                        }
                    } else {
                        userId = this.getRemoteUser();
                    }
                }
                if (userId != null) {
                    try {
                        RemoteUserAuthenticatorFactory.this.authenticationComponent.setCurrentUser(userId);
                        this.listener.userAuthenticated(new TicketCredentials(RemoteUserAuthenticatorFactory.this.authenticationService.getCurrentTicket()));
                        authenticated = true;
                    }
                    catch (AuthenticationException authErr) {
                        Throwable disabledCause = ExceptionStackUtil.getCause((Throwable)authErr, (Class[])new Class[]{DisabledException.class});
                        if (disabledCause != null) {
                            this.listener.authenticationFailed(new WebCredentials(){});
                        }
                        throw authErr;
                    }
                } else {
                    HttpSession session = this.servletReq.getHttpServletRequest().getSession(false);
                    if (session != null) {
                        try {
                            SessionUser user = (SessionUser)session.getAttribute("_alfAuthTicket");
                            if (user != null) {
                                RemoteUserAuthenticatorFactory.this.authenticationService.validate(user.getTicket());
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Ticket is valid. Retaining cached user in session.");
                                }
                                this.listener.userAuthenticated(new TicketCredentials(user.getTicket()));
                                authenticated = true;
                                break block19;
                            }
                            authenticated = super.authenticate(required, isGuest);
                        }
                        catch (AuthenticationException authErr) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"An Authentication error occur. Removing User session.", (Throwable)authErr);
                            }
                            session.removeAttribute("_alfAuthTicket");
                            session.invalidate();
                            this.listener.authenticationFailed(new WebCredentials(){});
                        }
                    } else {
                        authenticated = super.authenticate(required, isGuest);
                    }
                }
            }
            return authenticated;
        }

        private boolean callBasicAuthForAdminConsoleAccess(Description.RequiredAuthentication required, boolean isGuest) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"An Admin Console request has come in with Basic Auth headers present for an admin user.");
            }
            return super.authenticate(required, isGuest);
        }

        private boolean shouldUseTimeoutForAdminAccessingAdminConsole(Description.RequiredAuthentication required, boolean isGuest) {
            boolean useTimeoutForAdminAccessingAdminConsole;
            boolean bl = useTimeoutForAdminAccessingAdminConsole = Description.RequiredAuthentication.admin.equals((Object)required) && !isGuest && this.servletReq.getServiceMatch() != null && this.isAdminConsoleWebScript(this.servletReq.getServiceMatch().getWebScript());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Should ensure that the admins can login with basic auth: " + useTimeoutForAdminAccessingAdminConsole));
            }
            return useTimeoutForAdminAccessingAdminConsole;
        }

        private boolean isRemoteUserMapperActive() {
            return RemoteUserAuthenticatorFactory.this.remoteUserMapper != null && (!(RemoteUserAuthenticatorFactory.this.remoteUserMapper instanceof ActivateableBean) || ((ActivateableBean)RemoteUserAuthenticatorFactory.this.remoteUserMapper).isActive());
        }

        protected boolean isAdminConsoleWebScript(WebScript webScript) {
            boolean isAdminConsole;
            if (webScript == null || RemoteUserAuthenticatorFactory.this.adminConsoleScriptFamilies == null || webScript.getDescription() == null || webScript.getDescription().getFamilys() == null) {
                return false;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("WebScript: " + String.valueOf(webScript) + " has these families: " + String.valueOf(webScript.getDescription().getFamilys())));
            }
            HashSet families = new HashSet(webScript.getDescription().getFamilys());
            families.retainAll(RemoteUserAuthenticatorFactory.this.adminConsoleScriptFamilies);
            boolean bl = isAdminConsole = !families.isEmpty();
            if (logger.isTraceEnabled() && isAdminConsole) {
                logger.trace((Object)("Detected an Admin Console webscript: " + String.valueOf(webScript)));
            }
            return isAdminConsole;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String getRemoteUserWithTimeout(boolean useTimeout) throws AuthenticationTimeoutException {
            if (!useTimeout) {
                return this.getRemoteUser();
            }
            String returnedRemoteUser = null;
            GetRemoteUserRunnable getRemoteUserRunnable = new GetRemoteUserRunnable();
            Thread workerGettingTheRemoteUser = new Thread(getRemoteUserRunnable);
            workerGettingTheRemoteUser.start();
            try {
                Thread thread = workerGettingTheRemoteUser;
                synchronized (thread) {
                    workerGettingTheRemoteUser.join(RemoteUserAuthenticatorFactory.this.getRemoteUserTimeoutMilliseconds);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Exception trying to get the remote user: " + e.getMessage()), (Throwable)e);
            }
            returnedRemoteUser = getRemoteUserRunnable.getReturnedRemoteUser();
            if (workerGettingTheRemoteUser.isAlive()) {
                this.cleanupThread(workerGettingTheRemoteUser);
                String message = "Could not get the remote user in a reasonable time: " + RemoteUserAuthenticatorFactory.this.getRemoteUserTimeoutMilliseconds + " milliseconds. Adjust the timeout property 'authentication.getRemoteUserTimeoutMilliseconds' if required.";
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Returning basic auth challenge for Admin Console. Cause: " + message));
                }
                HttpServletResponse res = this.servletRes.getHttpServletResponse();
                res.setStatus(401);
                res.setHeader("WWW-Authenticate", "Basic realm=\"Alfresco\"");
                throw new AuthenticationTimeoutException(message);
            }
            return returnedRemoteUser;
        }

        private void cleanupThread(Thread workerGettingTheRemoteUser) {
            try {
                workerGettingTheRemoteUser.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected String getRemoteUser() {
            String userId = null;
            if (this.isRemoteUserMapperActive()) {
                userId = RemoteUserAuthenticatorFactory.this.remoteUserMapper.getRemoteUser(this.servletReq.getHttpServletRequest());
            }
            this.logRemoteUserID(userId);
            return userId;
        }

        private void logRemoteUserID(String userId) {
            if (logger.isDebugEnabled()) {
                String message = userId == null ? "No external user ID in request." : "Extracted external user ID from request: " + AuthenticationUtil.maskUsername((String)userId);
                logger.debug((Object)message);
            }
        }

        class GetRemoteUserRunnable
        implements Runnable {
            private volatile String returnedRemoteUser;

            GetRemoteUserRunnable() {
            }

            @Override
            public void run() {
                this.returnedRemoteUser = RemoteUserAuthenticator.this.getRemoteUser();
            }

            public String getReturnedRemoteUser() {
                return this.returnedRemoteUser;
            }
        }
    }
}

