/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.admin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO9075;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;

public class NodeBrowserPost
extends DeclarativeWebScript
implements Serializable {
    private static final long serialVersionUID = 8464392337270665212L;
    private transient List<StoreRef> stores = null;
    private transient TransactionService transactionService;
    private transient NodeService nodeService;
    private transient DictionaryService dictionaryService;
    private transient SearchService searchService;
    private transient NamespaceService namespaceService;
    private transient PermissionService permissionService;
    private transient OwnableService ownableService;
    private transient LockService lockService;
    private transient CheckOutCheckInService cociService;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    protected TransactionService getTransactionService() {
        return this.transactionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    protected SearchService getSearchService() {
        return this.searchService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    protected NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    protected OwnableService getOwnableService() {
        return this.ownableService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    protected LockService getLockService() {
        return this.lockService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService cociService) {
        this.cociService = cociService;
    }

    protected CheckOutCheckInService getCheckOutCheckInService() {
        return this.cociService;
    }

    public List<StoreRef> getStores() {
        if (this.stores == null) {
            this.stores = this.getNodeService().getStores();
        }
        return this.stores;
    }

    public QName getNodeType(NodeRef nodeRef) {
        return this.getNodeService().getType(nodeRef);
    }

    public String getPrimaryPath(NodeRef nodeRef) {
        Path primaryPath = this.getNodeService().getPath(nodeRef);
        return ISO9075.decode((String)primaryPath.toString());
    }

    public String getPrimaryPrefixedPath(NodeRef nodeRef) {
        Path primaryPath = this.getNodeService().getPath(nodeRef);
        return ISO9075.decode((String)primaryPath.toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
    }

    public NodeRef getPrimaryParent(NodeRef nodeRef) {
        Path primaryPath = this.getNodeService().getPath(nodeRef);
        Path.Element element = primaryPath.last();
        NodeRef parentRef = ((Path.ChildAssocElement)element).getRef().getParentRef();
        return parentRef;
    }

    public List<Aspect> getAspects(NodeRef nodeRef) {
        Set qnames = this.getNodeService().getAspects(nodeRef);
        ArrayList<Aspect> aspects = new ArrayList<Aspect>(qnames.size());
        for (QName qname : qnames) {
            aspects.add(new Aspect(qname));
        }
        return aspects;
    }

    public List<ChildAssociation> getParents(NodeRef nodeRef) {
        List parents = this.getNodeService().getParentAssocs(nodeRef);
        ArrayList<ChildAssociation> assocs = new ArrayList<ChildAssociation>(parents.size());
        for (ChildAssociationRef ref : parents) {
            assocs.add(new ChildAssociation(ref));
        }
        return assocs;
    }

    public List<Property> getProperties(NodeRef nodeRef) {
        Map propertyValues = this.getNodeService().getProperties(nodeRef);
        ArrayList<Property> properties = new ArrayList<Property>(propertyValues.size());
        for (Map.Entry property : propertyValues.entrySet()) {
            properties.add(new Property((QName)property.getKey(), (Serializable)property.getValue(), nodeRef));
        }
        return properties;
    }

    public boolean getInheritPermissions(NodeRef nodeRef) {
        Boolean inheritPermissions = this.getPermissionService().getInheritParentPermissions(nodeRef);
        return inheritPermissions;
    }

    public List<Permission> getPermissions(NodeRef nodeRef) {
        ArrayList<Permission> permissions = null;
        AccessStatus readPermissions = this.getPermissionService().hasPermission(nodeRef, "ReadPermissions");
        if (readPermissions.equals((Object)AccessStatus.ALLOWED)) {
            ArrayList<Permission> nodePermissions = new ArrayList<Permission>();
            for (AccessPermission ap : this.getPermissionService().getAllSetPermissions(nodeRef)) {
                nodePermissions.add(new Permission(ap.getPermission(), ap.getAuthority(), ap.getAccessStatus().toString()));
            }
            permissions = nodePermissions;
        } else {
            ArrayList<Permission> noReadPermissions = new ArrayList<Permission>(1);
            noReadPermissions.add(new NoReadPermissionGranted());
            permissions = noReadPermissions;
        }
        return permissions;
    }

    public List<Permission> getStorePermissionMasks(NodeRef nodeRef) {
        ArrayList<Permission> permissionMasks = new ArrayList<Permission>(1);
        permissionMasks.add(new NoStoreMask());
        return permissionMasks;
    }

    public List<ChildAssociation> getChildren(NodeRef nodeRef) {
        List refs = this.getNodeService().getChildAssocs(nodeRef);
        ArrayList<ChildAssociation> assocs = new ArrayList<ChildAssociation>(refs.size());
        for (ChildAssociationRef ref : refs) {
            assocs.add(new ChildAssociation(ref));
        }
        return assocs;
    }

    public List<PeerAssociation> getAssocs(NodeRef nodeRef) {
        ArrayList refs = null;
        try {
            refs = this.getNodeService().getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
        }
        catch (UnsupportedOperationException err) {
            refs = new ArrayList();
        }
        ArrayList<PeerAssociation> assocs = new ArrayList<PeerAssociation>(refs.size());
        for (AssociationRef ref : refs) {
            assocs.add(new PeerAssociation(ref.getTypeQName(), ref.getSourceRef(), ref.getTargetRef()));
        }
        return assocs;
    }

    public List<PeerAssociation> getSourceAssocs(NodeRef nodeRef) {
        ArrayList refs = null;
        try {
            refs = this.getNodeService().getSourceAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
        }
        catch (UnsupportedOperationException err) {
            refs = new ArrayList();
        }
        ArrayList<PeerAssociation> assocs = new ArrayList<PeerAssociation>(refs.size());
        for (AssociationRef ref : refs) {
            assocs.add(new PeerAssociation(ref.getTypeQName(), ref.getSourceRef(), ref.getTargetRef()));
        }
        return assocs;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        HashMap<String, String> returnParams = new HashMap<String, String>(16);
        String store = req.getParameter("nodebrowser-store");
        String searcher = req.getParameter("nodebrowser-search");
        String query = req.getParameter("nodebrowser-query");
        String maxResults = req.getParameter("nodebrowser-query-maxresults");
        String skipCount = req.getParameter("nodebrowser-query-skipcount");
        String error = null;
        StoreRef storeRef = new StoreRef(store);
        List<ChildAssociationRef> assocRefs = Collections.emptyList();
        NodeRef currentNode = null;
        long timeStart = System.currentTimeMillis();
        String actionValue = req.getParameter("nodebrowser-action-value");
        String action = req.getParameter("nodebrowser-action");
        String execute = req.getParameter("nodebrowser-execute");
        final String executeValue = req.getParameter("nodebrowser-execute-value");
        String message = null;
        try {
            if (execute != null) {
                switch (execute) {
                    case "delete": {
                        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                NodeBrowserPost.this.nodeService.deleteNode(new NodeRef(executeValue));
                                return null;
                            }
                        }, false, true);
                        message = "nodebrowser.message.delete";
                        break;
                    }
                    case "fdelete": {
                        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                NodeRef ref = new NodeRef(executeValue);
                                NodeBrowserPost.this.nodeService.addAspect(ref, ContentModel.ASPECT_TEMPORARY, null);
                                NodeBrowserPost.this.nodeService.deleteNode(ref);
                                return null;
                            }
                        }, false, true);
                        message = "nodebrowser.message.delete";
                        break;
                    }
                    case "restore": {
                        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                NodeBrowserPost.this.nodeService.restoreNode(new NodeRef(executeValue), null, null, null);
                                return null;
                            }
                        }, false, true);
                        message = "nodebrowser.message.restore";
                        break;
                    }
                    case "take-ownership": {
                        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                NodeBrowserPost.this.ownableService.takeOwnership(new NodeRef(executeValue));
                                return null;
                            }
                        }, false, true);
                        message = "nodebrowser.message.take-ownership";
                        break;
                    }
                    case "delete-permissions": {
                        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                NodeRef ref = new NodeRef(executeValue);
                                NodeBrowserPost.this.permissionService.deletePermissions(ref);
                                NodeBrowserPost.this.permissionService.setInheritParentPermissions(ref, true);
                                return null;
                            }
                        }, false, true);
                        message = "nodebrowser.message.delete-permissions";
                        break;
                    }
                    case "delete-property": {
                        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                String[] parts = executeValue.split("\\|");
                                NodeBrowserPost.this.nodeService.removeProperty(new NodeRef(parts[0]), QName.createQName((String)parts[1]));
                                return null;
                            }
                        }, false, true);
                        message = "nodebrowser.message.delete-property";
                        break;
                    }
                    case "unlock": {
                        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                NodeRef ref = new NodeRef(executeValue);
                                if (NodeBrowserPost.this.cociService.isCheckedOut(ref)) {
                                    NodeRef wcRef = NodeBrowserPost.this.cociService.getWorkingCopy(ref);
                                    if (wcRef != null) {
                                        NodeBrowserPost.this.cociService.cancelCheckout(wcRef);
                                    }
                                } else {
                                    NodeBrowserPost.this.lockService.unlock(ref);
                                }
                                return null;
                            }
                        }, false, true);
                        message = "nodebrowser.message.unlock";
                    }
                }
            }
            block25 : switch (action) {
                case "search": {
                    if (query == null || query.trim().length() == 0) break;
                    switch (searcher) {
                        case "noderef": {
                            NodeRef nodeRef = new NodeRef(query);
                            boolean exists = this.getNodeService().exists(nodeRef);
                            if (!exists) {
                                throw new AlfrescoRuntimeException("Node " + String.valueOf(nodeRef) + " does not exist.");
                            }
                            currentNode = nodeRef;
                            assocRefs = this.getNodeService().getChildAssocs(currentNode);
                            actionValue = query;
                            action = "parent";
                            break;
                        }
                        case "selectnodes": {
                            List nodes = this.getSearchService().selectNodes(this.getNodeService().getRootNode(storeRef), query, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
                            assocRefs = new ArrayList(nodes.size());
                            for (NodeRef node : nodes) {
                                assocRefs.add(this.getNodeService().getPrimaryParent(node));
                            }
                            break block25;
                        }
                        default: {
                            SearchParameters params = new SearchParameters();
                            params.setQuery(query);
                            params.addStore(storeRef);
                            params.setLanguage(searcher);
                            if (maxResults != null && maxResults.length() != 0) {
                                params.setMaxItems(Integer.parseInt(maxResults));
                                params.setLimit(Integer.parseInt(maxResults));
                            }
                            if (skipCount != null && skipCount.length() != 0) {
                                params.setSkipCount(Integer.parseInt(skipCount));
                            }
                            ResultSet rs = this.getSearchService().query(params);
                            assocRefs = rs.getChildAssocRefs();
                            break;
                        }
                    }
                    break;
                }
                case "root": {
                    currentNode = this.getNodeService().getRootNode(storeRef);
                    assocRefs = this.getNodeService().getChildAssocs(currentNode);
                    break;
                }
                case "parent": 
                case "children": {
                    currentNode = new NodeRef(actionValue);
                    assocRefs = this.getNodeService().getChildAssocs(currentNode);
                }
            }
            ArrayList<ChildAssocRefWrapper> wrappers = new ArrayList<ChildAssocRefWrapper>(assocRefs.size());
            for (ChildAssociationRef ref : assocRefs) {
                wrappers.add(new ChildAssocRefWrapper(ref));
            }
            result.put("children", wrappers);
        }
        catch (Throwable e) {
            result.put("children", new ArrayList(0));
            error = e.getMessage();
        }
        if (currentNode != null) {
            HashMap<String, String> info = new HashMap<String, String>(8);
            info.put("nodeRef", currentNode.toString());
            info.put("path", this.getNodeService().getPath(currentNode).toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
            info.put("type", this.getNodeService().getType(currentNode).toPrefixString((NamespacePrefixResolver)this.getNamespaceService()));
            ChildAssociationRef parent = this.getNodeService().getPrimaryParent(currentNode);
            info.put("parent", parent.getParentRef() != null ? parent.getParentRef().toString() : "");
            result.put("info", info);
            result.put("properties", this.getProperties(currentNode));
            List parents = this.getNodeService().getParentAssocs(currentNode);
            ArrayList<ChildAssociation> assocs = new ArrayList<ChildAssociation>(parents.size());
            for (ChildAssociationRef ref : parents) {
                assocs.add(new ChildAssociation(ref));
            }
            result.put("parents", assocs);
            List<Aspect> aspects = this.getAspects(currentNode);
            result.put("aspects", aspects);
            List<PeerAssociation> targetAssocs = this.getAssocs(currentNode);
            result.put("assocs", targetAssocs);
            List<PeerAssociation> sourceAssocs = this.getSourceAssocs(currentNode);
            result.put("sourceAssocs", sourceAssocs);
            HashMap<String, Object> permissionInfo = new HashMap<String, Object>();
            permissionInfo.put("entries", this.getPermissions(currentNode));
            permissionInfo.put("owner", this.getOwnableService().getOwner(currentNode));
            permissionInfo.put("inherit", this.getInheritPermissions(currentNode));
            result.put("permissions", permissionInfo);
        }
        String resultId = GUID.generate();
        HttpServletRequest request = ((WebScriptServletRequest)req).getHttpServletRequest();
        HttpSession session = request.getSession();
        session.putValue(resultId, result);
        returnParams.put("resultId", resultId);
        returnParams.put("action", action);
        returnParams.put("actionValue", actionValue);
        returnParams.put("query", query);
        returnParams.put("store", store);
        returnParams.put("searcher", searcher);
        returnParams.put("maxResults", maxResults);
        returnParams.put("skipCount", skipCount);
        returnParams.put("in", Long.toString(System.currentTimeMillis() - timeStart));
        returnParams.put("e", error);
        returnParams.put("m", message);
        status.setCode(301);
        status.setRedirect(true);
        status.setLocation(NodeBrowserPost.buildUrl(req, returnParams, execute != null && execute.length() != 0 ? execute : action));
        return null;
    }

    private static String buildUrl(WebScriptRequest req, Map<String, String> params, String hash) {
        StringBuilder url = new StringBuilder(256);
        url.append(req.getServicePath());
        if (!params.isEmpty()) {
            boolean first = true;
            for (String key : params.keySet()) {
                String val = params.get(key);
                if (val == null || val.length() == 0) continue;
                url.append(first ? (char)'?' : '&');
                url.append(key);
                url.append('=');
                url.append(URLEncoder.encode((String)val));
                first = false;
            }
        }
        if (hash != null && hash.length() != 0) {
            url.append('#').append(hash);
        }
        return url.toString();
    }

    public class Aspect
    extends QNameBean
    implements Serializable {
        private static final long serialVersionUID = -6448182941386934326L;

        public Aspect(QName name) {
            super(name);
        }
    }

    public class ChildAssociation
    extends Association
    implements Serializable {
        private static final long serialVersionUID = -52439282250891063L;
        protected NodeRef childRef;
        protected NodeRef parentRef;
        protected QNameBean childType;
        protected QNameBean parentType;
        protected boolean primary;
        protected QNameBean name;
        protected QNameBean typeName;

        public ChildAssociation(ChildAssociationRef ref) {
            super(ref.getQName() != null ? ref.getQName() : null, ref.getTypeQName() != null ? ref.getTypeQName() : null);
            this.childRef = ref.getChildRef();
            this.parentRef = ref.getParentRef();
            if (this.childRef != null) {
                this.childType = new QNameBean(NodeBrowserPost.this.getNodeType(this.childRef));
            }
            if (this.parentRef != null) {
                this.parentType = new QNameBean(NodeBrowserPost.this.getNodeType(this.parentRef));
            }
            this.primary = ref.isPrimary();
        }

        public NodeRef getChildRef() {
            return this.childRef;
        }

        public QNameBean getChildTypeName() {
            return this.childType;
        }

        public NodeRef getParentRef() {
            return this.parentRef;
        }

        public QNameBean getParentTypeName() {
            return this.parentType;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public boolean getPrimary() {
            return this.isPrimary();
        }
    }

    public class Property
    implements Serializable {
        private static final long serialVersionUID = 7755924782250077L;
        private QNameBean name;
        private boolean isCollection = false;
        private List<Value> values;
        private boolean residual;
        private QNameBean typeName;

        public Property(QName qname, Serializable value, NodeRef nodeRef) {
            List<Object> values;
            this.name = new QNameBean(qname);
            this.residual = true;
            PropertyDefinition propDef = NodeBrowserPost.this.getDictionaryService().getProperty(qname);
            if (propDef != null) {
                QName qn = propDef.getDataType().getName();
                QNameBean qNameBean = this.typeName = qn != null ? new QNameBean(propDef.getDataType().getName()) : null;
                if (propDef.getContainerClass().isAspect()) {
                    this.residual = false;
                } else {
                    boolean found = false;
                    for (ClassDefinition classDef = NodeBrowserPost.this.getDictionaryService().getClass(NodeBrowserPost.this.getNodeService().getType(nodeRef)); classDef != null && !(found = this.searchInClassDefinition(qname, classDef)); classDef = classDef.getParentClassDefinition()) {
                    }
                    boolean bl = this.residual = !found;
                }
            }
            if (value instanceof Collection) {
                Collection oldValues = (Collection)((Object)value);
                values = new ArrayList(oldValues.size());
                this.isCollection = true;
                for (Serializable multiValue : oldValues) {
                    values.add(new Value(multiValue instanceof QName ? new QNameBean((QName)multiValue) : multiValue));
                }
            } else {
                values = Collections.singletonList(new Value(value instanceof QName ? new QNameBean((QName)value) : value));
            }
            this.values = values;
        }

        private boolean searchInClassDefinition(QName qname, ClassDefinition classDef) {
            if (classDef != null) {
                for (QName definedPropQName : classDef.getProperties().keySet()) {
                    if (!qname.isMatch(definedPropQName)) continue;
                    return true;
                }
            }
            return false;
        }

        public QNameBean getName() {
            return this.name;
        }

        public QNameBean getTypeName() {
            return this.typeName;
        }

        public String getPrefixedName() {
            return this.name.getPrefixedName();
        }

        public List<Value> getValues() {
            return this.values;
        }

        public boolean getResidual() {
            return this.residual;
        }

        public boolean isAny() {
            return this.getTypeName() == null ? false : this.getTypeName().getName().equals(DataTypeDefinition.ANY.toString());
        }

        public boolean isCollection() {
            return this.isCollection;
        }

        public class Value
        implements Serializable {
            private static final long serialVersionUID = 47235536691732705L;
            private Serializable value;

            public Value(Serializable value) {
                this.value = value;
            }

            public Serializable getValue() {
                return this.value;
            }

            public String getDataType() {
                DataTypeDefinition dataTypeDefinition;
                String datatype = null;
                if (Property.this.getTypeName() != null) {
                    datatype = Property.this.getTypeName().getName();
                }
                if ((datatype == null || datatype.equals(DataTypeDefinition.ANY.toString())) && this.value != null && (dataTypeDefinition = NodeBrowserPost.this.getDictionaryService().getDataType(this.value.getClass())) != null) {
                    datatype = NodeBrowserPost.this.getDictionaryService().getDataType(this.value.getClass()).getName().toString();
                }
                return datatype;
            }

            public boolean isContent() {
                String datatype = this.getDataType();
                return datatype == null ? false : datatype.equals(DataTypeDefinition.CONTENT.toString());
            }

            public boolean isNodeRef() {
                String datatype = this.getDataType();
                return datatype == null ? false : datatype.equals(DataTypeDefinition.NODE_REF.toString()) || datatype.equals(DataTypeDefinition.CATEGORY.toString());
            }

            public boolean isNullValue() {
                return this.value == null;
            }
        }
    }

    public static class Permission
    implements Serializable {
        private static final long serialVersionUID = 1235536691732705L;
        private final String permission;
        private final String authority;
        private final String accessStatus;

        public Permission(String permission, String authority, String accessStatus) {
            this.permission = permission;
            this.authority = authority;
            this.accessStatus = accessStatus;
        }

        public String getPermission() {
            return this.permission;
        }

        public String getAuthority() {
            return this.authority;
        }

        public String getAccessStatus() {
            return this.accessStatus;
        }
    }

    public static class NoReadPermissionGranted
    extends Permission
    implements Serializable {
        private static final long serialVersionUID = 1236786691732705L;

        public NoReadPermissionGranted() {
            super("ReadPermissions", "[Current Authority]", "Not Granted");
        }
    }

    public static class NoStoreMask
    extends Permission
    implements Serializable {
        private static final long serialVersionUID = 3125536691732705L;

        public NoStoreMask() {
            super("All <No Mask>", "All", "Allowed");
        }
    }

    public class PeerAssociation
    extends Association
    implements Serializable {
        private static final long serialVersionUID = 4833278311416507L;
        protected NodeRef sourceRef;
        protected NodeRef targetRef;
        protected QNameBean sourceType;
        protected QNameBean targetType;
        protected QNameBean name;
        protected QNameBean typeName;

        public PeerAssociation(QName typeName, NodeRef sourceRef, NodeRef targetRef) {
            super(null, typeName);
            this.sourceRef = sourceRef;
            this.targetRef = targetRef;
            if (sourceRef != null) {
                this.sourceType = new QNameBean(NodeBrowserPost.this.getNodeType(sourceRef));
            }
            if (targetRef != null) {
                this.targetType = new QNameBean(NodeBrowserPost.this.getNodeType(targetRef));
            }
        }

        public NodeRef getSourceRef() {
            return this.sourceRef;
        }

        public QNameBean getSourceTypeName() {
            return this.sourceType;
        }

        public NodeRef getTargetRef() {
            return this.targetRef;
        }

        public QNameBean getTargetTypeName() {
            return this.targetType;
        }
    }

    public class ChildAssocRefWrapper
    implements Serializable {
        private static final long serialVersionUID = 4321292337846270665L;
        private final ChildAssociationRef ref;
        private String qname = null;
        private String typeqname = null;

        public ChildAssocRefWrapper(ChildAssociationRef r) {
            this.ref = r;
        }

        public String getTypeQName() {
            return this.typeqname != null ? this.typeqname : (this.typeqname = this.ref.getTypeQName() != null ? this.ref.getTypeQName().toPrefixString((NamespacePrefixResolver)NodeBrowserPost.this.getNamespaceService()) : "");
        }

        public String getQName() {
            return this.qname != null ? this.qname : (this.qname = this.ref.getQName() != null ? this.ref.getQName().toPrefixString((NamespacePrefixResolver)NodeBrowserPost.this.getNamespaceService()) : "");
        }

        public NodeRef getChildRef() {
            return this.ref.getChildRef();
        }

        public NodeRef getParentRef() {
            return this.ref.getParentRef();
        }

        public boolean isPrimary() {
            return this.ref.isPrimary();
        }

        public boolean isChildLocked() {
            return NodeBrowserPost.this.lockService != null && NodeBrowserPost.this.lockService.getLockType(this.ref.getChildRef()) != null;
        }
    }

    public class Association
    implements Serializable {
        private static final long serialVersionUID = 1078430803027004L;
        protected QNameBean name;
        protected QNameBean typeName;

        public Association(QName name, QName typeName) {
            this.name = name != null ? new QNameBean(name) : null;
            this.typeName = new QNameBean(typeName);
        }

        public QNameBean getName() {
            return this.name;
        }

        public QNameBean getTypeName() {
            return this.typeName;
        }
    }

    public class QNameBean
    implements Serializable {
        private static final long serialVersionUID = 6982292337846270774L;
        protected QName name;
        private String prefixString = null;

        public QNameBean(QName name) {
            this.name = name;
        }

        public String getName() {
            return this.name.toString();
        }

        public String getPrefixedName() {
            try {
                return this.prefixString != null ? this.prefixString : (this.prefixString = this.name.toPrefixString((NamespacePrefixResolver)NodeBrowserPost.this.getNamespaceService()));
            }
            catch (NamespaceException e) {
                return this.name.getLocalName();
            }
        }

        public String toString() {
            return this.getName();
        }
    }

    public class Node
    implements Serializable {
        private static final long serialVersionUID = 12608347204513848L;
        private String qnamePath;
        private String prefixedQNamePath;
        private NodeRef nodeRef;
        private NodeRef parentNodeRef;
        private QNameBean childAssoc;
        private QNameBean type;

        public Node(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
            Path path = NodeBrowserPost.this.getNodeService().getPath(nodeRef);
            this.qnamePath = path.toString();
            this.prefixedQNamePath = path.toPrefixString((NamespacePrefixResolver)NodeBrowserPost.this.getNamespaceService());
            this.parentNodeRef = NodeBrowserPost.this.getPrimaryParent(nodeRef);
            ChildAssociationRef ref = NodeBrowserPost.this.getNodeService().getPrimaryParent(nodeRef);
            this.childAssoc = ref.getQName() != null ? new QNameBean(ref.getQName()) : null;
            this.type = new QNameBean(NodeBrowserPost.this.getNodeService().getType(nodeRef));
        }

        public String getQnamePath() {
            return this.qnamePath;
        }

        public String getPrefixedQNamePath() {
            return this.prefixedQNamePath;
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public String getId() {
            return this.nodeRef.getId();
        }

        public String getName() {
            return this.childAssoc != null ? this.childAssoc.getName() : "";
        }

        public String getPrefixedName() {
            return this.childAssoc != null ? this.childAssoc.getPrefixedName() : "";
        }

        public QNameBean getType() {
            return this.type;
        }

        public void setNodeRef(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
        }

        public NodeRef getParentNodeRef() {
            return this.parentNodeRef;
        }

        public void setParentNodeRef(NodeRef parentNodeRef) {
            this.parentNodeRef = parentNodeRef;
        }
    }
}

