/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.util;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.web.util.HttpRangeProcessor;
import org.alfresco.service.cmr.repository.ContentReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class HttpRangeProcessorTest {
    private HttpRangeProcessor httpRangeProcessor;
    @Mock
    private ContentReader reader;

    @Before
    public void setUp() throws Exception {
        this.httpRangeProcessor = new HttpRangeProcessor(null);
        Mockito.when((Object)this.reader.getMimetype()).thenReturn((Object)"image/jpeg");
        Mockito.when((Object)this.reader.getSize()).thenReturn((Object)19133L);
        Mockito.when((Object)this.reader.getContentInputStream()).thenReturn((Object)this.getClass().getResourceAsStream("/test.jpg"));
    }

    @Test
    public void testValidRange() throws IOException {
        this.testRange("700-800", 206);
    }

    @Test
    public void testStartOnlyRange() throws IOException {
        this.testRange("19000-", 206);
    }

    @Test
    public void testNegativeRange() throws IOException {
        this.testRange("800-700", 416);
    }

    @Test
    public void testBeyondLengthRange() throws IOException {
        this.testRange("20000-", 416);
    }

    protected void testRange(String range, int expectedStatus) throws IOException {
        MockHttpServletResponse response = new MockHttpServletResponse();
        boolean result = this.httpRangeProcessor.processRange((HttpServletResponse)response, this.reader, range, null, null, null, null);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)expectedStatus, (long)response.getStatus());
        this.reader.getContentInputStream().close();
    }
}

