/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.web.scripts.solr.SOLRAuthenticationFilter;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SOLRAuthenticationFilterTest {
    @Test(expected=AlfrescoRuntimeException.class)
    public void testSharedSecretNotConfigured() throws Exception {
        SOLRAuthenticationFilter filter = new SOLRAuthenticationFilter();
        filter.setSecureComms(SOLRAuthenticationFilter.SecureCommsType.SECRET.name());
        filter.afterPropertiesSet();
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testSharedHeaderNotConfigured() throws Exception {
        SOLRAuthenticationFilter filter = new SOLRAuthenticationFilter();
        filter.setSecureComms(SOLRAuthenticationFilter.SecureCommsType.SECRET.name());
        filter.setSharedSecret("shared-secret");
        filter.setSharedSecretHeader("");
        filter.afterPropertiesSet();
    }

    @Test
    public void testHTTPSFilterAndSharedSecretSet() throws Exception {
        String headerKey = "test-header";
        String sharedSecret = "shared-secret";
        SOLRAuthenticationFilter filter = new SOLRAuthenticationFilter();
        filter.setSecureComms(SOLRAuthenticationFilter.SecureCommsType.HTTPS.name());
        filter.setSharedSecret(sharedSecret);
        filter.setSharedSecretHeader(headerKey);
        filter.afterPropertiesSet();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader(headerKey)).thenReturn((Object)sharedSecret);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)true);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletContext)Mockito.mock(ServletContext.class), (ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testHTTPSFilterAndInsecureRequest() throws Exception {
        SOLRAuthenticationFilter filter = new SOLRAuthenticationFilter();
        filter.setSecureComms(SOLRAuthenticationFilter.SecureCommsType.HTTPS.name());
        filter.afterPropertiesSet();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.isSecure()).thenReturn((Object)false);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletContext)Mockito.mock(ServletContext.class), (ServletRequest)request, (ServletResponse)response, chain);
    }

    @Test
    public void testNoAuthentication() throws Exception {
        SOLRAuthenticationFilter filter = new SOLRAuthenticationFilter();
        filter.setSecureComms(SOLRAuthenticationFilter.SecureCommsType.NONE.name());
        filter.afterPropertiesSet();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletContext)Mockito.mock(ServletContext.class), (ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Test
    public void testSharedSecretFilter() throws Exception {
        String headerKey = "test-header";
        String sharedSecret = "shared-secret";
        SOLRAuthenticationFilter filter = new SOLRAuthenticationFilter();
        filter.setSecureComms(SOLRAuthenticationFilter.SecureCommsType.SECRET.name());
        filter.setSharedSecret(sharedSecret);
        filter.setSharedSecretHeader(headerKey);
        filter.afterPropertiesSet();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader(headerKey)).thenReturn((Object)sharedSecret);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletContext)Mockito.mock(ServletContext.class), (ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.times((int)1))).doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Test
    public void testSharedSecretDontMatch() throws Exception {
        String headerKey = "test-header";
        String sharedSecret = "shared-secret";
        SOLRAuthenticationFilter filter = new SOLRAuthenticationFilter();
        filter.setSecureComms(SOLRAuthenticationFilter.SecureCommsType.SECRET.name());
        filter.setSharedSecret(sharedSecret);
        filter.setSharedSecretHeader(headerKey);
        filter.afterPropertiesSet();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getHeader(headerKey)).thenReturn((Object)"wrong-secret");
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletContext)Mockito.mock(ServletContext.class), (ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.times((int)0))).doFilter((ServletRequest)request, (ServletResponse)response);
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)403), Mockito.anyString());
    }

    @Test
    public void testSharedHeaderNotPresent() throws Exception {
        String headerKey = "test-header";
        String sharedSecret = "shared-secret";
        SOLRAuthenticationFilter filter = new SOLRAuthenticationFilter();
        filter.setSecureComms(SOLRAuthenticationFilter.SecureCommsType.SECRET.name());
        filter.setSharedSecret(sharedSecret);
        filter.setSharedSecretHeader(headerKey);
        filter.afterPropertiesSet();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletContext)Mockito.mock(ServletContext.class), (ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.times((int)0))).doFilter((ServletRequest)request, (ServletResponse)response);
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)403), Mockito.anyString());
    }
}

