/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe.swing;

import de.schlichtherle.truezip.io.swing.FileComboBoxBrowser;
import de.schlichtherle.truezip.swing.EnhancedPanel;
import de.schlichtherle.truezip.swing.PanelEvent;
import de.schlichtherle.truezip.swing.PanelListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AuthenticationPanel
extends JPanel {
    private static final long serialVersionUID = 3876515923659236921L;
    private static final String CLASS_NAME = AuthenticationPanel.class.getName();
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private static final File BASE_DIR = FileSystemView.getFileSystemView().getDefaultDirectory();
    static final int AUTH_PASSWD = 0;
    static final int AUTH_KEY_FILE = 1;
    private final JComboBox keyFile = new JComboBox();
    private final JButton keyFileChooser = new JButton();
    private final EnhancedPanel keyFilePanel = new EnhancedPanel();
    private JTabbedPane tabs;

    public AuthenticationPanel() {
        this.initComponents();
        new FileComboBoxBrowser(this.keyFile).setDirectory(BASE_DIR);
        ((JTextField)this.keyFile.getEditor().getEditorComponent()).setColumns(30);
    }

    public void setPasswdPanel(JPanel passwdPanel) {
        if (passwdPanel == null) {
            throw new NullPointerException();
        }
        passwdPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String title = resources.getString("tab.passwd");
        if (title.equals(this.tabs.getTitleAt(0))) {
            this.tabs.removeTabAt(0);
        }
        this.tabs.insertTab(title, null, passwdPanel, null, 0);
        this.tabs.setSelectedIndex(0);
        this.revalidate();
    }

    Document getKeyFileDocument() {
        return ((JTextComponent)this.keyFile.getEditor().getEditorComponent()).getDocument();
    }

    public File getKeyFile() {
        String path = (String)this.keyFile.getSelectedItem();
        File file = new File(path);
        return file.isAbsolute() ? file : new File(BASE_DIR.getPath(), path);
    }

    private void setKeyFile(File file) {
        String oldPath;
        String baseDirPath;
        String newPath = file.getPath();
        if (newPath.startsWith(baseDirPath = BASE_DIR.getPath())) {
            newPath = newPath.substring(baseDirPath.length() + 1);
        }
        if (newPath.equals(oldPath = (String)this.keyFile.getSelectedItem())) {
            return;
        }
        this.keyFile.setSelectedItem(newPath);
    }

    public int getAuthenticationMethod() {
        int method = this.tabs.getSelectedIndex();
        switch (method) {
            case 0: {
                assert (resources.getString("tab.passwd").equals(this.tabs.getTitleAt(method)));
                break;
            }
            case 1: {
                assert (resources.getString("tab.keyFile").equals(this.tabs.getTitleAt(method)));
                break;
            }
            default: {
                throw new AssertionError((Object)"Unsupported authentication method!");
            }
        }
        return method;
    }

    private void initComponents() {
        this.tabs = new JTabbedPane();
        JLabel keyFileLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.keyFilePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.keyFilePanel.addPanelListener(new PanelListener(){

            @Override
            public void ancestorWindowShown(PanelEvent evt) {
                AuthenticationPanel.this.keyFilePanelAncestorWindowShown(evt);
            }

            @Override
            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        this.keyFilePanel.setLayout(new GridBagLayout());
        keyFileLabel.setDisplayedMnemonic(resources.getString("keyFile").charAt(0));
        keyFileLabel.setLabelFor(this.keyFile);
        keyFileLabel.setText(resources.getString("keyFile"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.keyFilePanel.add((Component)keyFileLabel, gridBagConstraints);
        this.keyFile.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.keyFilePanel.add((Component)this.keyFile, gridBagConstraints);
        this.keyFileChooser.setIcon(UIManager.getIcon("FileView.directoryIcon"));
        this.keyFileChooser.setToolTipText(resources.getString("selectKeyFile.toolTip"));
        this.keyFileChooser.setName("keyFileChooser");
        this.keyFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationPanel.this.keyFileChooserActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.keyFilePanel.add((Component)this.keyFileChooser, gridBagConstraints);
        this.tabs.addTab(resources.getString("tab.keyFile"), this.keyFilePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tabs, gridBagConstraints);
    }

    private void keyFileChooserActionPerformed(ActionEvent evt) {
        JFileChooser fc = AuthenticationPanel.newFileChooser();
        if (0 == fc.showOpenDialog(this)) {
            this.setKeyFile(fc.getSelectedFile());
        }
    }

    private static JFileChooser newFileChooser() {
        JFileChooser fc = new JFileChooser(BASE_DIR);
        fc.setDialogTitle(resources.getString("fileChooser.title"));
        fc.setFileHidingEnabled(false);
        return fc;
    }

    private void keyFilePanelAncestorWindowShown(PanelEvent evt) {
        final Window window = evt.getSource().getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AuthenticationPanel.this.keyFile.requestFocusInWindow()) {
                            ((JTextComponent)AuthenticationPanel.this.keyFile.getEditor().getEditorComponent()).selectAll();
                        }
                    }
                });
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
    }
}

