/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;

public class ISO8601DateFormat {
    private static final ThreadLocal<Map<String, TimeZone>> timezones = new ThreadLocal();

    public static String format(Date isoDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(isoDate);
        StringBuilder formatted = new StringBuilder(28);
        ISO8601DateFormat.padInt(formatted, calendar.get(1), 4);
        formatted.append('-');
        ISO8601DateFormat.padInt(formatted, calendar.get(2) + 1, 2);
        formatted.append('-');
        ISO8601DateFormat.padInt(formatted, calendar.get(5), 2);
        formatted.append('T');
        ISO8601DateFormat.padInt(formatted, calendar.get(11), 2);
        formatted.append(':');
        ISO8601DateFormat.padInt(formatted, calendar.get(12), 2);
        formatted.append(':');
        ISO8601DateFormat.padInt(formatted, calendar.get(13), 2);
        formatted.append('.');
        ISO8601DateFormat.padInt(formatted, calendar.get(14), 3);
        TimeZone tz = ((Calendar)calendar).getTimeZone();
        int offset = tz.getOffset(calendar.getTimeInMillis());
        if (offset != 0) {
            int hours = Math.abs(offset / 60000 / 60);
            int minutes = Math.abs(offset / 60000 % 60);
            formatted.append(offset < 0 ? (char)'-' : '+');
            ISO8601DateFormat.padInt(formatted, hours, 2);
            formatted.append(':');
            ISO8601DateFormat.padInt(formatted, minutes, 2);
        } else {
            formatted.append('Z');
        }
        return formatted.toString();
    }

    public static Date parse(String isoDate) {
        Date parsed = null;
        try {
            TimeZone timezone;
            Object timezoneId;
            char timezoneIndicator;
            int offset = 0;
            int year = Integer.parseInt(isoDate.substring(offset, offset += 4));
            if (isoDate.charAt(offset) != '-') {
                throw new IndexOutOfBoundsException("Expected - character but found " + isoDate.charAt(offset));
            }
            int month = Integer.parseInt(isoDate.substring(++offset, offset += 2));
            if (isoDate.charAt(offset) != '-') {
                throw new IndexOutOfBoundsException("Expected - character but found " + isoDate.charAt(offset));
            }
            int day = Integer.parseInt(isoDate.substring(++offset, offset += 2));
            if (isoDate.charAt(offset) != 'T') {
                throw new IndexOutOfBoundsException("Expected T character but found " + isoDate.charAt(offset));
            }
            int hour = Integer.parseInt(isoDate.substring(++offset, offset += 2));
            if (isoDate.charAt(offset) != ':') {
                throw new IndexOutOfBoundsException("Expected : character but found " + isoDate.charAt(offset));
            }
            int minutes = Integer.parseInt(isoDate.substring(++offset, offset += 2));
            if (isoDate.charAt(offset) != ':') {
                throw new IndexOutOfBoundsException("Expected : character but found " + isoDate.charAt(offset));
            }
            int seconds = Integer.parseInt(isoDate.substring(++offset, offset += 2));
            int milliseconds = 0;
            if (isoDate.charAt(offset) == '.') {
                milliseconds = Integer.parseInt(isoDate.substring(++offset, offset += 3));
            }
            if ((timezoneIndicator = isoDate.charAt(offset)) == '+' || timezoneIndicator == '-') {
                timezoneId = "GMT" + isoDate.substring(offset);
            } else if (timezoneIndicator == 'Z') {
                timezoneId = "GMT";
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator " + timezoneIndicator);
            }
            Map<String, TimeZone> timezoneMap = timezones.get();
            if (timezoneMap == null) {
                timezoneMap = new HashMap<String, TimeZone>(4);
                timezones.set(timezoneMap);
            }
            if ((timezone = timezoneMap.get(timezoneId)) == null) {
                timezone = TimeZone.getTimeZone((String)timezoneId);
                timezoneMap.put((String)timezoneId, timezone);
            }
            if (!timezone.getID().equals(timezoneId)) {
                throw new IndexOutOfBoundsException();
            }
            if (!timezone.getID().equals(timezoneId)) {
                throw new IndexOutOfBoundsException();
            }
            GregorianCalendar calendar = new GregorianCalendar(timezone);
            calendar.setLenient(false);
            calendar.set(1, year);
            calendar.set(2, month - 1);
            calendar.set(5, day);
            calendar.set(11, hour);
            calendar.set(12, minutes);
            calendar.set(13, seconds);
            calendar.set(14, milliseconds);
            parsed = calendar.getTime();
        }
        catch (IndexOutOfBoundsException e) {
            throw new PlatformRuntimeException("Failed to parse date " + isoDate, e);
        }
        catch (NumberFormatException e) {
            throw new PlatformRuntimeException("Failed to parse date " + isoDate, e);
        }
        catch (IllegalArgumentException e) {
            throw new PlatformRuntimeException("Failed to parse date " + isoDate, e);
        }
        return parsed;
    }

    private static void padInt(StringBuilder buffer, int value, int length) {
        String strValue = Integer.toString(value);
        for (int i = length - strValue.length(); i > 0; --i) {
            buffer.append('0');
        }
        buffer.append(strValue);
    }
}

