/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.file;

import de.schlichtherle.truezip.fs.file.FileEntry;
import de.schlichtherle.truezip.socket.IOPool;
import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TempFilePool
implements IOPool<FileEntry> {
    static final TempFilePool INSTANCE = new TempFilePool(null, null);
    @Nullable
    private final File dir;
    private final String prefix;

    TempFilePool(@CheckForNull File dir, @CheckForNull String prefix) {
        this.dir = dir;
        this.prefix = null != prefix ? TempFilePool.prefixPlusDot(prefix) : "tzp";
    }

    private static String prefixPlusDot(String prefix) {
        return prefix.endsWith(".") ? prefix : prefix + ".";
    }

    @Override
    public Buffer allocate() throws IOException {
        return new Buffer(this.createTempFile(), this);
    }

    private File createTempFile() throws IOException {
        try {
            return File.createTempFile(this.prefix, null, this.dir);
        }
        catch (IOException ex) {
            if (this.dir.exists()) {
                throw ex;
            }
            this.createTempDir();
            return this.createTempFile();
        }
    }

    private void createTempDir() {
        assert (!this.dir.exists());
        if (!this.dir.mkdirs() && !this.dir.exists()) {
            throw new IllegalArgumentException(this.dir + " (cannot create directory for temporary files)");
        }
        assert (this.dir.exists());
    }

    @Override
    public void release(IOPool.Entry<FileEntry> resource) throws IOException {
        resource.release();
    }

    @NotThreadSafe
    private static final class Buffer
    extends FileEntry
    implements IOPool.Entry<FileEntry> {
        Buffer(File file, TempFilePool pool) {
            super(file);
            assert (null != file);
            assert (null != pool);
            this.pool = pool;
        }

        @Override
        public void release() throws IOException {
            this.pool(null);
        }

        private void pool(@CheckForNull TempFilePool newPool) throws IOException {
            File file;
            TempFilePool oldPool = this.pool;
            this.pool = newPool;
            if (oldPool != newPool && !(file = this.getFile()).delete() && file.exists()) {
                throw new IOException(file + " (cannot delete temporary file)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.pool(null);
            }
            finally {
                super.finalize();
            }
        }
    }
}

