/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class IOSocket<LT, PT> {
    IOSocket() {
    }

    public abstract LT getLocalTarget() throws IOException;

    @CheckForNull
    public abstract PT getPeerTarget() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputSocket<?> input, OutputSocket<?> output) throws IOException {
        InputStream in;
        if (null == output) {
            throw new NullPointerException();
        }
        OutputStream out = null;
        try {
            in = input.connect(output).newInputStream();
        }
        catch (IOException ex) {
            throw new InputException(ex);
        }
        try {
            out = output.newOutputStream();
        }
        finally {
            if (null == out) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    throw new InputException(ex);
                }
            }
        }
        Streams.copy(in, out);
        input.connect(null);
    }

    public String toString() {
        Object pt;
        Object lt;
        try {
            lt = this.getLocalTarget();
        }
        catch (IOException ex) {
            lt = ex;
        }
        try {
            pt = this.getPeerTarget();
        }
        catch (IOException ex) {
            pt = ex;
        }
        return String.format("%s[localTarget=%s, peerTarget=%s]", this.getClass().getName(), lt, pt);
    }

    public final boolean equals(@CheckForNull Object that) {
        return this == that;
    }

    public final int hashCode() {
        return super.hashCode();
    }
}

