/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.registry.RegistryService;
import org.alfresco.repo.module.ModuleComponent;
import org.alfresco.repo.module.ModuleComponentHelper;
import org.alfresco.repo.module.ModuleDetailsImpl;
import org.alfresco.repo.module.ModuleVersionNumber;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.descriptor.DescriptorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ModuleServiceImpl
implements ApplicationContextAware,
ModuleService {
    private static final String ERR_UNABLE_TO_OPEN_MODULE_PROPETIES = "module.err.unable_to_open_module_properties";
    private static final String MODULE_CONFIG_SEARCH_ALL = "classpath*:alfresco/module/*/module.properties";
    private static Log logger = LogFactory.getLog(ModuleServiceImpl.class);
    private ServiceRegistry serviceRegistry;
    private ModuleComponentHelper moduleComponentHelper;
    private Map<String, ModuleDetails> moduleDetailsById;
    ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public ModuleServiceImpl() {
        this.moduleComponentHelper = new ModuleComponentHelper();
        this.moduleComponentHelper.setModuleService(this);
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.moduleComponentHelper.setServiceRegistry(this.serviceRegistry);
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.moduleComponentHelper.setDescriptorService(descriptorService);
    }

    public void setRegistryService(RegistryService registryService) {
        this.moduleComponentHelper.setRegistryService(registryService);
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.moduleComponentHelper.setTenantAdminService(tenantAdminService);
    }

    public void setApplyToTenants(boolean applyToTenants) {
        throw new UnsupportedOperationException("Applying modules to individual tenants is unsupported. See ALF-19207: MT module startup does not work");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.resolver = applicationContext;
    }

    @Override
    public void registerComponent(ModuleComponent component) {
        this.moduleComponentHelper.registerComponent(component);
    }

    @Override
    public void startModules() {
        this.moduleComponentHelper.startModules();
    }

    @Override
    public void shutdownModules() {
        this.moduleComponentHelper.shutdownModules();
    }

    @Override
    public ModuleDetails getModule(String moduleId) {
        this.cacheModuleDetails();
        ModuleDetails details = this.moduleDetailsById.get(moduleId);
        return details;
    }

    @Override
    public List<ModuleDetails> getAllModules() {
        this.cacheModuleDetails();
        Collection<ModuleDetails> moduleDetails = this.moduleDetailsById.values();
        ArrayList<ModuleDetails> result = new ArrayList<ModuleDetails>(moduleDetails);
        return result;
    }

    @Override
    public List<ModuleDetails> getMissingModules() {
        this.cacheModuleDetails();
        Collection<String> moduleIds = this.moduleComponentHelper.getRegistryModuleIDs();
        ArrayList<ModuleDetails> result = new ArrayList<ModuleDetails>();
        for (String moduleId : moduleIds) {
            ModuleDetails moduleDetails = this.getModule(moduleId);
            if (moduleDetails != null) continue;
            ModuleVersionNumber currentVersion = this.moduleComponentHelper.getVersion(moduleId);
            ModuleDetailsImpl newModuleDetails = new ModuleDetailsImpl(moduleId, currentVersion, "", "");
            result.add(newModuleDetails);
        }
        return result;
    }

    private synchronized void cacheModuleDetails() {
        if (this.moduleDetailsById != null) {
            return;
        }
        try {
            Resource[] resources;
            this.moduleDetailsById = new HashMap<String, ModuleDetails>(13);
            Resource[] resourceArray = resources = this.resolver.getResources(MODULE_CONFIG_SEARCH_ALL);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                try {
                    BufferedInputStream is = new BufferedInputStream(resource.getInputStream());
                    Properties properties = new Properties();
                    properties.load(is);
                    ModuleDetailsImpl details = new ModuleDetailsImpl(properties);
                    this.moduleDetailsById.put(details.getId(), details);
                }
                catch (Throwable e) {
                    logger.error((Object)"Unable to use module information.", e);
                    throw AlfrescoRuntimeException.create(e, ERR_UNABLE_TO_OPEN_MODULE_PROPETIES, resource);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to retrieve module information", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + this.moduleDetailsById.size() + " modules: \n" + "   Modules: " + this.moduleDetailsById));
        }
    }
}

