/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.prediction_applier.config;

import jakarta.validation.constraints.Positive;
import org.alfresco.hxi_connector.common.config.properties.Retry;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="alfresco.repository")
public record RepositoryApiProperties(String baseUrl, String discoveryEndpoint, Retry retry, HealthProbe healthProbe) {
    public RepositoryApiProperties {
        if (StringUtils.isNotBlank((CharSequence)discoveryEndpoint) && StringUtils.isBlank((CharSequence)healthProbe.endpoint())) {
            throw new IllegalStateException("Property %s must be set in the Prediction Applier configuration when property %s is set.".formatted("alfresco.repository.health-probe.endpoint", "alfresco.repository.discovery-endpoint"));
        }
    }

    @Validated
    public record HealthProbe(String endpoint, @Positive int timeoutSeconds, @Positive int intervalSeconds) {
    }
}

