/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.prediction_applier.hx_insight;

import java.util.Objects;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AuthService;
import org.alfresco.hxi_connector.common.adapters.messaging.repository.ApplicationInfoProvider;
import org.alfresco.hxi_connector.prediction_applier.config.InsightPredictionsProperties;
import org.alfresco.hxi_connector.prediction_applier.hx_insight.HxInsightUrlProducer;
import org.alfresco.hxi_connector.prediction_applier.model.prediction.PredictionBatch;
import org.alfresco.hxi_connector.prediction_applier.model.prediction.PredictionEntry;
import org.alfresco.hxi_connector.prediction_applier.util.LinkedListJacksonDataFormat;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.language.spel.SpelExpression;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PredictionCollector
extends RouteBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PredictionCollector.class);
    private static final String TIMER_ROUTE_ID = "predictions-collector-timer";
    private static final String COLLECTOR_ROUTE_ID = "prediction-collector";
    private static final String BATCH_PROCESSOR_ROUTE_ID = "prediction-batch-processor";
    private static final String BATCHES_PROCESSOR_ENDPOINT = "direct:prediction-collector-" + PredictionCollector.class.getSimpleName();
    private static final String PREDICTIONS_PROCESSOR_ENDPOINT = "direct:prediction-batch-processor-" + PredictionCollector.class.getSimpleName();
    private static final String IS_PREDICTION_PROCESSING_PENDING_KEY = "is-prediction-processing-pending";
    private static final String SET_BATCH_STATUS_BODY_TEMPLATE = "{\"status\": \"%s\", \"currentPage\": ${headers.%s}}";
    private static final String IN_PROGRESS_BATCH_STATUS_BODY = "{\"status\": \"%s\", \"currentPage\": ${headers.%s}}".formatted("IN_PROGRESS", "predictionsPageNo");
    private static final String COMPLETE_BATCH_STATUS_BODY = "{\"status\": \"%s\", \"currentPage\": ${headers.%s}}".formatted("COMPLETE", "predictionsPageNo");
    private final InsightPredictionsProperties insightPredictionsProperties;
    private final HxInsightUrlProducer hxInsightUrlProducer;
    private final AuthService authService;
    private final ApplicationInfoProvider applicationInfoProvider;

    public void configure() {
        ((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from(this.insightPredictionsProperties.collectorTimerEndpoint()).routeId(TIMER_ROUTE_ID).setProperty("user-agent-data", () -> ((ApplicationInfoProvider)this.applicationInfoProvider).getUserAgentData())).choice().when(this::isProcessingPending).log(LoggingLevel.DEBUG, log, "Prediction processing is pending, no need to trigger it")).otherwise().log(LoggingLevel.DEBUG, log, "Triggering prediction processing")).to(BATCHES_PROCESSOR_ENDPOINT);
        String batchesUrl = this.hxInsightUrlProducer.getBatchesUrl();
        LinkedListJacksonDataFormat predictionsBatchDataFormat = new LinkedListJacksonDataFormat(PredictionBatch.class);
        ((ExpressionNode)((ChoiceDefinition)((ChoiceDefinition)((ExpressionNode)((ExpressionNode)((OnCompletionDefinition)((RouteDefinition)this.from(BATCHES_PROCESSOR_ENDPOINT).routeId(COLLECTOR_ROUTE_ID).process(this.setProcessingPending(true))).onCompletion().process(this.setProcessingPending(false))).end().setHeader("batchesPageNo", (Expression)this.constant(1)).loopDoWhile((Predicate)this.statusCodeNot204()).process(arg_0 -> ((AuthService)this.authService).setHxIAuthorizationHeaders(arg_0))).toD(batchesUrl)).choice().when((Predicate)this.statusCodeNot204()).log(LoggingLevel.DEBUG, log, "Processing prediction batches page ${headers.%s} started".formatted("batchesPageNo"))).unmarshal((DataFormat)predictionsBatchDataFormat)).split((Expression)this.body()).to(PREDICTIONS_PROCESSOR_ENDPOINT)).end().setHeader("batchesPageNo", (Expression)SpelExpression.spel((String)"#{request.headers['%s'] + 1}".formatted("batchesPageNo"))).toD(batchesUrl).end().end().log(LoggingLevel.DEBUG, log, "Finished processing predictions");
        String predictionsUrl = this.hxInsightUrlProducer.getPredictionsUrl();
        String predictionsConfirmationUrl = this.hxInsightUrlProducer.getConfirmationUrl();
        LinkedListJacksonDataFormat predictionsDataFormat = new LinkedListJacksonDataFormat(PredictionEntry.class);
        JacksonDataFormat predictionDataFormat = new JacksonDataFormat(PredictionEntry.class);
        ((ProcessorDefinition)((ExpressionNode)((ExpressionNode)((ChoiceDefinition)((ChoiceDefinition)((ExpressionNode)((ExpressionNode)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(PREDICTIONS_PROCESSOR_ENDPOINT).routeId(BATCH_PROCESSOR_ROUTE_ID).log(LoggingLevel.DEBUG, log, "Processing prediction batch ${body.id} started")).setHeader("batchId", (Expression)this.simple("${body.id}"))).setHeader("predictionsPageNo", (Expression)this.constant(1))).loopDoWhile((Predicate)this.statusCodeNot204()).process(arg_0 -> ((AuthService)this.authService).setHxIAuthorizationHeaders(arg_0))).toD(predictionsUrl)).choice().when((Predicate)this.statusCodeNot204()).log(LoggingLevel.TRACE, log, "Processing page ${headers.%s} of predictions in batch ${headers.%s}, ${body}, ${header.CamelHttpResponseCode}".formatted("predictionsPageNo", "batchId"))).unmarshal((DataFormat)predictionsDataFormat)).split((Expression)this.body()).marshal((DataFormat)predictionDataFormat)).to(this.insightPredictionsProperties.bufferEndpoint())).end().setBody((Expression)this.simple(IN_PROGRESS_BATCH_STATUS_BODY)).toD(predictionsConfirmationUrl).log(LoggingLevel.TRACE, log, "Processing prediction batch ${headers.%s} page ${headers.%s} completed".formatted("batchId", "predictionsPageNo")).setHeader("predictionsPageNo").spel("#{request.headers['%s'] + 1}".formatted("predictionsPageNo"))).end().end().setBody((Expression)this.simple(COMPLETE_BATCH_STATUS_BODY)).toD(predictionsConfirmationUrl).log(LoggingLevel.DEBUG, log, "Processing prediction batch ${headers.%s} finished".formatted("batchId"));
    }

    private ValueBuilder statusCodeNot204() {
        return this.simple("${header.CamelHttpResponseCode} != 204");
    }

    private boolean isProcessingPending(Exchange exchange) {
        return Objects.requireNonNullElse((Boolean)this.getContext().getRegistry().lookupByNameAndType(IS_PREDICTION_PROCESSING_PENDING_KEY, Boolean.class), false);
    }

    private Processor setProcessingPending(boolean isProcessingPending) {
        return exchange -> this.getContext().getRegistry().bind(IS_PREDICTION_PROCESSING_PENDING_KEY, (Object)isProcessingPending);
    }

    @Generated
    public PredictionCollector(InsightPredictionsProperties insightPredictionsProperties, HxInsightUrlProducer hxInsightUrlProducer, AuthService authService, ApplicationInfoProvider applicationInfoProvider) {
        this.insightPredictionsProperties = insightPredictionsProperties;
        this.hxInsightUrlProducer = hxInsightUrlProducer;
        this.authService = authService;
        this.applicationInfoProvider = applicationInfoProvider;
    }
}

