/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.property;

import java.util.Optional;
import lombok.Generated;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.NodeProperty;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.UpdateNodeEvent;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.property.PropertyResolver;

public class PropertyUpdated<T>
extends PropertyDelta<T> {
    private final T propertyValue;

    public PropertyUpdated(String propertyName, T propertyValue) {
        super(propertyName);
        EnsureUtils.ensureNonNull(propertyValue, (String)"Property value cannot be null. Property name: %s", (Object[])new Object[]{propertyName});
        this.propertyValue = propertyValue;
    }

    @Override
    public void applyOn(UpdateNodeEvent event) {
        event.addMetadataInstruction(new NodeProperty<T>(this.getPropertyName(), this.propertyValue));
    }

    @Override
    public <R> Optional<PropertyDelta<R>> resolveWith(PropertyResolver<R> resolver) {
        return resolver.resolveUpdated(this);
    }

    @Generated
    public T getPropertyValue() {
        return this.propertyValue;
    }

    @Override
    @Generated
    public String toString() {
        return "PropertyUpdated(super=" + super.toString() + ", propertyValue=" + String.valueOf(this.getPropertyValue()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyUpdated)) {
            return false;
        }
        PropertyUpdated other = (PropertyUpdated)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        T this$propertyValue = this.getPropertyValue();
        T other$propertyValue = other.getPropertyValue();
        return !(this$propertyValue == null ? other$propertyValue != null : !this$propertyValue.equals(other$propertyValue));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertyUpdated;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        T $propertyValue = this.getPropertyValue();
        result = result * 59 + ($propertyValue == null ? 43 : $propertyValue.hashCode());
        return result;
    }
}

