/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository;

import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.adapters.config.IntegrationProperties;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.filter.RepoEventFilterHandler;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper.RepoEventMapper;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util.EventUtils;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.IngestContentCommandHandler;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.TriggerContentIngestionCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.delete.DeleteNodeCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.delete.DeleteNodeCommandHandler;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.IngestNodeCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.IngestNodeCommandHandler;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.EventType;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EventProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventProcessor.class);
    private final IngestNodeCommandHandler ingestNodeCommandHandler;
    private final IngestContentCommandHandler ingestContentCommandHandler;
    private final DeleteNodeCommandHandler deleteNodeCommandHandler;
    private final RepoEventMapper repoEventMapper;
    private final RepoEventFilterHandler repoEventFilterHandler;
    private final IntegrationProperties integrationProperties;

    public void process(Exchange exchange) {
        boolean allowEvent = this.repoEventFilterHandler.handleAndGetAllowed(exchange, this.integrationProperties.alfresco().filter());
        RepoEvent event = (RepoEvent)exchange.getIn().getBody(RepoEvent.class);
        if (!allowEvent) {
            log.atDebug().log("Repository event of id: {} is denied for further processing", (Object)event.getId());
            return;
        }
        if (EventUtils.isPredictionApplyEvent((RepoEvent<DataAttributes<NodeResource>>)event)) {
            log.atDebug().log("Detected prediction apply event. Further processing of event with id: {} was skipped.", (Object)event.getId());
            return;
        }
        if (EventUtils.isPredictionNodeEvent((RepoEvent<DataAttributes<NodeResource>>)event)) {
            this.handlePredictionNodeEvent((RepoEvent<DataAttributes<NodeResource>>)event);
            return;
        }
        this.handleMetadataPropertiesChange((RepoEvent<DataAttributes<NodeResource>>)event);
        this.handleContentChange((RepoEvent<DataAttributes<NodeResource>>)event);
        this.handleNodeDeleteEvent((RepoEvent<DataAttributes<NodeResource>>)event);
    }

    private void handlePredictionNodeEvent(RepoEvent<DataAttributes<NodeResource>> event) {
        if (EventUtils.wasPredictionConfirmed(event)) {
            IngestNodeCommand command = new IngestNodeCommand(EventUtils.getNodeParent(event), EventType.CREATE_OR_UPDATE, EventUtils.getPredictionNodeProperties(event), EventUtils.getEventTimestamp(event));
            this.ingestNodeCommandHandler.handle(command);
        }
    }

    private void handleMetadataPropertiesChange(RepoEvent<DataAttributes<NodeResource>> event) {
        if (EventUtils.isEventTypeCreated(event) || EventUtils.isEventTypeUpdated(event) || EventUtils.isEventTypePermissionsUpdated(event)) {
            IngestNodeCommand ingestNodeCommand = this.repoEventMapper.mapToIngestNodeCommand(event);
            this.ingestNodeCommandHandler.handle(ingestNodeCommand);
        }
    }

    private void handleContentChange(RepoEvent<DataAttributes<NodeResource>> event) {
        if (EventUtils.wasContentChanged(event)) {
            TriggerContentIngestionCommand command = this.repoEventMapper.mapToIngestContentCommand(event);
            if ("".equals(command.mimeType())) {
                NodeResource resource = (NodeResource)event.getData().getResource();
                String sourceMimeType = resource.getContent().getMimeType();
                log.atDebug().log("Content will not be ingested - cannot determine target MIME type for node of id {} with source MIME type {}.", (Object)resource.getId(), (Object)sourceMimeType);
                return;
            }
            this.ingestContentCommandHandler.handle(command);
        }
    }

    private void handleNodeDeleteEvent(RepoEvent<DataAttributes<NodeResource>> event) {
        if (EventUtils.isEventTypeDeleted(event)) {
            DeleteNodeCommand deleteNodeCommand = this.repoEventMapper.mapToDeleteNodeCommand(event);
            this.deleteNodeCommandHandler.handle(deleteNodeCommand);
        }
    }

    @Generated
    public EventProcessor(IngestNodeCommandHandler ingestNodeCommandHandler, IngestContentCommandHandler ingestContentCommandHandler, DeleteNodeCommandHandler deleteNodeCommandHandler, RepoEventMapper repoEventMapper, RepoEventFilterHandler repoEventFilterHandler, IntegrationProperties integrationProperties) {
        this.ingestNodeCommandHandler = ingestNodeCommandHandler;
        this.ingestContentCommandHandler = ingestContentCommandHandler;
        this.deleteNodeCommandHandler = deleteNodeCommandHandler;
        this.repoEventMapper = repoEventMapper;
        this.repoEventFilterHandler = repoEventFilterHandler;
        this.integrationProperties = integrationProperties;
    }
}

