/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.config.properties;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import java.util.Map;
import java.util.Objects;
import org.alfresco.hxi_connector.common.config.properties.Retry;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.bind.ConstructorBinding;

public record Transform(@NotNull Request request, @NotNull Response response, @NotNull SharedFileStore sharedFileStore, MimeType mimeType) {
    @ConstructorBinding
    public Transform(@NotNull Request request, @NotNull Response response, @NotNull SharedFileStore sharedFileStore, MimeType mimeType) {
        this.request = request;
        this.response = response;
        this.sharedFileStore = sharedFileStore;
        this.mimeType = mimeType != null ? mimeType : new MimeType(null);
    }

    public record Request(@NotBlank String endpoint, @Positive int timeout, @NotNull Map<String, Map<String, String>> options) {
    }

    public record Response(@NotBlank String endpoint, @NotBlank String queueName, @NotNull @NestedConfigurationProperty Retry retryIngestion, @NotNull @NestedConfigurationProperty Retry retryTransformation) {
        public Response(@NotBlank String endpoint, @NotBlank String queueName, @NotNull Retry retryIngestion, @NotNull Retry retryTransformation) {
            retryIngestion = Objects.requireNonNullElseGet(retryTransformation, Retry::new);
            retryTransformation = Objects.requireNonNullElseGet(retryTransformation, Retry::new);
        }
    }

    public record SharedFileStore(@NotBlank String fileEndpoint, @NotNull @NestedConfigurationProperty Retry retry) {
        public SharedFileStore(@NotBlank String fileEndpoint, @NotNull Retry retry) {
            retry = Objects.requireNonNullElseGet(retry, Retry::new);
        }
    }

    public record MimeType(Map<String, String> mapping) {
    }
}

