/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.property;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.property.PropertyUpdated;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.property.PropertyResolver;
import org.springframework.stereotype.Component;

@Component
public class CategoryPropertyResolver
implements PropertyResolver<Set<String>> {
    private static final String CATEGORIES_PROPERTY_NAME = "cm:categories";
    private static final String TAGS_PROPERTY_NAME = "cm:taggable";

    public boolean canResolve(PropertyDelta<?> propertyDelta) {
        String propertyName = propertyDelta.getPropertyName();
        return propertyName.equals(CATEGORIES_PROPERTY_NAME) || propertyName.equals(TAGS_PROPERTY_NAME);
    }

    public Optional<PropertyDelta<Set<String>>> resolveUpdated(PropertyUpdated<?> updatedProperty) {
        EnsureUtils.ensureThat((boolean)this.canResolve(updatedProperty), (String)"Unsupported property: %s", (Object[])new Object[]{updatedProperty});
        Object propertyValue = updatedProperty.getPropertyValue();
        if (propertyValue instanceof String) {
            return Optional.of(PropertyDelta.updated((String)updatedProperty.getPropertyName(), Set.of((String)propertyValue)));
        }
        Set ids = ((List)propertyValue).stream().map(arg_0 -> this.getId(arg_0)).collect(Collectors.toSet());
        return Optional.of(PropertyDelta.updated((String)updatedProperty.getPropertyName(), ids));
    }

    private String getId(Map<String, Object> entry) {
        return (String)entry.get("id");
    }
}

