/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.live_ingester.adapters.config.IntegrationProperties;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.IngestionEngineEventPublisher;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.NodeEvent;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.UpdateNodeEvent;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.IngestNodeCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.EventType;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.property.PropertyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IngestNodeCommandHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IngestNodeCommandHandler.class);
    private final IngestionEngineEventPublisher ingestionEngineEventPublisher;
    private final List<PropertyResolver<?>> propertyResolvers;
    private final IntegrationProperties integrationProperties;

    public void handle(IngestNodeCommand command) {
        EventType eventType = command.eventType();
        EnsureUtils.ensureThat((eventType != EventType.DELETE ? 1 : 0) != 0, (String)"Cannot ingest metadata for DELETE event - nodeId %s", (Object[])new Object[]{command.nodeId()});
        UpdateNodeEvent updateNodeEvent = new UpdateNodeEvent(command.nodeId(), eventType, this.integrationProperties.application().getSourceId(), command.sourceTimestamp());
        command.properties().stream().map(arg_0 -> this.resolve(arg_0)).flatMap(Optional::stream).forEach(propertyDelta -> propertyDelta.applyOn(updateNodeEvent));
        if (updateNodeEvent.getEventType() == EventType.CREATE_OR_UPDATE && updateNodeEvent.getContentPropertiesToSet().isEmpty() && updateNodeEvent.getMetadataPropertiesToSet().isEmpty()) {
            log.debug("Ignoring empty metadata update: {}", (Object)updateNodeEvent);
            return;
        }
        this.ingestionEngineEventPublisher.publishMessage((NodeEvent)updateNodeEvent);
    }

    private Optional<PropertyDelta<?>> resolve(PropertyDelta<?> propertyDelta) {
        Optional<Object> resolvedPropertyDelta = Optional.of(propertyDelta);
        for (PropertyResolver propertyResolver : this.propertyResolvers) {
            resolvedPropertyDelta = resolvedPropertyDelta.flatMap(delta -> delta.canBeResolvedWith(propertyResolver) ? delta.resolveWith(propertyResolver) : Optional.of(delta));
        }
        return resolvedPropertyDelta;
    }

    @Generated
    public IngestNodeCommandHandler(IngestionEngineEventPublisher ingestionEngineEventPublisher, List<PropertyResolver<?>> propertyResolvers, IntegrationProperties integrationProperties) {
        this.ingestionEngineEventPublisher = ingestionEngineEventPublisher;
        this.propertyResolvers = propertyResolvers;
        this.integrationProperties = integrationProperties;
    }
}

