/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.config.properties;

import jakarta.validation.constraints.NotBlank;
import org.alfresco.hxi_connector.live_ingester.adapters.config.properties.Repository;
import org.apache.commons.lang3.StringUtils;

public record Repository(@NotBlank String eventsEndpoint, String discoveryEndpoint, String versionOverride, HealthProbe healthProbe) {
    @NotBlank
    private final String eventsEndpoint;
    private final String discoveryEndpoint;
    private final String versionOverride;
    private final HealthProbe healthProbe;

    public Repository(@NotBlank String eventsEndpoint, String discoveryEndpoint, String versionOverride, HealthProbe healthProbe) {
        if (StringUtils.isBlank((CharSequence)discoveryEndpoint) && StringUtils.isBlank((CharSequence)versionOverride)) {
            throw new IllegalStateException("Either property %s or %s must be set in the Live Ingester configuration.".formatted("alfresco.repository.discovery-endpoint", "alfresco.repository.version-override"));
        }
        if (StringUtils.isNotBlank((CharSequence)discoveryEndpoint) && StringUtils.isBlank((CharSequence)versionOverride) && StringUtils.isBlank((CharSequence)healthProbe.endpoint())) {
            throw new IllegalStateException("Property %s must be set in the Live Ingester configuration when property %s is set and % property is blank.".formatted("alfresco.repository.health-probe.endpoint", "alfresco.repository.discovery-endpoint", "alfresco.repository.version-override"));
        }
        this.eventsEndpoint = eventsEndpoint;
        this.discoveryEndpoint = discoveryEndpoint;
        this.versionOverride = versionOverride;
        this.healthProbe = healthProbe;
    }

    @NotBlank
    public String eventsEndpoint() {
        return this.eventsEndpoint;
    }

    public String discoveryEndpoint() {
        return this.discoveryEndpoint;
    }

    public String versionOverride() {
        return this.versionOverride;
    }

    public HealthProbe healthProbe() {
        return this.healthProbe;
    }
}

