/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.bulk_ingester;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.alfresco.hxi_connector.common.model.ingest.IngestEvent;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper.MimeTypeMapper;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.mapper.property.PropertyMappingHelper;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util.AuthorityInfo;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util.AuthorityTypeResolver;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.IngestContentCommandHandler;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.content.TriggerContentIngestionCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.IngestNodeCommand;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.IngestNodeCommandHandler;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.EventType;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.property.ContentPropertyUpdated;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.property.PermissionsMetadataUpdated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
public class IngestEventProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IngestEventProcessor.class);
    private final IngestNodeCommandHandler ingestNodeCommandHandler;
    private final IngestContentCommandHandler ingestContentCommandHandler;
    private final MimeTypeMapper mimeTypeMapper;
    private final AuthorityTypeResolver authorityTypeResolver;

    public void process(@Validated IngestEvent ingestEvent) {
        Map<String, Serializable> properties = ingestEvent.properties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        IngestNodeCommand ingestNodeCommand = new IngestNodeCommand(ingestEvent.nodeId(), EventType.CREATE_OR_UPDATE, this.mapToPropertiesDelta(ingestEvent.contentInfo(), properties), ingestEvent.timestamp());
        this.ingestNodeCommandHandler.handle(ingestNodeCommand);
        if (ingestEvent.contentInfo() != null) {
            String sourceMimeType = ingestEvent.contentInfo().mimetype();
            String targetMimeType = this.mimeTypeMapper.mapMimeType(sourceMimeType);
            if ("".equals(targetMimeType)) {
                log.atDebug().log("Content will not be ingested - cannot determine target MIME type for node of id {} with source MIME type {}", (Object)ingestEvent.nodeId(), (Object)sourceMimeType);
                return;
            }
            TriggerContentIngestionCommand triggerContentIngestionCommand = new TriggerContentIngestionCommand(ingestEvent.nodeId(), targetMimeType, ingestEvent.timestamp());
            this.ingestContentCommandHandler.handle(triggerContentIngestionCommand);
        }
    }

    private Set<PropertyDelta<?>> mapToPropertiesDelta(IngestEvent.ContentInfo contentInfo, Map<String, Serializable> properties) {
        Stream<PropertyDelta> metadataDelta = properties.entrySet().stream().map(property -> PropertyDelta.updated((String)property.getKey(), (Serializable)property.getValue()));
        if (!(contentInfo == null || contentInfo.mimetype() == null && Objects.equals(contentInfo.contentSize(), 0L))) {
            ContentPropertyUpdated contentDelta = PropertyDelta.contentMetadataUpdated("cm:content", contentInfo.mimetype(), contentInfo.contentSize(), (String)((Object)properties.get("cm:name")));
            metadataDelta = Stream.concat(metadataDelta, Stream.of(contentDelta));
        }
        List<String> allowAccess = (List<String>)((Object)properties.get("ALLOW_ACCESS"));
        List<String> denyAccess = (List<String>)((Object)properties.get("DENY_ACCESS"));
        if (allowAccess != null || denyAccess != null) {
            List<AuthorityInfo> allowAccessWithTypes = PropertyMappingHelper.convertToAuthorityInfoList(allowAccess != null ? allowAccess : Collections.emptyList(), this.authorityTypeResolver);
            List<AuthorityInfo> denyAccessWithTypes = PropertyMappingHelper.convertToAuthorityInfoList(denyAccess != null ? denyAccess : Collections.emptyList(), this.authorityTypeResolver);
            PermissionsMetadataUpdated permissionsDelta = PropertyDelta.permissionsMetadataUpdated("PERMISSIONS", allowAccessWithTypes, denyAccessWithTypes);
            metadataDelta = Stream.concat(metadataDelta, Stream.of(permissionsDelta));
        }
        return metadataDelta.collect(Collectors.toSet());
    }

    @Generated
    public IngestEventProcessor(IngestNodeCommandHandler ingestNodeCommandHandler, IngestContentCommandHandler ingestContentCommandHandler, MimeTypeMapper mimeTypeMapper, AuthorityTypeResolver authorityTypeResolver) {
        this.ingestNodeCommandHandler = ingestNodeCommandHandler;
        this.ingestContentCommandHandler = ingestContentCommandHandler;
        this.mimeTypeMapper = mimeTypeMapper;
        this.authorityTypeResolver = authorityTypeResolver;
    }
}

