/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.property;

import java.util.Optional;
import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.ContentProperty;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.UpdateNodeEvent;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.property.PropertyResolver;

public class ContentPropertyUpdated
extends PropertyDelta<String> {
    private String id;
    private String mimeType;
    private String sourceMimeType;
    private Long sourceSizeInBytes;
    private String sourceFileName;

    public ContentPropertyUpdated(String propertyName, String id, String mimeType, String sourceMimeType, Long sourceSizeInBytes, String sourceFileName) {
        super(propertyName);
        this.id = id;
        this.mimeType = mimeType;
        this.sourceMimeType = sourceMimeType;
        this.sourceSizeInBytes = sourceSizeInBytes;
        this.sourceFileName = sourceFileName;
    }

    @Override
    public void applyOn(UpdateNodeEvent event) {
        ContentProperty contentProperty = new ContentProperty(this.getPropertyName(), this.id, this.mimeType, this.sourceMimeType, this.sourceSizeInBytes, this.sourceFileName);
        event.addContentInstruction(contentProperty);
    }

    @Override
    public <R> Optional<PropertyDelta<R>> resolveWith(PropertyResolver<R> resolver) {
        return Optional.empty();
    }

    public static ContentPropertyUpdatedBuilder builder(String propertyName) {
        return new ContentPropertyUpdatedBuilder(propertyName);
    }

    @Override
    @Generated
    public String toString() {
        return "ContentPropertyUpdated(super=" + super.toString() + ", id=" + this.id + ", mimeType=" + this.mimeType + ", sourceMimeType=" + this.sourceMimeType + ", sourceSizeInBytes=" + this.sourceSizeInBytes + ", sourceFileName=" + this.sourceFileName + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentPropertyUpdated)) {
            return false;
        }
        ContentPropertyUpdated other = (ContentPropertyUpdated)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sourceSizeInBytes = this.sourceSizeInBytes;
        Long other$sourceSizeInBytes = other.sourceSizeInBytes;
        if (this$sourceSizeInBytes == null ? other$sourceSizeInBytes != null : !((Object)this$sourceSizeInBytes).equals(other$sourceSizeInBytes)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$mimeType = this.mimeType;
        String other$mimeType = other.mimeType;
        if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
            return false;
        }
        String this$sourceMimeType = this.sourceMimeType;
        String other$sourceMimeType = other.sourceMimeType;
        if (this$sourceMimeType == null ? other$sourceMimeType != null : !this$sourceMimeType.equals(other$sourceMimeType)) {
            return false;
        }
        String this$sourceFileName = this.sourceFileName;
        String other$sourceFileName = other.sourceFileName;
        return !(this$sourceFileName == null ? other$sourceFileName != null : !this$sourceFileName.equals(other$sourceFileName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContentPropertyUpdated;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sourceSizeInBytes = this.sourceSizeInBytes;
        result = result * 59 + ($sourceSizeInBytes == null ? 43 : ((Object)$sourceSizeInBytes).hashCode());
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $mimeType = this.mimeType;
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        String $sourceMimeType = this.sourceMimeType;
        result = result * 59 + ($sourceMimeType == null ? 43 : $sourceMimeType.hashCode());
        String $sourceFileName = this.sourceFileName;
        result = result * 59 + ($sourceFileName == null ? 43 : $sourceFileName.hashCode());
        return result;
    }

    public static class ContentPropertyUpdatedBuilder {
        private final String propertyName;
        private String id;
        private String mimeType;
        private String sourceMimeType;
        private Long sourceSizeInBytes;
        private String sourceFileName;

        public ContentPropertyUpdatedBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ContentPropertyUpdatedBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public ContentPropertyUpdatedBuilder sourceMimeType(String sourceMimeType) {
            this.sourceMimeType = sourceMimeType;
            return this;
        }

        public ContentPropertyUpdatedBuilder sourceSizeInBytes(Long sourceSizeInBytes) {
            this.sourceSizeInBytes = sourceSizeInBytes;
            return this;
        }

        public ContentPropertyUpdatedBuilder sourceFileName(String sourceFileName) {
            this.sourceFileName = sourceFileName;
            return this;
        }

        public ContentPropertyUpdated build() {
            return new ContentPropertyUpdated(this.propertyName, this.id, this.mimeType, this.sourceMimeType, this.sourceSizeInBytes, this.sourceFileName);
        }

        @Generated
        public ContentPropertyUpdatedBuilder(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

