/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.filter;

import java.util.List;
import lombok.Generated;
import org.alfresco.hxi_connector.common.repository.filter.FieldFilter;
import org.alfresco.hxi_connector.live_ingester.adapters.config.properties.Filter;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.filter.RepoEventFilterApplier;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TypeFilterApplier
implements RepoEventFilterApplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TypeFilterApplier.class);

    @Override
    public boolean isNodeAllowed(NodeResource nodeResource, Filter filter) {
        String nodeType = nodeResource.getNodeType();
        List<String> allowed = filter.type().allow();
        List<String> denied = filter.type().deny();
        log.atDebug().log("Filtering :: Applying type filters on node id: {}", (Object)nodeResource.getId());
        return FieldFilter.filter((String)nodeType, allowed, denied);
    }

    @Override
    public boolean isNodeBeforeAllowed(boolean currentlyAllowed, NodeResource nodeResourceBefore, Filter filter) {
        log.atDebug().log("Filtering :: Applying type filters on previous version of repo node id: {}", (Object)nodeResourceBefore.getId());
        String nodeType = nodeResourceBefore.getNodeType();
        if (nodeType == null) {
            return currentlyAllowed;
        }
        return this.isNodeAllowed(nodeResourceBefore, filter);
    }

    @Generated
    public TypeFilterApplier() {
    }
}

