/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.property;

import java.util.Optional;
import lombok.Generated;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.NodeProperty;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.UpdateNodeEvent;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.property.PropertyResolver;

public class PropertyUpdated<T>
extends PropertyDelta<T> {
    private final T propertyValue;

    public PropertyUpdated(String propertyName, T propertyValue) {
        super(propertyName);
        EnsureUtils.ensureNonNull(propertyValue, (String)"Property value cannot be null. Property name: %s", (Object[])new Object[]{propertyName});
        this.propertyValue = propertyValue;
    }

    public void applyOn(UpdateNodeEvent event) {
        event.addMetadataInstruction(new NodeProperty(this.getPropertyName(), this.propertyValue));
    }

    public <R> Optional<PropertyDelta<R>> resolveWith(PropertyResolver<R> resolver) {
        return resolver.resolveUpdated(this);
    }

    @Generated
    public T getPropertyValue() {
        return (T)this.propertyValue;
    }

    @Generated
    public String toString() {
        return "PropertyUpdated(super=" + super.toString() + ", propertyValue=" + String.valueOf(this.getPropertyValue()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyUpdated)) {
            return false;
        }
        PropertyUpdated other = (PropertyUpdated)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$propertyValue = this.getPropertyValue();
        Object other$propertyValue = other.getPropertyValue();
        return !(this$propertyValue == null ? other$propertyValue != null : !this$propertyValue.equals(other$propertyValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertyUpdated;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $propertyValue = this.getPropertyValue();
        result = result * 59 + ($propertyValue == null ? 43 : $propertyValue.hashCode());
        return result;
    }
}

