/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.config.properties;

import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.core5.http.MalformedChunkCodingException;
import org.apache.hc.core5.http.NoHttpResponseException;

public class Retry {
    private static final int RETRY_ATTEMPTS_DEFAULT = 10;
    private static final int RETRY_INITIAL_DELAY_DEFAULT = 500;
    private static final double RETRY_DELAY_MULTIPLIER_DEFAULT = 2.0;
    private static final Set<Class<? extends Throwable>> RETRY_REASONS_BASIC = Set.of(EndpointServerErrorException.class, UnknownHostException.class, MalformedURLException.class, JsonEOFException.class, MismatchedInputException.class);
    @Min(value=-1L)
    private @Min(value=-1L) int attempts;
    @PositiveOrZero
    private int initialDelay;
    @Positive
    private double delayMultiplier;
    @NotNull
    private Set<Class<? extends Throwable>> reasons;

    public Retry() {
        this(10, 500, 2.0);
    }

    public Retry(int attempts, int initialDelay, double delayMultiplier) {
        this(attempts, initialDelay, delayMultiplier, Stream.concat(RETRY_REASONS_BASIC.stream(), Stream.of(HttpHostConnectException.class, NoHttpResponseException.class, MalformedChunkCodingException.class)).collect(Collectors.toSet()));
    }

    public Retry(int attempts, int initialDelay, double delayMultiplier, Set<Class<? extends Throwable>> reasons) {
        this.attempts = attempts;
        this.initialDelay = initialDelay;
        this.delayMultiplier = delayMultiplier;
        this.reasons = reasons;
    }

    public int attempts() {
        return this.attempts;
    }

    public int initialDelay() {
        return this.initialDelay;
    }

    public double delayMultiplier() {
        return this.delayMultiplier;
    }

    public Set<Class<? extends Throwable>> reasons() {
        return this.reasons;
    }

    @Generated
    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    @Generated
    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    @Generated
    public void setDelayMultiplier(double delayMultiplier) {
        this.delayMultiplier = delayMultiplier;
    }

    @Generated
    public void setReasons(Set<Class<? extends Throwable>> reasons) {
        this.reasons = reasons;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Retry)) {
            return false;
        }
        Retry other = (Retry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.attempts != other.attempts) {
            return false;
        }
        if (this.initialDelay != other.initialDelay) {
            return false;
        }
        if (Double.compare(this.delayMultiplier, other.delayMultiplier) != 0) {
            return false;
        }
        Set<Class<? extends Throwable>> this$reasons = this.reasons;
        Set<Class<? extends Throwable>> other$reasons = other.reasons;
        return !(this$reasons == null ? other$reasons != null : !((Object)this$reasons).equals(other$reasons));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Retry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.attempts;
        result = result * 59 + this.initialDelay;
        long $delayMultiplier = Double.doubleToLongBits(this.delayMultiplier);
        result = result * 59 + (int)($delayMultiplier >>> 32 ^ $delayMultiplier);
        Set<Class<? extends Throwable>> $reasons = this.reasons;
        result = result * 59 + ($reasons == null ? 43 : ((Object)$reasons).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Retry(attempts=" + this.attempts + ", initialDelay=" + this.initialDelay + ", delayMultiplier=" + this.delayMultiplier + ", reasons=" + String.valueOf(this.reasons) + ")";
    }
}

