/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.service.util;

import java.net.http.HttpResponse;
import org.alfresco.hxi_connector.hxi_extension.service.util.HttpUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.extensions.webscripts.WebScriptException;

class HttpUtilsTest {
    HttpUtilsTest() {
    }

    @Test
    void shouldThrowIfStatusCodeDoesNotMatchExpected() {
        int expectedStatus = 200;
        int actualStatus = 500;
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)httpResponse.statusCode()).willReturn((Object)actualStatus);
        WebScriptException exception = (WebScriptException)Assertions.assertThrows(WebScriptException.class, () -> HttpUtils.ensureCorrectHttpStatusReturned((int)expectedStatus, (HttpResponse)httpResponse));
        Assertions.assertEquals((int)actualStatus, (int)exception.getStatus());
        Assertions.assertTrue((boolean)exception.getMessage().contains("Request to hxi failed, expected status 200, received 500"));
    }

    @Test
    void shouldDoNothingIfStatusCodeMatchesExpected() {
        int expectedStatus = 201;
        int actualStatus = 201;
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        BDDMockito.given((Object)httpResponse.statusCode()).willReturn((Object)actualStatus);
        HttpUtils.ensureCorrectHttpStatusReturned((int)expectedStatus, (HttpResponse)httpResponse);
    }
}

