/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.repository.filter;

import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldFilter.class);

    public static boolean filter(String nodeField, List<String> allowed, List<String> denied) {
        boolean allow = FieldFilter.isAllowed(nodeField, allowed);
        boolean deny = FieldFilter.isDenied(nodeField, denied);
        boolean result = allow && !deny;
        log.atDebug().log("Filtering :: Node field: {}. Allowed values: {}. Denied values: {}. Is allowed: {}", new Object[]{nodeField, allowed, denied, result});
        return result;
    }

    private static boolean isAllowed(@NotNull String nodeField, @NotNull List<String> allowed) {
        return allowed.isEmpty() || allowed.contains(nodeField);
    }

    private static boolean isDenied(@NotNull String nodeField, @NotNull List<String> denied) {
        return denied.contains(nodeField);
    }

    @Generated
    private FieldFilter() {
    }
}

