/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.util.Set;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.QuestionModel;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.RetryModel;
import org.alfresco.hxi_connector.hxi_extension.service.model.RestrictionQuery;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RetryModelSerializationTest {
    private final ObjectMapper objectMapper = new ObjectMapper();

    RetryModelSerializationTest() {
    }

    @Test
    void shouldThrowWhenQuestionIdSpecified() {
        String retrySerialised = "{\n    \"_questionId\": \"86553f9b-e382-4a1b-b07d-52adae3e96e8\",\n    \"comments\": \"This was not succinct enough!\",\n    \"originalQuestion\": {\n        \"restrictionQuery\": {\n            \"nodesIds\": [\"880a0f47-31b1-4101-b20b-4d325e54e8b1\"]\n        },\n        \"question\": \"Explain how the universe works\"\n    }\n}\n";
        Assertions.assertThrows(UnrecognizedPropertyException.class, () -> this.objectMapper.readValue(retrySerialised, RetryModel.class));
    }

    @Test
    void shouldThrowWhenQuestionIdSpecified2() {
        String retrySerialised = "{\n    \"questionId\": \"86553f9b-e382-4a1b-b07d-52adae3e96e8\",\n    \"comments\": \"This was not succinct enough!\",\n    \"originalQuestion\": {\n        \"restrictionQuery\": {\n            \"nodesIds\": [\"880a0f47-31b1-4101-b20b-4d325e54e8b1\"]\n        },\n        \"question\": \"Explain how the universe works\"\n    }\n}\n";
        Assertions.assertThrows(UnrecognizedPropertyException.class, () -> this.objectMapper.readValue(retrySerialised, RetryModel.class));
    }

    @Test
    void shouldDeserializeRetry() {
        String retrySerialised = "{\n    \"comments\": \"This was not succinct enough!\",\n    \"originalQuestion\": {\n        \"restrictionQuery\": {\n            \"nodesIds\": [\"880a0f47-31b1-4101-b20b-4d325e54e8b1\"]\n        },\n        \"question\": \"Explain how the universe works\"\n    }\n}\n";
        RetryModel retry = (RetryModel)this.objectMapper.readValue(retrySerialised, RetryModel.class);
        RetryModel expected = new RetryModel(null, "This was not succinct enough!", new QuestionModel(null, "Explain how the universe works", new RestrictionQuery(Set.of("880a0f47-31b1-4101-b20b-4d325e54e8b1"))));
        Assertions.assertEquals((Object)expected, (Object)retry);
    }
}

