/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.PredictionModel;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.ReviewStatus;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.UpdateType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredictionModelDeserializationTest {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Test
    void shouldThrowWhenIdSpecified() {
        String predictionModelSerialized = "{\n    \"_id\": \"86553f9b-e382-4a1b-b07d-52adae3e96e8\",\n    \"property\": \"property\",\n    \"predictionDateTime\": \"2023-01-01T00:00:00Z\",\n    \"confidenceLevel\": 0.8,\n    \"modelId\": \"modelId\",\n    \"predictionValue\": \"predictionValue\",\n    \"updateType\": \"AUTOFILL\",\n    \"reviewStatus\": \"UNREVIEWED\"\n}\n";
        Assertions.assertThrows(UnrecognizedPropertyException.class, () -> this.objectMapper.readValue(predictionModelSerialized, PredictionModel.class));
    }

    @Test
    void shouldThrowWhenPreviousValueSpecified() {
        String predictionModelSerialized = "{\n    \"property\": \"property\",\n    \"predictionDateTime\": \"2023-01-01T00:00:00Z\",\n    \"confidenceLevel\": 0.8,\n    \"modelId\": \"modelId\",\n    \"predictionValue\": \"predictionValue\",\n    \"_previousValue\": \"previousValue\",\n    \"updateType\": \"AUTOFILL\",\n    \"reviewStatus\": \"UNREVIEWED\"\n}\n";
        Assertions.assertThrows(UnrecognizedPropertyException.class, () -> this.objectMapper.readValue(predictionModelSerialized, PredictionModel.class));
    }

    @Test
    void shouldDeserializePredictionModel() {
        String predictionModelSerialized = "{\n    \"property\": \"property\",\n    \"predictionDateTime\": \"2023-01-01T00:00:00Z\",\n    \"confidenceLevel\": 0.8,\n    \"modelId\": \"modelId\",\n    \"predictionValue\": \"predictionValue\",\n    \"updateType\": \"AUTOFILL\",\n    \"reviewStatus\": \"UNREVIEWED\"\n}\n";
        PredictionModel predictionModel = (PredictionModel)this.objectMapper.readValue(predictionModelSerialized, PredictionModel.class);
        PredictionModel expected = new PredictionModel(null, "property", this.parseDateTime("2023-01-01T00:00:00Z"), 0.8f, "modelId", (Serializable)((Object)"predictionValue"), null, UpdateType.AUTOFILL, ReviewStatus.UNREVIEWED);
        Assertions.assertEquals((Object)expected, (Object)predictionModel);
    }

    private Date parseDateTime(String isoDate) {
        return Date.from(Instant.from(DateTimeFormatter.ISO_INSTANT.parse(isoDate)));
    }
}

