/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api.model;

import java.util.Collections;
import java.util.Set;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.AnswerModel;
import org.alfresco.hxi_connector.hxi_extension.service.model.AnswerResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class AnswerModelTest {
    AnswerModelTest() {
    }

    @ParameterizedTest
    @CsvSource(value={"COMPLETE,true", "INCOMPLETE,false", "SUBMITTED,false"})
    void testFromServiceModel(String responseCompleteness, boolean expectedComplete) {
        String answerText = "answer";
        String question = "Some question";
        String referenceId = "referenceId";
        double rankScore = 95.5;
        int rank = 1;
        AnswerResponse.Reference reference = AnswerResponse.Reference.builder().referenceId(referenceId).rankScore(rankScore).rank(rank).build();
        AnswerResponse.ObjectReference objectReference = AnswerResponse.ObjectReference.builder().objectId("objectId").references(Set.of(reference)).build();
        AnswerResponse answer = AnswerResponse.builder().answer(answerText).question(question).responseCompleteness(responseCompleteness).objectReferences(Set.of(objectReference)).build();
        AnswerModel.ReferenceModel expectedReference = AnswerModel.ReferenceModel.builder().referenceId(referenceId).rankScore(rankScore).rank(rank).build();
        AnswerModel.ObjectReferenceModel expectedObjectReference = AnswerModel.ObjectReferenceModel.builder().objectId("objectId").references(Set.of(expectedReference)).build();
        AnswerModel expectedModel = AnswerModel.builder().answer(answerText).question(question).isComplete(expectedComplete).objectReferences(Set.of(expectedObjectReference)).build();
        Assertions.assertEquals((Object)expectedModel, (Object)AnswerModel.fromServiceModel((AnswerResponse)answer));
    }

    @Test
    void testFromServiceModelNullReferences() {
        String answerText = "answer";
        String question = "Some question";
        AnswerResponse answer = AnswerResponse.builder().answer(answerText).question(question).objectReferences(null).build();
        AnswerModel expectedModel = AnswerModel.builder().answer(answerText).question(question).isComplete(false).objectReferences(Collections.emptySet()).build();
        Assertions.assertEquals((Object)expectedModel, (Object)AnswerModel.fromServiceModel((AnswerResponse)answer));
    }

    @Test
    void testFromServiceModelReference() {
        String referenceId = "referenceId";
        double rankScore = 95.5;
        int rank = 1;
        AnswerResponse.Reference reference = AnswerResponse.Reference.builder().referenceId(referenceId).rankScore(rankScore).rank(rank).build();
        AnswerModel.ReferenceModel expected = AnswerModel.ReferenceModel.builder().referenceId(referenceId).rankScore(rankScore).rank(rank).build();
        Assertions.assertEquals((Object)expected, (Object)AnswerModel.ReferenceModel.fromServiceModel((AnswerResponse.Reference)reference));
    }
}

