/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import org.alfresco.hxi_connector.hxi_extension.rest.api.model.AgentModel;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class AgentModelDeserializationTest {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Test
    void shouldThrowWhenIdSpecified() {
        String agentSerialized = "{\n    \"_id\": \"86553f9b-e382-4a1b-b07d-52adae3e96e8\",\n    \"name\": \"Agent name\",\n    \"description\": \"Agent description\"\n}\n";
        Assert.assertThrows(UnrecognizedPropertyException.class, () -> this.objectMapper.readValue(agentSerialized, AgentModel.class));
    }

    @Test
    void shouldDeserialiseAgent() {
        String agentSerialized = "{\n    \"name\": \"Agent name\",\n    \"description\": \"Agent description\",\n    \"avatarUrl\": \"https://example.com/avatar.png\"\n}\n";
        AgentModel agent = new AgentModel(null, "Agent name", "Agent description", "https://example.com/avatar.png");
        Assert.assertEquals((Object)agent, (Object)this.objectMapper.readValue(agentSerialized, AgentModel.class));
    }
}

