/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.client;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.hxi_connector.common.adapters.auth.config.properties.AuthProperties;
import org.alfresco.hxi_connector.common.config.properties.Retry;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.hxi_extension.client.HxInsightAuthClient;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.test.appender.ListAppender;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={MockitoExtension.class})
class HxInsightAuthClientTest {
    private static final String PROVIDER_ID = "some-provider";
    @Mock
    AuthProperties authPropertiesMock;
    @InjectMocks
    HxInsightAuthClient hxInsightAuthClient;
    ListAppender testAppender;
    LoggerConfig rootLoggerConfig;

    HxInsightAuthClientTest() {
    }

    @BeforeAll
    void beforeAll() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration loggerConfig = loggerContext.getConfiguration();
        this.testAppender = ListAppender.newBuilder().setName("test-appender").build();
        this.rootLoggerConfig = loggerConfig.getLoggerConfig("");
        this.rootLoggerConfig.setLevel(Level.INFO);
        this.rootLoggerConfig.addAppender((Appender)this.testAppender, Level.ALL, null);
    }

    @AfterAll
    void afterAll() {
        this.rootLoggerConfig.removeAppender(this.testAppender.getName());
    }

    @Test
    void givenAuthException_whenAuthenticate_thenFailAfterRetry() {
        Mockito.when((Object)this.authPropertiesMock.getRetry()).thenReturn((Object)((Retry)Mockito.mock(Retry.class)));
        Mockito.when((Object)this.authPropertiesMock.getRetry().attempts()).thenReturn((Object)3);
        Mockito.when((Object)this.authPropertiesMock.getRetry().initialDelay()).thenReturn((Object)500);
        Mockito.when((Object)this.authPropertiesMock.getRetry().delayMultiplier()).thenReturn((Object)2.0);
        Mockito.when((Object)this.authPropertiesMock.getRetry().reasons()).thenReturn(Set.of(EndpointServerErrorException.class));
        Mockito.when((Object)this.authPropertiesMock.getProviders()).thenReturn((Object)((Map)Mockito.mock(Map.class)));
        Mockito.when((Object)((AuthProperties.AuthProvider)this.authPropertiesMock.getProviders().get(PROVIDER_ID))).thenThrow(new Throwable[]{new EndpointServerErrorException("some error")});
        Throwable actualException = Assertions.catchThrowable(() -> this.hxInsightAuthClient.authenticate(PROVIDER_ID));
        Assertions.assertThat((Throwable)actualException).isInstanceOf(EndpointServerErrorException.class);
        ((ListAssert)Assertions.assertThat((List)this.testAppender.getEvents()).hasSize(3)).extracting(events -> events.getMessage().getFormattedMessage()).containsExactlyInAnyOrder((Object[])new String[]{"Attempt 1 of 3 failed, retrying after 500ms", "Attempt 2 of 3 failed, retrying after 1000ms", "Attempt 3 of 3 failed"});
    }
}

