/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util.DigestIdentifierParams;

public final class ContentUtils {
    public static String generateDigestIdentifier(DigestIdentifierParams params) {
        String input = params.nodeId() + "-" + params.propertyName() + "-" + params.versionNumber();
        try {
            MessageDigest digest = MessageDigest.getInstance(params.digestAlgorithm());
            byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Invalid digest identifier algorithm: " + params.digestAlgorithm(), e);
        }
    }

    @Generated
    private ContentUtils() {
    }
}

